/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.model.transform;

import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.com.amazonaws.SdkClientException;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.ServiceUtils;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.XmlWriter;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.AccessControlTranslation;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.BucketAccelerateConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.BucketReplicationConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.CORSRule;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.CloudFunctionConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.Filter;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.FilterRule;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.LambdaConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.NotificationConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.QueueConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.RedirectRule;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ReplicationDestinationConfig;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ReplicationRule;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.RoutingRule;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.RoutingRuleCondition;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.S3KeyFilter;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ServerSideEncryptionByDefault;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ServerSideEncryptionConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ServerSideEncryptionRule;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.SseKmsEncryptedObjects;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.Tag;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.TagSet;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.TopicConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.AnalyticsAndOperator;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.AnalyticsConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.AnalyticsExportDestination;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.AnalyticsFilter;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.AnalyticsFilterPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.AnalyticsPredicateVisitor;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.AnalyticsPrefixPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.AnalyticsS3BucketDestination;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.AnalyticsTagPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.StorageClassAnalysis;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.analytics.StorageClassAnalysisDataExport;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.inventory.InventoryConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.inventory.InventoryDestination;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.inventory.InventoryEncryption;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.inventory.InventoryFilter;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.inventory.InventoryFilterPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.inventory.InventoryPrefixPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.inventory.InventoryS3BucketDestination;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.inventory.InventorySchedule;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.inventory.ServerSideEncryptionKMS;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.inventory.ServerSideEncryptionS3;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecycleAndOperator;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecycleFilter;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecycleFilterPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecyclePredicateVisitor;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecyclePrefixPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecycleTagPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.metrics.MetricsAndOperator;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.metrics.MetricsConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.metrics.MetricsFilter;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.metrics.MetricsFilterPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.metrics.MetricsPredicateVisitor;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.metrics.MetricsPrefixPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.metrics.MetricsTagPredicate;
import org.gradle.internal.impldep.com.amazonaws.util.CollectionUtils;

public class BucketConfigurationXmlFactory {
    public byte[] convertToXmlByteArray(BucketVersioningConfiguration versioningConfiguration) {
        XmlWriter xml = new XmlWriter();
        xml.start("VersioningConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xml.start("Status").value(versioningConfiguration.getStatus()).end();
        Boolean mfaDeleteEnabled = versioningConfiguration.isMfaDeleteEnabled();
        if (mfaDeleteEnabled != null) {
            if (mfaDeleteEnabled.booleanValue()) {
                xml.start("MfaDelete").value("Enabled").end();
            } else {
                xml.start("MfaDelete").value("Disabled").end();
            }
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketAccelerateConfiguration accelerateConfiguration) {
        XmlWriter xml = new XmlWriter();
        xml.start("AccelerateConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xml.start("Status").value(accelerateConfiguration.getStatus()).end();
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketLoggingConfiguration loggingConfiguration) {
        String logFilePrefix = loggingConfiguration.getLogFilePrefix();
        if (logFilePrefix == null) {
            logFilePrefix = "";
        }
        XmlWriter xml = new XmlWriter();
        xml.start("BucketLoggingStatus", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (loggingConfiguration.isLoggingEnabled()) {
            xml.start("LoggingEnabled");
            xml.start("TargetBucket").value(loggingConfiguration.getDestinationBucketName()).end();
            xml.start("TargetPrefix").value(loggingConfiguration.getLogFilePrefix()).end();
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketNotificationConfiguration notificationConfiguration) {
        XmlWriter xml = new XmlWriter();
        xml.start("NotificationConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        Map<String, NotificationConfiguration> configurations = notificationConfiguration.getConfigurations();
        for (Map.Entry<String, NotificationConfiguration> entry : configurations.entrySet()) {
            String configName = entry.getKey();
            NotificationConfiguration config = entry.getValue();
            if (config instanceof TopicConfiguration) {
                xml.start("TopicConfiguration");
                xml.start("Id").value(configName).end();
                xml.start("Topic").value(((TopicConfiguration)config).getTopicARN()).end();
                this.addEventsAndFilterCriteria(xml, config);
                xml.end();
                continue;
            }
            if (config instanceof QueueConfiguration) {
                xml.start("QueueConfiguration");
                xml.start("Id").value(configName).end();
                xml.start("Queue").value(((QueueConfiguration)config).getQueueARN()).end();
                this.addEventsAndFilterCriteria(xml, config);
                xml.end();
                continue;
            }
            if (config instanceof CloudFunctionConfiguration) {
                xml.start("CloudFunctionConfiguration");
                xml.start("Id").value(configName).end();
                xml.start("InvocationRole").value(((CloudFunctionConfiguration)config).getInvocationRoleARN()).end();
                xml.start("CloudFunction").value(((CloudFunctionConfiguration)config).getCloudFunctionARN()).end();
                this.addEventsAndFilterCriteria(xml, config);
                xml.end();
                continue;
            }
            if (!(config instanceof LambdaConfiguration)) continue;
            xml.start("CloudFunctionConfiguration");
            xml.start("Id").value(configName).end();
            xml.start("CloudFunction").value(((LambdaConfiguration)config).getFunctionARN()).end();
            this.addEventsAndFilterCriteria(xml, config);
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    private void addEventsAndFilterCriteria(XmlWriter xml, NotificationConfiguration config) {
        for (String event : config.getEvents()) {
            xml.start("Event").value(event).end();
        }
        Filter filter = config.getFilter();
        if (filter != null) {
            this.validateFilter(filter);
            xml.start("Filter");
            if (filter.getS3KeyFilter() != null) {
                this.validateS3KeyFilter(filter.getS3KeyFilter());
                xml.start("S3Key");
                for (FilterRule filterRule : filter.getS3KeyFilter().getFilterRules()) {
                    xml.start("FilterRule");
                    xml.start("Name").value(filterRule.getName()).end();
                    xml.start("Value").value(filterRule.getValue()).end();
                    xml.end();
                }
                xml.end();
            }
            xml.end();
        }
    }

    private void validateFilter(Filter filter) {
        if (filter.getS3KeyFilter() == null) {
            throw new SdkClientException("Cannot have a Filter without any criteria");
        }
    }

    private void validateS3KeyFilter(S3KeyFilter s3KeyFilter) {
        if (CollectionUtils.isNullOrEmpty(s3KeyFilter.getFilterRules())) {
            throw new SdkClientException("Cannot have an S3KeyFilter without any filter rules");
        }
    }

    public byte[] convertToXmlByteArray(BucketReplicationConfiguration replicationConfiguration) {
        XmlWriter xml = new XmlWriter();
        xml.start("ReplicationConfiguration");
        Map<String, ReplicationRule> rules = replicationConfiguration.getRules();
        String role = replicationConfiguration.getRoleARN();
        xml.start("Role").value(role).end();
        for (Map.Entry<String, ReplicationRule> entry : rules.entrySet()) {
            AccessControlTranslation accessControlTranslation;
            String ruleId = entry.getKey();
            ReplicationRule rule = entry.getValue();
            xml.start("Rule");
            xml.start("ID").value(ruleId).end();
            xml.start("Prefix").value(rule.getPrefix()).end();
            xml.start("Status").value(rule.getStatus()).end();
            if (rule.getSourceSelectionCriteria() != null) {
                xml.start("SourceSelectionCriteria");
                SseKmsEncryptedObjects sseKmsEncryptedObjects = rule.getSourceSelectionCriteria().getSseKmsEncryptedObjects();
                if (sseKmsEncryptedObjects != null) {
                    xml.start("SseKmsEncryptedObjects");
                    this.addParameterIfNotNull(xml, "Status", sseKmsEncryptedObjects.getStatus());
                    xml.end();
                }
                xml.end();
            }
            ReplicationDestinationConfig config = rule.getDestinationConfig();
            xml.start("Destination");
            xml.start("Bucket").value(config.getBucketARN()).end();
            this.addParameterIfNotNull(xml, "Account", config.getAccount());
            if (config.getStorageClass() != null) {
                xml.start("StorageClass").value(config.getStorageClass()).end();
            }
            if ((accessControlTranslation = config.getAccessControlTranslation()) != null) {
                xml.start("AccessControlTranslation");
                this.addParameterIfNotNull(xml, "Owner", accessControlTranslation.getOwner());
                xml.end();
            }
            if (config.getEncryptionConfiguration() != null) {
                xml.start("EncryptionConfiguration");
                this.addParameterIfNotNull(xml, "ReplicaKmsKeyID", config.getEncryptionConfiguration().getReplicaKmsKeyID());
                xml.end();
            }
            xml.end();
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketWebsiteConfiguration websiteConfiguration) {
        RedirectRule redirectAllRequestsTo;
        XmlWriter xml = new XmlWriter();
        xml.start("WebsiteConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (websiteConfiguration.getIndexDocumentSuffix() != null) {
            XmlWriter indexDocumentElement = xml.start("IndexDocument");
            indexDocumentElement.start("Suffix").value(websiteConfiguration.getIndexDocumentSuffix()).end();
            indexDocumentElement.end();
        }
        if (websiteConfiguration.getErrorDocument() != null) {
            XmlWriter errorDocumentElement = xml.start("ErrorDocument");
            errorDocumentElement.start("Key").value(websiteConfiguration.getErrorDocument()).end();
            errorDocumentElement.end();
        }
        if ((redirectAllRequestsTo = websiteConfiguration.getRedirectAllRequestsTo()) != null) {
            XmlWriter redirectAllRequestsElement = xml.start("RedirectAllRequestsTo");
            if (redirectAllRequestsTo.getprotocol() != null) {
                xml.start("Protocol").value(redirectAllRequestsTo.getprotocol()).end();
            }
            if (redirectAllRequestsTo.getHostName() != null) {
                xml.start("HostName").value(redirectAllRequestsTo.getHostName()).end();
            }
            if (redirectAllRequestsTo.getReplaceKeyPrefixWith() != null) {
                xml.start("ReplaceKeyPrefixWith").value(redirectAllRequestsTo.getReplaceKeyPrefixWith()).end();
            }
            if (redirectAllRequestsTo.getReplaceKeyWith() != null) {
                xml.start("ReplaceKeyWith").value(redirectAllRequestsTo.getReplaceKeyWith()).end();
            }
            redirectAllRequestsElement.end();
        }
        if (websiteConfiguration.getRoutingRules() != null && websiteConfiguration.getRoutingRules().size() > 0) {
            XmlWriter routingRules = xml.start("RoutingRules");
            for (RoutingRule rule : websiteConfiguration.getRoutingRules()) {
                this.writeRule(routingRules, rule);
            }
            routingRules.end();
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketLifecycleConfiguration config) throws SdkClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("LifecycleConfiguration");
        for (BucketLifecycleConfiguration.Rule rule : config.getRules()) {
            this.writeRule(xml, rule);
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketCrossOriginConfiguration config) throws SdkClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("CORSConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        for (CORSRule rule : config.getRules()) {
            this.writeRule(xml, rule);
        }
        xml.end();
        return xml.getBytes();
    }

    private void writeRule(XmlWriter xml, BucketLifecycleConfiguration.Rule rule) {
        xml.start("Rule");
        if (rule.getId() != null) {
            xml.start("ID").value(rule.getId()).end();
        }
        this.writePrefix(xml, rule);
        xml.start("Status").value(rule.getStatus()).end();
        this.writeLifecycleFilter(xml, rule.getFilter());
        this.addTransitions(xml, rule.getTransitions());
        this.addNoncurrentTransitions(xml, rule.getNoncurrentVersionTransitions());
        if (this.hasCurrentExpirationPolicy(rule)) {
            xml.start("Expiration");
            if (rule.getExpirationInDays() != -1) {
                xml.start("Days").value("" + rule.getExpirationInDays()).end();
            }
            if (rule.getExpirationDate() != null) {
                xml.start("Date").value(ServiceUtils.formatIso8601Date(rule.getExpirationDate())).end();
            }
            if (rule.isExpiredObjectDeleteMarker()) {
                xml.start("ExpiredObjectDeleteMarker").value("true").end();
            }
            xml.end();
        }
        if (rule.getNoncurrentVersionExpirationInDays() != -1) {
            xml.start("NoncurrentVersionExpiration");
            xml.start("NoncurrentDays").value(Integer.toString(rule.getNoncurrentVersionExpirationInDays())).end();
            xml.end();
        }
        if (rule.getAbortIncompleteMultipartUpload() != null) {
            xml.start("AbortIncompleteMultipartUpload");
            xml.start("DaysAfterInitiation").value(Integer.toString(rule.getAbortIncompleteMultipartUpload().getDaysAfterInitiation())).end();
            xml.end();
        }
        xml.end();
    }

    private void addTransitions(XmlWriter xml, List<BucketLifecycleConfiguration.Transition> transitions) {
        if (transitions == null || transitions.isEmpty()) {
            return;
        }
        for (BucketLifecycleConfiguration.Transition t : transitions) {
            if (t == null) continue;
            xml.start("Transition");
            if (t.getDate() != null) {
                xml.start("Date");
                xml.value(ServiceUtils.formatIso8601Date(t.getDate()));
                xml.end();
            }
            if (t.getDays() != -1) {
                xml.start("Days");
                xml.value(Integer.toString(t.getDays()));
                xml.end();
            }
            xml.start("StorageClass");
            xml.value(t.getStorageClass().toString());
            xml.end();
            xml.end();
        }
    }

    private void addNoncurrentTransitions(XmlWriter xml, List<BucketLifecycleConfiguration.NoncurrentVersionTransition> transitions) {
        if (transitions == null || transitions.isEmpty()) {
            return;
        }
        for (BucketLifecycleConfiguration.NoncurrentVersionTransition t : transitions) {
            if (t == null) continue;
            xml.start("NoncurrentVersionTransition");
            if (t.getDays() != -1) {
                xml.start("NoncurrentDays");
                xml.value(Integer.toString(t.getDays()));
                xml.end();
            }
            xml.start("StorageClass");
            xml.value(t.getStorageClass().toString());
            xml.end();
            xml.end();
        }
    }

    private void writeLifecycleFilter(XmlWriter xml, LifecycleFilter filter) {
        if (filter == null) {
            return;
        }
        xml.start("Filter");
        this.writeLifecycleFilterPredicate(xml, filter.getPredicate());
        xml.end();
    }

    private void writeLifecycleFilterPredicate(XmlWriter xml, LifecycleFilterPredicate predicate) {
        if (predicate == null) {
            return;
        }
        predicate.accept(new LifecyclePredicateVisitorImpl(xml));
    }

    public byte[] convertToXmlByteArray(ServerSideEncryptionConfiguration sseConfig) {
        XmlWriter xml = new XmlWriter();
        xml.start("ServerSideEncryptionConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        for (ServerSideEncryptionRule rule : sseConfig.getRules()) {
            xml.start("Rule");
            this.writeServerSideEncryptionByDefault(xml, rule.getApplyServerSideEncryptionByDefault());
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    private void writeServerSideEncryptionByDefault(XmlWriter xml, ServerSideEncryptionByDefault sseByDefault) {
        if (sseByDefault == null) {
            return;
        }
        xml.start("ApplyServerSideEncryptionByDefault");
        this.addParameterIfNotNull(xml, "SSEAlgorithm", sseByDefault.getSSEAlgorithm());
        this.addParameterIfNotNull(xml, "KMSMasterKeyID", sseByDefault.getKMSMasterKeyID());
        xml.end();
    }

    private boolean hasCurrentExpirationPolicy(BucketLifecycleConfiguration.Rule rule) {
        return rule.getExpirationInDays() != -1 || rule.getExpirationDate() != null || rule.isExpiredObjectDeleteMarker();
    }

    private void writeRule(XmlWriter xml, CORSRule rule) {
        xml.start("CORSRule");
        if (rule.getId() != null) {
            xml.start("ID").value(rule.getId()).end();
        }
        if (rule.getAllowedOrigins() != null) {
            for (String origin : rule.getAllowedOrigins()) {
                xml.start("AllowedOrigin").value(origin).end();
            }
        }
        if (rule.getAllowedMethods() != null) {
            for (CORSRule.AllowedMethods method : rule.getAllowedMethods()) {
                xml.start("AllowedMethod").value(method.toString()).end();
            }
        }
        if (rule.getMaxAgeSeconds() != 0) {
            xml.start("MaxAgeSeconds").value(Integer.toString(rule.getMaxAgeSeconds())).end();
        }
        if (rule.getExposedHeaders() != null) {
            for (String header : rule.getExposedHeaders()) {
                xml.start("ExposeHeader").value(header).end();
            }
        }
        if (rule.getAllowedHeaders() != null) {
            for (String header : rule.getAllowedHeaders()) {
                xml.start("AllowedHeader").value(header).end();
            }
        }
        xml.end();
    }

    private void writeRule(XmlWriter xml, RoutingRule rule) {
        xml.start("RoutingRule");
        RoutingRuleCondition condition = rule.getCondition();
        if (condition != null) {
            xml.start("Condition");
            xml.start("KeyPrefixEquals");
            if (condition.getKeyPrefixEquals() != null) {
                xml.value(condition.getKeyPrefixEquals());
            }
            xml.end();
            if (condition.getHttpErrorCodeReturnedEquals() != null) {
                xml.start("HttpErrorCodeReturnedEquals ").value(condition.getHttpErrorCodeReturnedEquals()).end();
            }
            xml.end();
        }
        xml.start("Redirect");
        RedirectRule redirect = rule.getRedirect();
        if (redirect != null) {
            if (redirect.getprotocol() != null) {
                xml.start("Protocol").value(redirect.getprotocol()).end();
            }
            if (redirect.getHostName() != null) {
                xml.start("HostName").value(redirect.getHostName()).end();
            }
            if (redirect.getReplaceKeyPrefixWith() != null) {
                xml.start("ReplaceKeyPrefixWith").value(redirect.getReplaceKeyPrefixWith()).end();
            }
            if (redirect.getReplaceKeyWith() != null) {
                xml.start("ReplaceKeyWith").value(redirect.getReplaceKeyWith()).end();
            }
            if (redirect.getHttpRedirectCode() != null) {
                xml.start("HttpRedirectCode").value(redirect.getHttpRedirectCode()).end();
            }
        }
        xml.end();
        xml.end();
    }

    public byte[] convertToXmlByteArray(BucketTaggingConfiguration config) throws SdkClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("Tagging");
        for (TagSet tagset : config.getAllTagSets()) {
            this.writeRule(xml, tagset);
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(InventoryConfiguration config) throws SdkClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("InventoryConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xml.start("Id").value(config.getId()).end();
        xml.start("IsEnabled").value(String.valueOf(config.isEnabled())).end();
        xml.start("IncludedObjectVersions").value(config.getIncludedObjectVersions()).end();
        this.writeInventoryDestination(xml, config.getDestination());
        this.writeInventoryFilter(xml, config.getInventoryFilter());
        this.addInventorySchedule(xml, config.getSchedule());
        this.addInventoryOptionalFields(xml, config.getOptionalFields());
        xml.end();
        return xml.getBytes();
    }

    private void writeInventoryDestination(XmlWriter xml, InventoryDestination destination) {
        if (destination == null) {
            return;
        }
        xml.start("Destination");
        InventoryS3BucketDestination s3BucketDestination = destination.getS3BucketDestination();
        if (s3BucketDestination != null) {
            xml.start("S3BucketDestination");
            this.addParameterIfNotNull(xml, "AccountId", s3BucketDestination.getAccountId());
            this.addParameterIfNotNull(xml, "Bucket", s3BucketDestination.getBucketArn());
            this.addParameterIfNotNull(xml, "Prefix", s3BucketDestination.getPrefix());
            this.addParameterIfNotNull(xml, "Format", s3BucketDestination.getFormat());
            this.writeInventoryEncryption(xml, s3BucketDestination.getEncryption());
            xml.end();
        }
        xml.end();
    }

    private void writeInventoryEncryption(XmlWriter xml, InventoryEncryption encryption) {
        if (encryption == null) {
            return;
        }
        xml.start("Encryption");
        if (encryption instanceof ServerSideEncryptionS3) {
            xml.start("SSE-S3").end();
        } else if (encryption instanceof ServerSideEncryptionKMS) {
            xml.start("SSE-KMS");
            this.addParameterIfNotNull(xml, "KeyId", ((ServerSideEncryptionKMS)encryption).getKeyId());
            xml.end();
        }
        xml.end();
    }

    private void writeInventoryFilter(XmlWriter xml, InventoryFilter inventoryFilter) {
        if (inventoryFilter == null) {
            return;
        }
        xml.start("Filter");
        this.writeInventoryFilterPredicate(xml, inventoryFilter.getPredicate());
        xml.end();
    }

    private void writeInventoryFilterPredicate(XmlWriter xml, InventoryFilterPredicate predicate) {
        if (predicate == null) {
            return;
        }
        if (predicate instanceof InventoryPrefixPredicate) {
            this.writePrefix(xml, ((InventoryPrefixPredicate)predicate).getPrefix());
        }
    }

    private void addInventorySchedule(XmlWriter xml, InventorySchedule schedule) {
        if (schedule == null) {
            return;
        }
        xml.start("Schedule");
        this.addParameterIfNotNull(xml, "Frequency", schedule.getFrequency());
        xml.end();
    }

    private void addInventoryOptionalFields(XmlWriter xml, List<String> optionalFields) {
        if (CollectionUtils.isNullOrEmpty(optionalFields)) {
            return;
        }
        xml.start("OptionalFields");
        for (String field : optionalFields) {
            xml.start("Field").value(field).end();
        }
        xml.end();
    }

    private void writeRule(XmlWriter xml, TagSet tagset) {
        xml.start("TagSet");
        for (String key : tagset.getAllTags().keySet()) {
            xml.start("Tag");
            xml.start("Key").value(key).end();
            xml.start("Value").value(tagset.getTag(key)).end();
            xml.end();
        }
        xml.end();
    }

    private boolean hasTags(TagSet tagSet) {
        return tagSet != null && tagSet.getAllTags() != null && tagSet.getAllTags().size() > 0;
    }

    public byte[] convertToXmlByteArray(AnalyticsConfiguration config) throws SdkClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("AnalyticsConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        this.addParameterIfNotNull(xml, "Id", config.getId());
        this.writeAnalyticsFilter(xml, config.getFilter());
        this.writeStorageClassAnalysis(xml, config.getStorageClassAnalysis());
        xml.end();
        return xml.getBytes();
    }

    private void writeAnalyticsFilter(XmlWriter xml, AnalyticsFilter filter) {
        if (filter == null) {
            return;
        }
        xml.start("Filter");
        this.writeAnalyticsFilterPredicate(xml, filter.getPredicate());
        xml.end();
    }

    private void writeAnalyticsFilterPredicate(XmlWriter xml, AnalyticsFilterPredicate predicate) {
        if (predicate == null) {
            return;
        }
        predicate.accept(new AnalyticsPredicateVisitorImpl(xml));
    }

    private void writeStorageClassAnalysis(XmlWriter xml, StorageClassAnalysis storageClassAnalysis) {
        if (storageClassAnalysis == null) {
            return;
        }
        xml.start("StorageClassAnalysis");
        if (storageClassAnalysis.getDataExport() != null) {
            StorageClassAnalysisDataExport dataExport = storageClassAnalysis.getDataExport();
            xml.start("DataExport");
            this.addParameterIfNotNull(xml, "OutputSchemaVersion", dataExport.getOutputSchemaVersion());
            this.writeAnalyticsExportDestination(xml, dataExport.getDestination());
            xml.end();
        }
        xml.end();
    }

    private void writeAnalyticsExportDestination(XmlWriter xml, AnalyticsExportDestination destination) {
        if (destination == null) {
            return;
        }
        xml.start("Destination");
        if (destination.getS3BucketDestination() != null) {
            xml.start("S3BucketDestination");
            AnalyticsS3BucketDestination s3BucketDestination = destination.getS3BucketDestination();
            this.addParameterIfNotNull(xml, "Format", s3BucketDestination.getFormat());
            this.addParameterIfNotNull(xml, "BucketAccountId", s3BucketDestination.getBucketAccountId());
            this.addParameterIfNotNull(xml, "Bucket", s3BucketDestination.getBucketArn());
            this.addParameterIfNotNull(xml, "Prefix", s3BucketDestination.getPrefix());
            xml.end();
        }
        xml.end();
    }

    public byte[] convertToXmlByteArray(MetricsConfiguration config) throws SdkClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("MetricsConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        this.addParameterIfNotNull(xml, "Id", config.getId());
        this.writeMetricsFilter(xml, config.getFilter());
        xml.end();
        return xml.getBytes();
    }

    private void writeMetricsFilter(XmlWriter xml, MetricsFilter filter) {
        if (filter == null) {
            return;
        }
        xml.start("Filter");
        this.writeMetricsFilterPredicate(xml, filter.getPredicate());
        xml.end();
    }

    private void writeMetricsFilterPredicate(XmlWriter xml, MetricsFilterPredicate predicate) {
        if (predicate == null) {
            return;
        }
        predicate.accept(new MetricsPredicateVisitorImpl(xml));
    }

    private void addParameterIfNotNull(XmlWriter xml, String xmlTagName, String value) {
        if (value != null) {
            xml.start(xmlTagName).value(value).end();
        }
    }

    private void writePrefix(XmlWriter xml, BucketLifecycleConfiguration.Rule rule) {
        if (rule.getFilter() == null) {
            xml.start("Prefix").value(rule.getPrefix() == null ? "" : rule.getPrefix()).end();
        } else if (rule.getPrefix() != null) {
            throw new IllegalArgumentException("Prefix cannot be used with Filter. Use LifecyclePrefixPredicate to create a LifecycleFilter");
        }
    }

    private void writePrefix(XmlWriter xml, String prefix) {
        this.addParameterIfNotNull(xml, "Prefix", prefix);
    }

    private void writeTag(XmlWriter xml, Tag tag) {
        if (tag == null) {
            return;
        }
        xml.start("Tag");
        xml.start("Key").value(tag.getKey()).end();
        xml.start("Value").value(tag.getValue()).end();
        xml.end();
    }

    private class MetricsPredicateVisitorImpl
    implements MetricsPredicateVisitor {
        private final XmlWriter xml;

        public MetricsPredicateVisitorImpl(XmlWriter xml) {
            this.xml = xml;
        }

        @Override
        public void visit(MetricsPrefixPredicate metricsPrefixPredicate) {
            BucketConfigurationXmlFactory.this.writePrefix(this.xml, metricsPrefixPredicate.getPrefix());
        }

        @Override
        public void visit(MetricsTagPredicate metricsTagPredicate) {
            BucketConfigurationXmlFactory.this.writeTag(this.xml, metricsTagPredicate.getTag());
        }

        @Override
        public void visit(MetricsAndOperator metricsAndOperator) {
            this.xml.start("And");
            for (MetricsFilterPredicate predicate : metricsAndOperator.getOperands()) {
                predicate.accept(this);
            }
            this.xml.end();
        }
    }

    private class AnalyticsPredicateVisitorImpl
    implements AnalyticsPredicateVisitor {
        private final XmlWriter xml;

        public AnalyticsPredicateVisitorImpl(XmlWriter xml) {
            this.xml = xml;
        }

        @Override
        public void visit(AnalyticsPrefixPredicate analyticsPrefixPredicate) {
            BucketConfigurationXmlFactory.this.writePrefix(this.xml, analyticsPrefixPredicate.getPrefix());
        }

        @Override
        public void visit(AnalyticsTagPredicate analyticsTagPredicate) {
            BucketConfigurationXmlFactory.this.writeTag(this.xml, analyticsTagPredicate.getTag());
        }

        @Override
        public void visit(AnalyticsAndOperator analyticsAndOperator) {
            this.xml.start("And");
            for (AnalyticsFilterPredicate predicate : analyticsAndOperator.getOperands()) {
                predicate.accept(this);
            }
            this.xml.end();
        }
    }

    private class LifecyclePredicateVisitorImpl
    implements LifecyclePredicateVisitor {
        private final XmlWriter xml;

        public LifecyclePredicateVisitorImpl(XmlWriter xml) {
            this.xml = xml;
        }

        @Override
        public void visit(LifecyclePrefixPredicate lifecyclePrefixPredicate) {
            BucketConfigurationXmlFactory.this.writePrefix(this.xml, lifecyclePrefixPredicate.getPrefix());
        }

        @Override
        public void visit(LifecycleTagPredicate lifecycleTagPredicate) {
            BucketConfigurationXmlFactory.this.writeTag(this.xml, lifecycleTagPredicate.getTag());
        }

        @Override
        public void visit(LifecycleAndOperator lifecycleAndOperator) {
            this.xml.start("And");
            for (LifecycleFilterPredicate predicate : lifecycleAndOperator.getOperands()) {
                predicate.accept(this);
            }
            this.xml.end();
        }
    }
}

