/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.asm.tree.AbstractInsnNode;
import org.jacoco.asm.tree.MethodNode;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;

public class KotlinGeneratedFilter
implements IFilter {
    static final String KOTLIN_METADATA_DESC = "Lkotlin/Metadata;";

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (context.getSourceFileName() == null) {
            return;
        }
        if (!context.getClassAnnotations().contains(KOTLIN_METADATA_DESC)) {
            return;
        }
        if (this.hasLineNumber(methodNode)) {
            return;
        }
        output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
    }

    private boolean hasLineNumber(MethodNode methodNode) {
        for (AbstractInsnNode i = methodNode.instructions.getFirst(); i != null; i = i.getNext()) {
            if (15 != i.getType()) continue;
            return true;
        }
        return false;
    }
}

