/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.keymap.impl.ui.EditKeymapsDialog;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;
import org.jetbrains.idea.maven.tasks.MavenKeymapExtension;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class AssignShortcutAction
extends MavenAction {
    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        if (e == null) {
            AssignShortcutAction.$$$reportNull$$$0(0);
        }
        DataContext context = e.getDataContext();
        return super.isAvailable(e) && !AssignShortcutAction.isIgnoredProject(context) && AssignShortcutAction.getGoalActionId(context) != null;
    }

    private static boolean isIgnoredProject(DataContext context) {
        MavenProject project = MavenActionUtil.getMavenProject(context);
        if (project == null) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context);
        return projectsManager != null && projectsManager.isIgnored(project);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AssignShortcutAction.$$$reportNull$$$0(1);
        }
        MavenActionsUsagesCollector.trigger(e.getProject(), this, e, new String[0]);
        DataContext context = e.getDataContext();
        String actionId = AssignShortcutAction.getGoalActionId(context);
        if (actionId != null) {
            new EditKeymapsDialog(MavenActionUtil.getProject(context), actionId).show();
        }
    }

    @Nullable
    private static String getGoalActionId(DataContext context) {
        AnAction action;
        String actionId;
        List goals = (List)MavenDataKeys.MAVEN_GOALS.getData(context);
        if (goals == null || goals.size() != 1) {
            return null;
        }
        MavenProject project = MavenActionUtil.getMavenProject(context);
        if (project == null) {
            return null;
        }
        String goal = (String)goals.get(0);
        MavenShortcutsManager shortcutsManager = AssignShortcutAction.getShortcutsManager(context);
        String string = actionId = shortcutsManager != null ? shortcutsManager.getActionId(project.getPath(), goal) : null;
        if (actionId != null && (action = ActionManager.getInstance().getAction(actionId)) == null) {
            MavenKeymapExtension.getOrRegisterAction(project, actionId, goal);
        }
        return actionId;
    }

    @Nullable
    protected static MavenShortcutsManager getShortcutsManager(DataContext context) {
        Project project = MavenActionUtil.getProject(context);
        if (project == null) {
            return null;
        }
        return MavenShortcutsManager.getInstance(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/maven/tasks/actions/AssignShortcutAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

