/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class MavenIndices {
    private final MavenIndexerWrapper myIndexer;
    private final File myIndicesDir;
    private final MavenIndex.IndexListener myListener;
    private final List<MavenIndex> myIndices = new ArrayList<MavenIndex>();
    private static final Object ourDirectoryLock = new Object();

    public MavenIndices(MavenIndexerWrapper indexer, File indicesDir, MavenIndex.IndexListener listener) {
        this.myIndexer = indexer;
        this.myIndicesDir = indicesDir;
        this.myListener = listener;
        this.load();
    }

    private void load() {
        Object[] indices = this.myIndicesDir.listFiles();
        if (indices == null) {
            return;
        }
        Arrays.sort(indices);
        for (Object each : indices) {
            if (!((File)each).isDirectory()) continue;
            try {
                MavenIndex index = new MavenIndex(this.myIndexer, (File)each, this.myListener);
                if (this.find(index.getRepositoryPathOrUrl(), index.getKind()) != null) {
                    index.close(true);
                    FileUtil.delete((File)each);
                    continue;
                }
                this.myIndices.add(index);
            }
            catch (Exception e) {
                FileUtil.delete((File)each);
                MavenLog.LOG.warn((Throwable)e);
            }
        }
    }

    public synchronized void close() {
        for (MavenIndex each : this.myIndices) {
            each.close(false);
        }
        this.myIndices.clear();
    }

    public synchronized List<MavenIndex> getIndices() {
        return new ArrayList<MavenIndex>(this.myIndices);
    }

    public synchronized MavenIndex add(String repositoryId, String repositoryPathOrUrl, MavenIndex.Kind kind) throws MavenIndexException {
        MavenIndex index = this.find(repositoryPathOrUrl, kind);
        if (index != null) {
            index.registerId(repositoryId);
            return index;
        }
        File dir = this.createNewIndexDir();
        index = new MavenIndex(this.myIndexer, dir, repositoryId, repositoryPathOrUrl, kind, this.myListener);
        this.myIndices.add(index);
        return index;
    }

    @Nullable
    public MavenIndex find(String repositoryPathOrUrl, MavenIndex.Kind kind) {
        for (MavenIndex each : this.myIndices) {
            if (!each.isFor(kind, repositoryPathOrUrl)) continue;
            return each;
        }
        return null;
    }

    private File createNewIndexDir() {
        return MavenIndices.createNewDir(this.myIndicesDir, "Index", 1000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static File createNewDir(File parent, String prefix, int max) {
        Object object = ourDirectoryLock;
        synchronized (object) {
            int i = 0;
            while (true) {
                boolean createSuccessFull;
                if (i >= max) {
                    throw new RuntimeException("No available dir found");
                }
                String name = prefix + i;
                File f = new File(parent, name);
                if (!f.exists() && (createSuccessFull = f.mkdirs())) {
                    File file = f;
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (file == null) {
                        MavenIndices.$$$reportNull$$$0(0);
                    }
                    return file;
                }
                ++i;
            }
        }
    }

    public static void updateOrRepair(MavenIndex index, boolean fullUpdate, MavenGeneralSettings settings, MavenProgressIndicator progress) throws MavenProcessCanceledException {
        index.updateOrRepair(fullUpdate, settings, progress);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/indices/MavenIndices", "createNewDir"));
    }
}

