/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.indices.MavenSearcher;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;

public class MavenArtifactSearcher
extends MavenSearcher<MavenArtifactSearchResult> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("[.\\d]+");

    @Override
    protected List<MavenArtifactSearchResult> searchImpl(Project project, String pattern, int maxResult) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String each : StringUtil.tokenize((String)pattern, (String)" :")) {
            parts.add(StringUtil.trimStart((String)StringUtil.trimEnd((String)each, (String)"*"), (String)"*"));
        }
        List searchResults = ContainerUtil.newSmartList();
        MavenProjectIndicesManager m = MavenProjectIndicesManager.getInstance(project);
        int count = 0;
        ArrayList<MavenArtifactInfo> versions = new ArrayList<MavenArtifactInfo>();
        block1: for (String groupId : m.getGroupIds()) {
            if (count >= maxResult) break;
            if (parts.size() >= 1 && !StringUtil.contains((CharSequence)groupId, (CharSequence)((CharSequence)parts.get(0)))) continue;
            for (String artifactId : m.getArtifactIds(groupId)) {
                if (parts.size() < 2 || StringUtil.contains((CharSequence)artifactId, (CharSequence)((CharSequence)parts.get(1)))) {
                    for (String version : m.getVersions(groupId, artifactId)) {
                        if (parts.size() >= 3 && !StringUtil.contains((CharSequence)version, (CharSequence)((CharSequence)parts.get(2)))) continue;
                        versions.add(new MavenArtifactInfo(groupId, artifactId, version, "jar", null));
                        if (++count < maxResult) continue;
                        break;
                    }
                } else if (parts.size() == 2 && VERSION_PATTERN.matcher((CharSequence)parts.get(1)).matches()) {
                    for (String version : m.getVersions(groupId, artifactId)) {
                        if (!StringUtil.contains((CharSequence)version, (CharSequence)((CharSequence)parts.get(1)))) continue;
                        versions.add(new MavenArtifactInfo(groupId, artifactId, version, "jar", null));
                        if (++count < maxResult) continue;
                        break;
                    }
                }
                if (!versions.isEmpty()) {
                    MavenArtifactSearchResult searchResult = new MavenArtifactSearchResult();
                    searchResult.versions.addAll(versions);
                    searchResults.add(searchResult);
                    versions.clear();
                }
                if (count < maxResult) continue;
                continue block1;
            }
        }
        return searchResults;
    }
}

