/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.AntMessage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nullable;

final class MessageNode
extends DefaultMutableTreeNode {
    private String[] myText;
    private AntMessage myMessage;
    @Nullable
    private RangeMarker myRangeMarker;
    private Document myEditorDocument;
    private boolean myAllowToShowPosition;

    MessageNode(AntMessage message, Project project, boolean allowToShowPosition) {
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile;
            this.myMessage = message;
            this.myText = message.getTextLines();
            if (this.myMessage.getFile() != null && (psiFile = PsiManager.getInstance((Project)project).findFile(this.myMessage.getFile())) != null) {
                this.myEditorDocument = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                if (this.myEditorDocument != null) {
                    int start;
                    int line = this.myMessage.getLine();
                    int column = this.myMessage.getColumn();
                    if (line - 1 >= 0 && line < this.myEditorDocument.getLineCount() && (start = this.myEditorDocument.getLineStartOffset(line - 1) + column - 1) >= 0 && start < this.myEditorDocument.getTextLength()) {
                        this.myRangeMarker = this.myEditorDocument.createRangeMarker(start, start);
                    }
                }
            }
            this.myAllowToShowPosition = allowToShowPosition;
        });
    }

    public String[] getText() {
        return this.myText;
    }

    public VirtualFile getFile() {
        return this.myMessage.getFile();
    }

    public int getOffset() {
        if (this.myRangeMarker == null) {
            return -1;
        }
        return this.myRangeMarker.getStartOffset();
    }

    public AntBuildMessageView.MessageType getType() {
        return this.myMessage.getType();
    }

    public String getPositionString() {
        if (this.myRangeMarker == null || !this.myAllowToShowPosition) {
            return "";
        }
        return "(" + this.myMessage.getLine() + ", " + this.myMessage.getColumn() + ") ";
    }

    @Nullable
    public String getTypeString() {
        AntBuildMessageView.MessageType type = this.myMessage.getType();
        if (type == AntBuildMessageView.MessageType.BUILD) {
            return AntBundle.message("ant.build.message.node.prefix.text", new Object[0]);
        }
        if (type == AntBuildMessageView.MessageType.TARGET) {
            return AntBundle.message("ant.target.message.node.prefix.text", new Object[0]);
        }
        if (type == AntBuildMessageView.MessageType.TASK) {
            return AntBundle.message("ant.task.message.node.prefix.text", new Object[0]);
        }
        return "";
    }

    public int getPriority() {
        return this.myMessage.getPriority();
    }

    public void clearRangeMarker() {
        RangeMarker rangeMarker = this.myRangeMarker;
        if (rangeMarker != null) {
            this.myRangeMarker = null;
            rangeMarker.dispose();
        }
    }
}

