/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.statistics;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/statistics/GradleSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getYesNoUsage", "key", "value", "", "intellij.gradle.common"})
public final class GradleSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "statistics.build.gradle.state";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings gradleSettings2 = gradleSettings;
        Collection<GradleProjectSettings> collection = gradleSettings2.getLinkedProjectsSettings();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"gradleSettings.linkedProjectsSettings");
        Collection<GradleProjectSettings> projectsSettings = collection;
        if (projectsSettings.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set usages = new LinkedHashSet();
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"offlineWork", (boolean)gradleSettings2.isOfflineWork()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"showSelectiveImportDialogOnInitialImport", (boolean)gradleSettings2.showSelectiveImportDialogOnInitialImport()));
        Iterator<GradleProjectSettings> iterator = gradleSettings2.getLinkedProjectsSettings().iterator();
        while (iterator.hasNext()) {
            GradleVersion gradleVersion;
            GradleProjectSettings setting;
            GradleProjectSettings gradleProjectSettings = setting = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleProjectSettings), (String)"setting");
            usages.add(this.getYesNoUsage("isCompositeBuilds", gradleProjectSettings.getCompositeBuild() != null));
            usages.add(StatisticsUtilKt.getEnumUsage((String)"distributionType", (Enum)setting.getDistributionType()));
            usages.add(StatisticsUtilKt.getEnumUsage((String)"storeProjectFilesExternally", (Enum)((Enum)setting.getStoreProjectFilesExternally())));
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"disableWrapperSourceDistributionNotification", (boolean)setting.isDisableWrapperSourceDistributionNotification()));
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"createModulePerSourceSet", (boolean)setting.isResolveModulePerSourceSet()));
            StringBuilder stringBuilder = new StringBuilder().append("gradleJvm.");
            String string = setting.getGradleJvm();
            if (string == null) {
                string = "empty";
            }
            usages.add(new UsageDescriptor(stringBuilder.append(ConvertUsagesUtil.escapeDescriptorName((String)string)).toString(), 1));
            Intrinsics.checkExpressionValueIsNotNull((Object)setting.resolveGradleVersion(), (String)"setting.resolveGradleVersion()");
            if (gradleVersion.isSnapshot()) {
                StringBuilder stringBuilder2 = new StringBuilder().append("gradleVersion.");
                GradleVersion gradleVersion2 = gradleVersion.getBaseVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion2, (String)"gradleVersion.baseVersion");
                usages.add(new UsageDescriptor(stringBuilder2.append(gradleVersion2.getVersion()).append(".SNAPSHOT").toString(), 1));
                continue;
            }
            usages.add(new UsageDescriptor("gradleVersion." + gradleVersion.getVersion(), 1));
        }
        GradleSystemRunningSettings gradleSystemRunningSettings = GradleSystemRunningSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleSystemRunningSettings, (String)"GradleSystemRunningSettings.getInstance()");
        GradleSystemRunningSettings runningSettings = gradleSystemRunningSettings;
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"delegateBuildRun", (boolean)runningSettings.isUseGradleAwareMake()));
        usages.add(StatisticsUtilKt.getEnumUsage((String)"preferredTestRunner", (Enum)runningSettings.getPreferredTestRunner()));
        return usages;
    }

    private final UsageDescriptor getYesNoUsage(String key, boolean value) {
        return new UsageDescriptor(key + (value ? ".yes" : ".no"), 1);
    }
}

