/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Executor;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.ide.actions.runAnything.items.RunAnythingHelpItem;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import groovyjarjarcommonscli.Option;
import icons.GradleIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.action.GradleExecuteTaskAction;
import org.jetbrains.plugins.gradle.execution.RunAnythingGradleItem;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunAnythingProvider
extends RunAnythingProviderBase<String> {
    @NotNull
    public RunAnythingItem getMainListItem(@NotNull DataContext dataContext, @NotNull String value) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(0);
        }
        if (value == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(1);
        }
        RunAnythingGradleItem runAnythingGradleItem = new RunAnythingGradleItem(this.getCommand(value), this.getIcon(value));
        if (runAnythingGradleItem == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(2);
        }
        return runAnythingGradleItem;
    }

    @Nullable
    public String findMatchingValue(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(4);
        }
        return pattern.startsWith(this.getHelpCommand()) ? this.getCommand(pattern) : null;
    }

    @NotNull
    public Collection<String> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(6);
        }
        if (!pattern.startsWith(this.getHelpCommand())) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        String prefix = StringUtil.notNullize((String)StringUtil.substringBeforeLast((String)pattern, (String)" "), (String)this.getHelpCommand()).trim() + ' ';
        String toComplete = StringUtil.notNullize((String)StringUtil.substringAfterLast((String)pattern, (String)" "));
        this.appendProjectsVariants(result, dataContext, prefix);
        if (!result.isEmpty()) {
            List list = result;
            if (list == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        GradleRunAnythingProvider.appendArgumentsVariants(result, prefix, toComplete);
        if (!result.isEmpty()) {
            List list = result;
            if (list == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        this.appendTasksVariants(result, prefix, dataContext);
        List list = result;
        if (list == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    private void appendProjectsVariants(@NotNull List<String> result, @NotNull DataContext dataContext, @NotNull String prefix) {
        if (result == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(11);
        }
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(12);
        }
        if (prefix == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(13);
        }
        if (!prefix.trim().equals(this.getHelpCommand())) {
            return;
        }
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        Collection<GradleProjectSettings> projectsSettings = GradleSettings.getInstance(project).getLinkedProjectsSettings();
        if (projectsSettings.size() <= 1) {
            return;
        }
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        projectsSettings.stream().map(setting -> dataManager.getExternalProjectData(project, GradleConstants.SYSTEM_ID, setting.getExternalProjectPath())).filter(projectInfo -> projectInfo != null && projectInfo.getExternalProjectStructure() != null).map(projectInfo -> (ProjectData)projectInfo.getExternalProjectStructure().getData()).forEach(data -> {
            if (result == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(37);
            }
            if (prefix == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(38);
            }
            result.add(prefix + data.getExternalName());
        });
    }

    private void appendTasksVariants(@NotNull List<String> result, @NotNull String prefix, @NotNull DataContext dataContext) {
        String commandLine;
        Project project;
        ProjectData projectData;
        if (result == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(14);
        }
        if (prefix == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(15);
        }
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(16);
        }
        if ((projectData = GradleRunAnythingProvider.getProjectData(project = RunAnythingUtil.fetchProject((DataContext)dataContext), commandLine = StringUtil.trimStart((String)prefix, (String)this.getHelpCommand()).trim())) == null) {
            return;
        }
        MultiMap<String, String> tasks = GradleRunAnythingProvider.fetchTasks(dataContext).get(projectData);
        if (tasks == null) {
            return;
        }
        for (Map.Entry entry : tasks.entrySet()) {
            for (String taskName : (Collection)entry.getValue()) {
                String taskFqn = (String)entry.getKey() + taskName;
                result.add(prefix + taskFqn);
            }
        }
    }

    private static void appendArgumentsVariants(@NotNull List<String> result, @NotNull String prefix, @NotNull String toComplete) {
        if (result == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(17);
        }
        if (prefix == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(18);
        }
        if (toComplete == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(19);
        }
        if (!toComplete.startsWith("-")) {
            return;
        }
        boolean isLongOpt = toComplete.startsWith("--");
        prefix = prefix + (isLongOpt ? "--" : "-");
        for (Object option : GradleCommandLineOptionsProvider.getSupportedOptions().getOptions()) {
            String opt;
            if (!(option instanceof Option) || !StringUtil.isNotEmpty((String)(opt = isLongOpt ? ((Option)option).getLongOpt() : ((Option)option).getOpt()))) continue;
            result.add(prefix + opt);
        }
    }

    public void execute(@NotNull DataContext dataContext, @NotNull String value) {
        String commandLine;
        Project project;
        ProjectData projectData;
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(20);
        }
        if (value == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(21);
        }
        if ((projectData = GradleRunAnythingProvider.getProjectData(project = RunAnythingUtil.fetchProject((DataContext)dataContext), commandLine = StringUtil.trimStart((String)value, (String)this.getHelpCommand()).trim())) == null) {
            return;
        }
        commandLine = StringUtil.trimStart((String)commandLine, (String)projectData.getExternalName());
        Executor executor = (Executor)RunAnythingAction.EXECUTOR_KEY.getData(dataContext);
        GradleExecuteTaskAction.runGradle(project, executor, projectData.getLinkedExternalProjectPath(), commandLine);
    }

    @Nullable
    private static ProjectData getProjectData(@NotNull Project project, @NotNull String commandLine) {
        Collection<GradleProjectSettings> projectsSettings;
        if (project == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(22);
        }
        if (commandLine == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(23);
        }
        if ((projectsSettings = GradleSettings.getInstance(project).getLinkedProjectsSettings()).isEmpty()) {
            return null;
        }
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        return projectsSettings.stream().map(setting -> {
            if (project == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(36);
            }
            return dataManager.getExternalProjectData(project, GradleConstants.SYSTEM_ID, setting.getExternalProjectPath());
        }).filter(projectInfo -> projectInfo != null && projectInfo.getExternalProjectStructure() != null).map(projectInfo -> (ProjectData)projectInfo.getExternalProjectStructure().getData()).filter(projectData -> {
            if (commandLine == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(35);
            }
            return projectsSettings.size() == 1 || StringUtil.startsWith((CharSequence)commandLine, (CharSequence)projectData.getExternalName());
        }).findFirst().orElse(null);
    }

    @NotNull
    public String getCommand(@NotNull String value) {
        if (value == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(24);
        }
        String string = value;
        if (string == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    public Icon getIcon(@NotNull String value) {
        if (value == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(26);
        }
        return GradleIcons.Gradle;
    }

    @Nullable
    public RunAnythingHelpItem getHelpItem(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(27);
        }
        String placeholder = this.getHelpCommandPlaceholder(dataContext);
        String commandPrefix = this.getHelpCommand();
        return new RunAnythingHelpItem(placeholder, commandPrefix, this.getHelpDescription(), this.getHelpIcon());
    }

    @NotNull
    public String getCompletionGroupTitle() {
        if ("Gradle tasks" == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(28);
        }
        return "Gradle tasks";
    }

    @NotNull
    public String getHelpCommandPlaceholder() {
        String string = this.getHelpCommandPlaceholder(null);
        if (string == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public String getHelpCommandPlaceholder(@Nullable DataContext dataContext) {
        Project project;
        if (dataContext != null && GradleSettings.getInstance(project = RunAnythingUtil.fetchProject((DataContext)dataContext)).getLinkedProjectsSettings().size() > 1) {
            if ("gradle <rootProjectName> <taskName...> <--option-name...>" == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(30);
            }
            return "gradle <rootProjectName> <taskName...> <--option-name...>";
        }
        if ("gradle <taskName...> <--option-name...>" == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(31);
        }
        return "gradle <taskName...> <--option-name...>";
    }

    @NotNull
    public String getHelpCommand() {
        if ("gradle" == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(32);
        }
        return "gradle";
    }

    public Icon getHelpIcon() {
        return GradleIcons.Gradle;
    }

    private static Map<ProjectData, MultiMap<String, String>> fetchTasks(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(33);
        }
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(GradleRunAnythingProvider.getTasksMap(project), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)}));
    }

    @NotNull
    private static Map<ProjectData, MultiMap<String, String>> getTasksMap(Project project) {
        LinkedHashMap tasks = ContainerUtil.newLinkedHashMap();
        for (GradleProjectSettings setting : GradleSettings.getInstance(project).getLinkedProjectsSettings()) {
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, setting.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) continue;
            MultiMap projectTasks = MultiMap.createOrderedSet();
            for (DataNode moduleDataNode : ExternalSystemApiUtil.getChildren((DataNode)projectData.getExternalProjectStructure(), (Key)ProjectKeys.MODULE)) {
                int colonIndex;
                String moduleId = ((ModuleData)moduleDataNode.getData()).getId();
                String gradlePath = moduleId.charAt(0) != ':' ? ((colonIndex = moduleId.indexOf(58)) > 0 ? moduleId.substring(colonIndex) : ":") : moduleId;
                for (DataNode node : ExternalSystemApiUtil.getChildren((DataNode)moduleDataNode, (Key)ProjectKeys.TASK)) {
                    TaskData taskData = (TaskData)node.getData();
                    String taskName = taskData.getName();
                    if (!StringUtil.isNotEmpty((String)taskName)) continue;
                    String taskPathPrefix = ":".equals(gradlePath) || taskName.startsWith(gradlePath) ? "" : gradlePath + ':';
                    projectTasks.putValue((Object)taskPathPrefix, (Object)taskName);
                }
            }
            tasks.put(projectData.getExternalProjectStructure().getData(), projectTasks);
        }
        LinkedHashMap linkedHashMap = tasks;
        if (linkedHashMap == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(34);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/GradleRunAnythingProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toComplete";
                break;
            }
            case 22: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleRunAnythingProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainListItem";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionGroupTitle";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommandPlaceholder";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommand";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMainListItem";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendProjectsVariants";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendTasksVariants";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentsVariants";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getProjectData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getHelpItem";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fetchTasks";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProjectData$7";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProjectData$4";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendProjectsVariants$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

