/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.inline.InlineConstantFieldProcessor;
import com.intellij.refactoring.inline.InlineLocalHandler;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineParameterHandler;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import org.jetbrains.annotations.NotNull;

public class JavaCodeInsightTestUtil {
    private static final int TARGET_FOR_INLINE_FLAGS = 3;

    private JavaCodeInsightTestUtil() {
    }

    public static void doInlineLocalTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after) {
        if (fixture == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(0);
        }
        if (before == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(1);
        }
        if (after == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(2);
        }
        fixture.configureByFile(before);
        Editor editor = fixture.getEditor();
        PsiElement element = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
        assert (element instanceof PsiLocalVariable) : element;
        InlineLocalHandler.invoke((Project)fixture.getProject(), (Editor)editor, (PsiLocalVariable)((PsiLocalVariable)element), null);
        fixture.checkResultByFile(after, false);
    }

    public static void doInlineParameterTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after) {
        if (fixture == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(3);
        }
        if (before == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(4);
        }
        if (after == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(5);
        }
        fixture.configureByFile(before);
        Editor editor = fixture.getEditor();
        PsiElement element = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
        assert (element instanceof PsiParameter) : element;
        new InlineParameterHandler().inlineElement(LightPlatformTestCase.getProject(), editor, element);
        fixture.checkResultByFile(after, false);
    }

    public static void doInlineMethodTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after) {
        if (fixture == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(6);
        }
        if (before == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(7);
        }
        if (after == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(8);
        }
        fixture.configureByFile(before);
        Editor editor = fixture.getEditor();
        PsiElement element = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
        assert (element instanceof PsiMethod) : element;
        PsiReference ref = fixture.getFile().findReferenceAt(editor.getCaretModel().getOffset());
        PsiReferenceExpression refExpr = ref instanceof PsiReferenceExpression ? (PsiReferenceExpression)ref : null;
        PsiMethod method = (PsiMethod)element;
        assert (!InlineMethodProcessor.checkBadReturns((PsiMethod)method) || InlineUtil.allUsagesAreTailCalls((PsiMethod)method)) : "Bad returns found";
        new InlineMethodProcessor(LightPlatformTestCase.getProject(), method, (PsiJavaCodeReferenceElement)refExpr, editor, false).run();
        fixture.checkResultByFile(after, false);
    }

    public static void doInlineConstantTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after) {
        if (fixture == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(9);
        }
        if (before == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(10);
        }
        if (after == null) {
            JavaCodeInsightTestUtil.$$$reportNull$$$0(11);
        }
        fixture.configureByFile(before);
        Editor editor = fixture.getEditor();
        PsiElement element = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
        assert (element instanceof PsiField) : element;
        PsiReference ref = fixture.getFile().findReferenceAt(editor.getCaretModel().getOffset());
        PsiReferenceExpression refExpr = ref instanceof PsiReferenceExpression ? (PsiReferenceExpression)ref : null;
        new InlineConstantFieldProcessor((PsiField)element, LightPlatformTestCase.getProject(), refExpr, false).run();
        fixture.checkResultByFile(after, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/fixtures/JavaCodeInsightTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doInlineLocalTest";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doInlineParameterTest";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doInlineMethodTest";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "doInlineConstantTest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

