/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendContextRunnable;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SynchronizationBasedSemaphore;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTestCase;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ui.UIUtil;
import com.sun.jdi.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public abstract class ExecutionWithDebuggerToolsTestCase
extends ExecutionTestCase {
    private DebugProcessListener myPauseScriptListener;
    private final List<SuspendContextRunnable> myScriptRunnables = new ArrayList<SuspendContextRunnable>();
    private final SynchronizationBasedSemaphore myScriptRunnablesSema = new SynchronizationBasedSemaphore();
    protected static final int RATHER_LATER_INVOKES_N = 10;
    public DebugProcessImpl myDebugProcess;
    private final List<Throwable> myException = new SmartList();
    public final List<InvokeRatherLaterRequest> myRatherLaterRequests = new ArrayList<InvokeRatherLaterRequest>();

    protected DebugProcessImpl getDebugProcess() {
        return this.myDebugProcess;
    }

    protected String readValue(String comment, String valueName) {
        int valueStart = comment.indexOf(valueName);
        if (valueStart == -1) {
            return null;
        }
        return comment.substring((valueStart += valueName.length()) + 1, ExecutionWithDebuggerToolsTestCase.findMatchingParenthesis(comment, valueStart));
    }

    private static int findMatchingParenthesis(String input, int startPos) {
        int depth = 0;
        while (startPos < input.length()) {
            switch (input.charAt(startPos)) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    if (depth == 1) {
                        return startPos;
                    }
                    --depth;
                }
            }
            ++startPos;
        }
        return -1;
    }

    protected void resume(SuspendContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createResumeCommand(context, PrioritizedTask.Priority.LOWEST));
    }

    protected void stepInto(SuspendContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createStepIntoCommand(context, false, null));
    }

    protected void stepOver(SuspendContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createStepOverCommand(context, false));
    }

    protected void stepOut(SuspendContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createStepOutCommand(context));
    }

    protected void waitBreakpoints() {
        this.myScriptRunnablesSema.down();
        this.waitFor(() -> this.myScriptRunnablesSema.waitFor());
    }

    @Override
    protected void tearDown() throws Exception {
        ThreadTracker.awaitJDIThreadsTermination((int)100, (TimeUnit)TimeUnit.SECONDS);
        try {
            this.myDebugProcess = null;
            this.myPauseScriptListener = null;
            this.myRatherLaterRequests.clear();
            this.myScriptRunnables.clear();
        }
        finally {
            super.tearDown();
            this.throwExceptionsIfAny();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void throwExceptionsIfAny() {
        List<Throwable> list = this.myException;
        synchronized (list) {
            CompoundRuntimeException.throwIfNotEmpty(this.myException);
            this.myException.clear();
        }
    }

    protected void onBreakpoint(SuspendContextRunnable runnable) {
        this.addDefaultBreakpointListener();
        this.myScriptRunnables.add(runnable);
    }

    protected void onStop(final SuspendContextRunnable runnable, final SuspendContextRunnable then) {
        this.onBreakpoint(new SuspendContextRunnable(){

            public void run(SuspendContextImpl suspendContext) throws Exception {
                try {
                    runnable.run(suspendContext);
                }
                finally {
                    then.run(suspendContext);
                }
            }
        });
    }

    protected void doWhenPausedThenResume(SuspendContextRunnable runnable) {
        this.onStop(runnable, this::resume);
    }

    protected void addDefaultBreakpointListener() {
        if (this.myPauseScriptListener == null) {
            final DebugProcessImpl debugProcess = this.getDebugProcess();
            ExecutionWithDebuggerToolsTestCase.assertNotNull((String)"Debug process was not started", (Object)debugProcess);
            this.myPauseScriptListener = new DelayedEventsProcessListener(new DebugProcessAdapterImpl(){

                public void paused(SuspendContextImpl suspendContext) {
                    try {
                        if (ExecutionWithDebuggerToolsTestCase.this.myScriptRunnables.isEmpty()) {
                            ExecutionWithDebuggerToolsTestCase.this.print("resuming ", ProcessOutputTypes.SYSTEM);
                            ExecutionWithDebuggerToolsTestCase.this.printContext((StackFrameContext)suspendContext);
                            ExecutionWithDebuggerToolsTestCase.this.resume(suspendContext);
                            return;
                        }
                        SuspendContextRunnable suspendContextRunnable = (SuspendContextRunnable)ExecutionWithDebuggerToolsTestCase.this.myScriptRunnables.remove(0);
                        suspendContextRunnable.run(suspendContext);
                    }
                    catch (Exception e) {
                        ExecutionWithDebuggerToolsTestCase.this.addException(e);
                        ExecutionWithDebuggerToolsTestCase.this.error(e);
                    }
                    catch (AssertionError e) {
                        ExecutionWithDebuggerToolsTestCase.this.addException((Throwable)((Object)e));
                        ExecutionWithDebuggerToolsTestCase.this.resume(suspendContext);
                    }
                    if (ExecutionWithDebuggerToolsTestCase.this.myScriptRunnables.isEmpty()) {
                        ExecutionWithDebuggerToolsTestCase.this.myScriptRunnablesSema.up();
                    }
                }

                public void resumed(SuspendContextImpl suspendContext) {
                    final SuspendContextImpl pausedContext = debugProcess.getSuspendManager().getPausedContext();
                    if (pausedContext != null) {
                        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(pausedContext){

                            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                                if (suspendContext == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                this.paused(pausedContext);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$2$1", "contextAction"));
                            }
                        });
                    }
                }
            });
            debugProcess.addDebugProcessListener(this.myPauseScriptListener);
        }
    }

    protected void printFrameProxy(StackFrameProxyImpl frameProxy) throws EvaluateException {
        int frameIndex = frameProxy.getFrameIndex();
        Method method = frameProxy.location().method();
        this.println("frameProxy(" + frameIndex + ") = " + method, ProcessOutputTypes.SYSTEM);
    }

    private static String toDisplayableString(SourcePosition sourcePosition) {
        int line = sourcePosition.getLine();
        if (line >= 0) {
            ++line;
        }
        return sourcePosition.getFile().getVirtualFile().getName() + ":" + line;
    }

    protected void printContext(StackFrameContext context) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (context.getFrameProxy() != null) {
                this.println(ExecutionWithDebuggerToolsTestCase.toDisplayableString(Objects.requireNonNull(PositionUtil.getSourcePosition((StackFrameContext)context))), ProcessOutputTypes.SYSTEM);
            } else {
                this.println("Context thread is null", ProcessOutputTypes.SYSTEM);
            }
        });
    }

    protected void printContextWithText(StackFrameContext context) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (context.getFrameProxy() != null) {
                SourcePosition sourcePosition = PositionUtil.getSourcePosition((StackFrameContext)context);
                int offset = sourcePosition.getOffset();
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(sourcePosition.getFile());
                CharSequence text = Objects.requireNonNull(document).getImmutableCharSequence();
                String positionText = "";
                if (offset > -1) {
                    positionText = StringUtil.escapeLineBreak((String)(" [" + text.subSequence(Math.max(0, offset - 20), offset) + "<*>" + text.subSequence(offset, Math.min(offset + 20, text.length())) + "]"));
                }
                this.println(ExecutionWithDebuggerToolsTestCase.toDisplayableString(sourcePosition) + positionText, ProcessOutputTypes.SYSTEM);
            } else {
                this.println("Context thread is null", ProcessOutputTypes.SYSTEM);
            }
        });
    }

    protected void invokeRatherLater(SuspendContextImpl context, final Runnable runnable) {
        this.invokeRatherLater((DebuggerCommandImpl)new SuspendContextCommandImpl(context){

            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    3.$$$reportNull$$$0(0);
                }
                DebuggerInvocationUtil.invokeLater((Project)ExecutionWithDebuggerToolsTestCase.this.myProject, (Runnable)runnable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$3", "contextAction"));
            }
        });
    }

    protected void pumpSwingThread() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        final InvokeRatherLaterRequest request = this.myRatherLaterRequests.get(0);
        ++request.invokesN;
        if (request.invokesN == 10) {
            this.myRatherLaterRequests.remove(0);
            if (!this.myRatherLaterRequests.isEmpty()) {
                this.pumpSwingThread();
            }
        }
        if (request.myDebuggerCommand instanceof SuspendContextCommandImpl) {
            request.myDebugProcess.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(((SuspendContextCommandImpl)request.myDebuggerCommand).getSuspendContext()){

                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                protected void commandCancelled() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$4", "contextAction"));
                }
            });
        } else {
            request.myDebugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                protected void action() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                protected void commandCancelled() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }
            });
        }
    }

    private void pumpDebuggerThread(InvokeRatherLaterRequest request) {
        if (request.invokesN == 10) {
            request.myDebugProcess.getManagerThread().schedule(request.myDebuggerCommand);
        } else if (!SwingUtilities.isEventDispatchThread()) {
            UIUtil.invokeAndWaitIfNeeded(() -> this.pumpSwingThread());
        } else {
            SwingUtilities.invokeLater(() -> this.pumpSwingThread());
        }
    }

    protected void invokeRatherLater(DebuggerCommandImpl command) {
        UIUtil.invokeLaterIfNeeded(() -> {
            InvokeRatherLaterRequest request = new InvokeRatherLaterRequest(command, this.getDebugProcess());
            this.myRatherLaterRequests.add(request);
            if (this.myRatherLaterRequests.size() == 1) {
                this.pumpSwingThread();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addException(Throwable e) {
        List<Throwable> list = this.myException;
        synchronized (list) {
            this.myException.add(e);
        }
    }

    protected void error(Throwable th) {
        ExecutionWithDebuggerToolsTestCase.fail((String)StringUtil.getThrowableText((Throwable)th));
    }

    private static Pair<ClassFilter[], ClassFilter[]> readClassFilters(String filtersString) {
        ArrayList<ClassFilter> include = new ArrayList<ClassFilter>();
        ArrayList<ClassFilter> exclude = new ArrayList<ClassFilter>();
        for (String s : filtersString.split(",")) {
            ClassFilter filter = new ClassFilter();
            filter.setEnabled(true);
            if (s.startsWith("-")) {
                exclude.add(filter);
                s = s.substring(1);
            } else {
                include.add(filter);
            }
            filter.setPattern(s);
        }
        return Pair.create((Object)include.toArray(ClassFilter.EMPTY_ARRAY), (Object)exclude.toArray(ClassFilter.EMPTY_ARRAY));
    }

    public void createBreakpoints(PsiFile file) {
        Runnable runnable = () -> {
            BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getBreakpointManager();
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
            String text = document.getText();
            int offset = -1;
            while ((offset = text.indexOf("Breakpoint!", offset + 1)) != -1) {
                String catchClassFilters;
                String classFilters;
                String passCount;
                String logExpression;
                String condition;
                MethodBreakpoint breakpoint;
                int commentLine = document.getLineNumber(offset);
                String comment = text.substring(document.getLineStartOffset(commentLine), document.getLineEndOffset(commentLine));
                if (comment.contains("Method")) {
                    breakpoint = breakpointManager.addMethodBreakpoint(document, commentLine + 1);
                    if (breakpoint != null) {
                        this.println("MethodBreakpoint created at " + file.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                        String emulated = this.readValue(comment, "Emulated");
                        if (emulated != null) {
                            ((JavaMethodBreakpointProperties)breakpoint.getXBreakpoint().getProperties()).EMULATED = Boolean.valueOf(emulated);
                            this.println("Emulated = " + emulated, ProcessOutputTypes.SYSTEM);
                        }
                    }
                } else if (comment.contains("Field")) {
                    breakpoint = breakpointManager.addFieldBreakpoint(document, commentLine + 1, this.readValue(comment, "Field"));
                    if (breakpoint != null) {
                        this.println("FieldBreakpoint created at " + file.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                    }
                } else if (comment.contains("Exception")) {
                    breakpoint = breakpointManager.addExceptionBreakpoint(this.readValue(comment, "Exception"), "");
                    if (breakpoint != null) {
                        this.println("ExceptionBreakpoint created at " + file.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                    }
                } else {
                    breakpoint = breakpointManager.addLineBreakpoint(document, commentLine + 1);
                    if (breakpoint != null) {
                        this.println("LineBreakpoint created at " + file.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                    }
                }
                if (breakpoint == null) {
                    LOG.error("Unable to set a breakpoint at line " + (commentLine + 1));
                    continue;
                }
                String suspendPolicy = this.readValue(comment, "suspendPolicy");
                if (suspendPolicy != null) {
                    breakpoint.setSuspendPolicy(suspendPolicy);
                    this.println("SUSPEND_POLICY = " + suspendPolicy, ProcessOutputTypes.SYSTEM);
                }
                if ((condition = this.readValue(comment, "Condition")) != null) {
                    breakpoint.setCondition((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, condition));
                    this.println("Condition = " + condition, ProcessOutputTypes.SYSTEM);
                }
                if ((logExpression = this.readValue(comment, "LogExpression")) != null) {
                    breakpoint.getXBreakpoint().setLogExpression(logExpression);
                    this.println("LogExpression = " + logExpression, ProcessOutputTypes.SYSTEM);
                }
                if ((passCount = this.readValue(comment, "Pass count")) != null) {
                    breakpoint.setCountFilterEnabled(true);
                    breakpoint.setCountFilter(Integer.parseInt(passCount));
                    this.println("Pass count = " + passCount, ProcessOutputTypes.SYSTEM);
                }
                if ((classFilters = this.readValue(comment, "Class filters")) != null) {
                    breakpoint.setClassFiltersEnabled(true);
                    Pair<ClassFilter[], ClassFilter[]> filters = ExecutionWithDebuggerToolsTestCase.readClassFilters(classFilters);
                    breakpoint.setClassFilters((ClassFilter[])filters.first);
                    breakpoint.setClassExclusionFilters((ClassFilter[])filters.second);
                    this.println("Class filters = " + classFilters, ProcessOutputTypes.SYSTEM);
                }
                if ((catchClassFilters = this.readValue(comment, "Catch class filters")) == null || !(breakpoint instanceof ExceptionBreakpoint)) continue;
                ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)breakpoint;
                exceptionBreakpoint.setCatchFiltersEnabled(true);
                Pair<ClassFilter[], ClassFilter[]> filters = ExecutionWithDebuggerToolsTestCase.readClassFilters(catchClassFilters);
                exceptionBreakpoint.setCatchClassFilters((ClassFilter[])filters.first);
                exceptionBreakpoint.setCatchClassExclusionFilters((ClassFilter[])filters.second);
                this.println("Catch class filters = " + catchClassFilters, ProcessOutputTypes.SYSTEM);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            DebuggerInvocationUtil.invokeAndWait((Project)this.myProject, (Runnable)runnable, (ModalityState)ModalityState.defaultModalityState());
        } else {
            runnable.run();
        }
    }

    private static class DelayedEventsProcessListener
    implements DebugProcessListener {
        private final DebugProcessAdapterImpl myTarget;

        DelayedEventsProcessListener(DebugProcessAdapterImpl target) {
            this.myTarget = target;
        }

        @Override
        public void paused(@NotNull SuspendContext suspendContext) {
            if (suspendContext == null) {
                DelayedEventsProcessListener.$$$reportNull$$$0(0);
            }
            DelayedEventsProcessListener.pauseExecution();
            this.myTarget.paused(suspendContext);
        }

        @Override
        public void resumed(SuspendContext suspendContext) {
            DelayedEventsProcessListener.pauseExecution();
            this.myTarget.resumed(suspendContext);
        }

        @Override
        public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
            if (process == null) {
                DelayedEventsProcessListener.$$$reportNull$$$0(1);
            }
            this.myTarget.processDetached(process, closedByUser);
        }

        @Override
        public void processAttached(@NotNull DebugProcess process) {
            if (process == null) {
                DelayedEventsProcessListener.$$$reportNull$$$0(2);
            }
            this.myTarget.processAttached(process);
        }

        @Override
        public void connectorIsReady() {
            this.myTarget.connectorIsReady();
        }

        @Override
        public void attachException(RunProfileState state, ExecutionException exception, RemoteConnection remoteConnection) {
            this.myTarget.attachException(state, exception, remoteConnection);
        }

        private static void pauseExecution() {
            TimeoutUtil.sleep((long)10L);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$DelayedEventsProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paused";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDetached";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAttached";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InvokeRatherLaterRequest {
        private final DebuggerCommandImpl myDebuggerCommand;
        private final DebugProcessImpl myDebugProcess;
        int invokesN;

        InvokeRatherLaterRequest(DebuggerCommandImpl debuggerCommand, DebugProcessImpl debugProcess) {
            this.myDebuggerCommand = debuggerCommand;
            this.myDebugProcess = debugProcess;
        }
    }
}

