/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtilRt;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.interpolation.StringSearchModelInterpolator;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.profile.DefaultProfileInjector;
import org.apache.maven.model.validation.ModelValidator;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.profiles.activation.JdkPrefixProfileActivator;
import org.apache.maven.profiles.activation.OperatingSystemProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.profiles.activation.SystemPropertyProfileActivator;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.project.inheritance.DefaultModelInheritanceAssembler;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.path.DefaultPathTranslator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.Maven30AetherModelConverter;
import org.jetbrains.idea.maven.server.Maven30TransferListenerAdapter;
import org.jetbrains.idea.maven.server.Maven30WorkspaceReader;
import org.jetbrains.idea.maven.server.Maven3ServerConsoleLogger;
import org.jetbrains.idea.maven.server.Maven3ServerEmbedder;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;
import org.jetbrains.idea.maven.server.MavenEffectivePomDumper;
import org.jetbrains.idea.maven.server.MavenLeakDetector;
import org.jetbrains.idea.maven.server.MavenModelConverter;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicatorWrapper;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.MyFileProfileActivator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.RemoteNativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.embedder.CustomMaven30ArtifactResolver;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ArtifactFactory;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3RepositoryMetadataManager;
import org.jetbrains.idea.maven.server.embedder.MavenExecutionResult;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.graph.PreorderNodeListGenerator;

public class Maven30ServerEmbedderImpl
extends Maven3ServerEmbedder {
    @NotNull
    private final DefaultPlexusContainer myContainer;
    @NotNull
    private final Settings myMavenSettings;
    private final ArtifactRepository myLocalRepository;
    private final Maven3ServerConsoleLogger myConsoleWrapper;
    private final Properties mySystemProperties;
    private volatile MavenServerProgressIndicator myCurrentIndicator;
    private MavenWorkspaceMap myWorkspaceMap;
    private Date myBuildStartTime;
    private boolean myAlwaysUpdateSnapshots;
    @Nullable
    private Properties myUserProperties;
    @NotNull
    private final RepositorySystem myRepositorySystem;

    public Maven30ServerEmbedderImpl(MavenServerSettings settings) throws RemoteException {
        super(settings);
        Object cliRequest;
        Class<?> cliRequestClass;
        File mavenHome = settings.getMavenHome();
        if (mavenHome != null) {
            System.setProperty("maven.home", mavenHome.getPath());
        }
        this.myConsoleWrapper = new Maven3ServerConsoleLogger();
        this.myConsoleWrapper.setThreshold(settings.getLoggingLevel());
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        MavenCli cli = new MavenCli(classWorld){

            protected void customizeContainer(PlexusContainer container) {
                ((DefaultPlexusContainer)container).setLoggerManager((LoggerManager)new BaseLoggerManager(){

                    protected Logger createLogger(String s) {
                        return Maven30ServerEmbedderImpl.this.myConsoleWrapper;
                    }
                });
            }
        };
        try {
            cliRequestClass = MavenCli.class.getClassLoader().loadClass("org.apache.maven.cli.MavenCli$CliRequest");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class \"org.apache.maven.cli.MavenCli$CliRequest\" not found");
        }
        try {
            ArrayList<String> commandLineOptions = new ArrayList<String>(settings.getUserProperties().size());
            for (Map.Entry<Object, Object> each : settings.getUserProperties().entrySet()) {
                commandLineOptions.add("-D" + each.getKey() + "=" + each.getValue());
            }
            if (settings.getLoggingLevel() == 0) {
                commandLineOptions.add("-X");
                commandLineOptions.add("-e");
            } else if (settings.getLoggingLevel() == 5) {
                commandLineOptions.add("-q");
            }
            String mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args");
            if (mavenEmbedderCliOptions != null) {
                commandLineOptions.addAll(StringUtilRt.splitHonorQuotes((String)mavenEmbedderCliOptions, (char)' '));
            }
            if (commandLineOptions.contains("-U") || commandLineOptions.contains("--update-snapshots")) {
                this.myAlwaysUpdateSnapshots = true;
            }
            Constructor<?> constructor = cliRequestClass.getDeclaredConstructor(String[].class, ClassWorld.class);
            constructor.setAccessible(true);
            cliRequest = constructor.newInstance(commandLineOptions.toArray(new String[0]), classWorld);
            for (String each : new String[]{"initialize", "cli", "logging", "properties", "container"}) {
                Method m = MavenCli.class.getDeclaredMethod(each, cliRequestClass);
                m.setAccessible(true);
                m.invoke((Object)cli, cliRequest);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.myContainer = (DefaultPlexusContainer)ReflectionUtilRt.getField(MavenCli.class, (Object)cli, DefaultPlexusContainer.class, (String)"container");
        this.myContainer.getLoggerManager().setThreshold(settings.getLoggingLevel());
        this.mySystemProperties = (Properties)ReflectionUtilRt.getField(cliRequestClass, cliRequest, Properties.class, (String)"systemProperties");
        if (settings.getProjectJdk() != null) {
            this.mySystemProperties.setProperty("java.home", settings.getProjectJdk());
        }
        this.myMavenSettings = Maven30ServerEmbedderImpl.buildSettings((SettingsBuilder)ReflectionUtilRt.getField(MavenCli.class, (Object)cli, SettingsBuilder.class, (String)"settingsBuilder"), settings, this.mySystemProperties, (Properties)ReflectionUtilRt.getField(cliRequestClass, cliRequest, Properties.class, (String)"userProperties"));
        this.myLocalRepository = this.createLocalRepository();
        this.myRepositorySystem = this.getComponent(RepositorySystem.class);
    }

    private static Settings buildSettings(SettingsBuilder builder, MavenServerSettings settings, Properties systemProperties, Properties userProperties) throws RemoteException {
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(settings.getGlobalSettingsFile());
        settingsRequest.setUserSettingsFile(settings.getUserSettingsFile());
        settingsRequest.setSystemProperties(systemProperties);
        settingsRequest.setUserProperties(userProperties);
        Settings result = new Settings();
        try {
            result = builder.build((SettingsBuildingRequest)settingsRequest).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
        }
        result.setOffline(settings.isOffline());
        if (settings.getLocalRepository() != null) {
            result.setLocalRepository(settings.getLocalRepository().getPath());
        }
        if (result.getLocalRepository() == null) {
            result.setLocalRepository(new File(System.getProperty("user.home"), ".m2/repository").getPath());
        }
        return result;
    }

    private static void warn(String message, Throwable e) {
        try {
            Maven3ServerGlobals.getLogger().warn((Throwable)new RuntimeException(message, e));
        }
        catch (RemoteException e1) {
            throw new RuntimeException(e1);
        }
    }

    private static MavenExecutionResult handleException(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new MavenExecutionResult(Collections.singletonList((Exception)e));
    }

    private static Collection<String> collectActivatedProfiles(MavenProject mavenProject) throws RemoteException {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        try {
            while (mavenProject != null) {
                profiles.addAll(mavenProject.getActiveProfiles());
                mavenProject = mavenProject.getParent();
            }
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
        }
        return Maven30ServerEmbedderImpl.collectProfilesIds(profiles);
    }

    private static List<Exception> filterExceptions(List<Throwable> list) {
        for (Throwable throwable : list) {
            if (throwable instanceof Exception) continue;
            throw new RuntimeException(throwable);
        }
        return list;
    }

    @NotNull
    public static MavenModel interpolateAndAlignModel(MavenModel model, File basedir) throws RemoteException {
        Model result = MavenModelConverter.toNativeModel((MavenModel)model);
        result = Maven30ServerEmbedderImpl.doInterpolate(result, basedir);
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        pathTranslator.alignToBaseDirectory(result, basedir);
        MavenModel mavenModel = MavenModelConverter.convertModel((Model)result, null);
        if (mavenModel == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    public static MavenModel assembleInheritance(MavenModel model, MavenModel parentModel) throws RemoteException {
        Model result = MavenModelConverter.toNativeModel((MavenModel)model);
        new DefaultModelInheritanceAssembler().assembleModelInheritance(result, MavenModelConverter.toNativeModel((MavenModel)parentModel));
        return MavenModelConverter.convertModel((Model)result, null);
    }

    public static ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) throws RemoteException {
        Model nativeModel = MavenModelConverter.toNativeModel((MavenModel)model);
        Collection enabledProfiles = explicitProfiles.getEnabledProfiles();
        Collection disabledProfiles = explicitProfiles.getDisabledProfiles();
        ArrayList<Profile> activatedPom = new ArrayList<Profile>();
        ArrayList<Profile> activatedExternal = new ArrayList<Profile>();
        ArrayList<Profile> activeByDefault = new ArrayList<Profile>();
        List rawProfiles = nativeModel.getProfiles();
        List expandedProfilesCache = null;
        ArrayList<Profile> deactivatedProfiles = new ArrayList<Profile>();
        for (int i = 0; i < rawProfiles.size(); ++i) {
            Profile eachRawProfile = (Profile)rawProfiles.get(i);
            if (disabledProfiles.contains(eachRawProfile.getId())) {
                deactivatedProfiles.add(eachRawProfile);
                continue;
            }
            boolean shouldAdd = enabledProfiles.contains(eachRawProfile.getId()) || alwaysOnProfiles.contains(eachRawProfile.getId());
            Activation activation = eachRawProfile.getActivation();
            if (activation != null) {
                if (activation.isActiveByDefault()) {
                    activeByDefault.add(eachRawProfile);
                }
                if (expandedProfilesCache == null) {
                    expandedProfilesCache = Maven30ServerEmbedderImpl.doInterpolate(nativeModel, basedir).getProfiles();
                }
                Profile eachExpandedProfile = (Profile)expandedProfilesCache.get(i);
                for (ProfileActivator eachActivator : Maven30ServerEmbedderImpl.getProfileActivators(basedir)) {
                    try {
                        if (!eachActivator.canDetermineActivation(eachExpandedProfile) || !eachActivator.isActive(eachExpandedProfile)) continue;
                        shouldAdd = true;
                        break;
                    }
                    catch (ProfileActivationException e) {
                        Maven3ServerGlobals.getLogger().warn((Throwable)e);
                    }
                }
            }
            if (!shouldAdd) continue;
            if ("pom".equals(eachRawProfile.getSource())) {
                activatedPom.add(eachRawProfile);
                continue;
            }
            activatedExternal.add(eachRawProfile);
        }
        ArrayList<Profile> activatedProfiles = new ArrayList<Profile>(activatedPom.isEmpty() ? activeByDefault : activatedPom);
        activatedProfiles.addAll(activatedExternal);
        for (Profile each : activatedProfiles) {
            new DefaultProfileInjector().injectProfile(nativeModel, each, null, null);
        }
        return new ProfileApplicationResult(MavenModelConverter.convertModel((Model)nativeModel, null), new MavenExplicitProfiles(Maven30ServerEmbedderImpl.collectProfilesIds(activatedProfiles), Maven30ServerEmbedderImpl.collectProfilesIds(deactivatedProfiles)));
    }

    private static Model doInterpolate(Model result, File basedir) throws RemoteException {
        try {
            CustomMaven3ModelInterpolator interpolator = new CustomMaven3ModelInterpolator(new DefaultPathTranslator());
            interpolator.initialize();
            Properties props = MavenServerUtil.collectSystemProperties();
            ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setExecutionProperties(props);
            config.setBuildStartTime(new Date());
            Properties userProperties = new Properties();
            userProperties.putAll((Map<?, ?>)Maven30ServerEmbedderImpl.getMavenAndJvmConfigProperties((File)basedir));
            config.setUserProperties(userProperties);
            result = interpolator.interpolate(result, basedir, config, false);
        }
        catch (ModelInterpolationException e) {
            Maven3ServerGlobals.getLogger().warn((Throwable)e);
        }
        catch (InitializationException e) {
            Maven3ServerGlobals.getLogger().error((Throwable)e);
        }
        return result;
    }

    private static Collection<String> collectProfilesIds(List<Profile> profiles) {
        THashSet result = new THashSet();
        for (Profile each : profiles) {
            if (each.getId() == null) continue;
            result.add(each.getId());
        }
        return result;
    }

    private static ProfileActivator[] getProfileActivators(File basedir) throws RemoteException {
        SystemPropertyProfileActivator sysPropertyActivator = new SystemPropertyProfileActivator();
        DefaultContext context = new DefaultContext();
        context.put((Object)"SystemProperties", (Object)MavenServerUtil.collectSystemProperties());
        try {
            sysPropertyActivator.contextualize((Context)context);
        }
        catch (ContextException e) {
            Maven3ServerGlobals.getLogger().error((Throwable)e);
            return new ProfileActivator[0];
        }
        return new ProfileActivator[]{new MyFileProfileActivator(basedir), sysPropertyActivator, new JdkPrefixProfileActivator(), new OperatingSystemProfileActivator()};
    }

    public <T> T getComponent(Class<T> clazz, String roleHint) {
        try {
            return (T)this.myContainer.lookup(clazz.getName(), roleHint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getComponent(Class<T> clazz) {
        try {
            return (T)this.myContainer.lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    private ArtifactRepository createLocalRepository() {
        try {
            ArtifactRepository localRepository = this.getComponent(RepositorySystem.class).createLocalRepository(new File(this.myMavenSettings.getLocalRepository()));
            String customRepoId = System.getProperty("maven3.localRepository.id", "localIntelliJ");
            if (customRepoId != null) {
                localRepository.setId(customRepoId);
            }
            return localRepository;
        }
        catch (InvalidRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void customize(@Nullable MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, @NotNull MavenServerConsole console, @NotNull MavenServerProgressIndicator indicator, boolean alwaysUpdateSnapshots, @Nullable Properties userProperties) throws RemoteException {
        if (console == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(2);
        }
        try {
            this.customizeComponents();
            ((CustomMaven3ArtifactFactory)this.getComponent(ArtifactFactory.class)).customize();
            ((CustomMaven30ArtifactResolver)this.getComponent(ArtifactResolver.class)).customize(workspaceMap, failOnUnresolvedDependency);
            ((CustomMaven3RepositoryMetadataManager)this.getComponent(RepositoryMetadataManager.class)).customize(workspaceMap);
            this.myWorkspaceMap = workspaceMap;
            this.myBuildStartTime = new Date();
            this.myAlwaysUpdateSnapshots = this.myAlwaysUpdateSnapshots || alwaysUpdateSnapshots;
            this.setConsoleAndIndicator(console, (MavenServerProgressIndicator)new MavenServerProgressIndicatorWrapper(indicator));
            this.myUserProperties = userProperties;
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public void customizeComponents() throws RemoteException {
        this.myContainer.addComponent((Object)this.getComponent(ArtifactFactory.class, "ide"), ArtifactFactory.ROLE);
        this.myContainer.addComponent((Object)this.getComponent(ArtifactResolver.class, "ide"), ArtifactResolver.ROLE);
        this.myContainer.addComponent((Object)this.getComponent(RepositoryMetadataManager.class, "ide"), RepositoryMetadataManager.class.getName());
        this.myContainer.addComponent((Object)this.getComponent(PluginDescriptorCache.class, "ide"), PluginDescriptorCache.class.getName());
        org.apache.maven.model.interpolation.ModelInterpolator modelInterpolator = this.getComponent(org.apache.maven.model.interpolation.ModelInterpolator.class, "ide");
        this.myContainer.addComponent((Object)modelInterpolator, org.apache.maven.model.interpolation.ModelInterpolator.class.getName());
        this.myContainer.addComponent((Object)this.getComponent(ModelInterpolator.class, "ide"), ModelInterpolator.ROLE);
        ModelValidator modelValidator = this.getComponent(ModelValidator.class, "ide");
        this.myContainer.addComponent((Object)modelValidator, ModelValidator.class.getName());
        DefaultModelBuilder defaultModelBuilder = (DefaultModelBuilder)this.getComponent(ModelBuilder.class);
        defaultModelBuilder.setModelValidator(modelValidator);
        defaultModelBuilder.setModelInterpolator(modelInterpolator);
        if (!"3.0.5".equals(this.getMavenVersion()) && modelInterpolator instanceof StringSearchModelInterpolator) {
            ((StringSearchModelInterpolator)modelInterpolator).setPathTranslator(this.getComponent(PathTranslator.class));
            ((StringSearchModelInterpolator)modelInterpolator).setUrlNormalizer(this.getComponent(UrlNormalizer.class));
        }
    }

    private void setConsoleAndIndicator(MavenServerConsole console, MavenServerProgressIndicator indicator) {
        this.myConsoleWrapper.setWrappee(console);
        this.myCurrentIndicator = indicator;
    }

    @NotNull
    public Collection<MavenServerExecutionResult> resolveProject(@NotNull Collection<File> files, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws RemoteException {
        if (files == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(3);
        }
        if (activeProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(4);
        }
        if (inactiveProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(5);
        }
        final DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener((Logger)this.myConsoleWrapper);
        Collection<MavenExecutionResult> results = this.doResolveProject(files, new ArrayList<String>(activeProfiles), new ArrayList<String>(inactiveProfiles), Collections.singletonList(listener));
        List list = ContainerUtilRt.mapNotNull(results, (Function)new Function<MavenExecutionResult, MavenServerExecutionResult>(){

            public MavenServerExecutionResult fun(MavenExecutionResult result) {
                try {
                    return Maven30ServerEmbedderImpl.this.createExecutionResult(result.getPomFile(), result, listener.getRootNode());
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (list == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles) throws RemoteException, MavenServerProcessCanceledException {
        if (file == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(7);
        }
        if (activeProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(8);
        }
        if (inactiveProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(9);
        }
        return MavenEffectivePomDumper.evaluateEffectivePom((Maven3ServerEmbedder)this, (File)file, activeProfiles, inactiveProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithMavenSession(MavenExecutionRequest request, Runnable runnable) {
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        RepositorySystemSession repositorySession = maven.newRepositorySession(request);
        request.getProjectBuildingRequest().setRepositorySession(repositorySession);
        MavenSession mavenSession = new MavenSession((PlexusContainer)this.myContainer, repositorySession, request, (org.apache.maven.execution.MavenExecutionResult)new DefaultMavenExecutionResult());
        LegacySupport legacySupport = this.getComponent(LegacySupport.class);
        MavenSession oldSession = legacySupport.getSession();
        legacySupport.setSession(mavenSession);
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.<MavenProject>emptyList())) {
                listener.afterSessionStart(mavenSession);
            }
        }
        catch (MavenExecutionException e) {
            throw new RuntimeException(e);
        }
        try {
            runnable.run();
        }
        finally {
            legacySupport.setSession(oldSession);
        }
    }

    @NotNull
    public Collection<MavenExecutionResult> doResolveProject(final @NotNull Collection<File> files, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, final List<ResolutionListener> listeners) throws RemoteException {
        if (files == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(10);
        }
        if (activeProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(11);
        }
        if (inactiveProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(12);
        }
        File file = files.size() == 1 ? files.iterator().next() : null;
        final MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles, null);
        request.setUpdateSnapshots(this.myAlwaysUpdateSnapshots);
        final ArrayList executionResults = ContainerUtilRt.newArrayList();
        this.executeWithMavenSession(request, new Runnable(){

            @Override
            public void run() {
                try {
                    RepositorySystemSession repositorySession = Maven30ServerEmbedderImpl.this.getComponent(LegacySupport.class).getRepositorySession();
                    if (repositorySession instanceof DefaultRepositorySystemSession) {
                        ((DefaultRepositorySystemSession)repositorySession).setTransferListener((TransferListener)new Maven30TransferListenerAdapter(Maven30ServerEmbedderImpl.this.myCurrentIndicator));
                        if (Maven30ServerEmbedderImpl.this.myWorkspaceMap != null) {
                            ((DefaultRepositorySystemSession)repositorySession).setWorkspaceReader((WorkspaceReader)new Maven30WorkspaceReader(Maven30ServerEmbedderImpl.this.myWorkspaceMap));
                        }
                    }
                    List buildingResults = Maven30ServerEmbedderImpl.this.getProjectBuildingResults(request, files);
                    for (ProjectBuildingResult buildingResult : buildingResults) {
                        ArrayList<Exception> exceptions;
                        MavenProject project = buildingResult.getProject();
                        if (project == null) {
                            exceptions = new ArrayList<Exception>();
                            for (ModelProblem problem : buildingResult.getProblems()) {
                                exceptions.add(problem.getException());
                            }
                            MavenExecutionResult mavenExecutionResult = new MavenExecutionResult(buildingResult.getPomFile(), exceptions);
                            executionResults.add(mavenExecutionResult);
                            continue;
                        }
                        exceptions = new ArrayList();
                        Maven30ServerEmbedderImpl.this.loadExtensions(project, exceptions);
                        project.setDependencyArtifacts(project.createArtifacts(Maven30ServerEmbedderImpl.this.getComponent(ArtifactFactory.class), null, null));
                        if (Maven3ServerEmbedder.USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING) {
                            Maven30ServerEmbedderImpl.this.addMvn2CompatResults(project, exceptions, listeners, Maven30ServerEmbedderImpl.this.myLocalRepository, executionResults);
                            continue;
                        }
                        DependencyResolutionResult dependencyResolutionResult = Maven30ServerEmbedderImpl.this.resolveDependencies(project, repositorySession);
                        List dependencies = dependencyResolutionResult.getDependencies();
                        LinkedHashSet<org.apache.maven.artifact.Artifact> artifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>(dependencies.size());
                        for (Dependency dependency : dependencies) {
                            org.apache.maven.artifact.Artifact artifact = RepositoryUtils.toArtifact((Artifact)dependency.getArtifact());
                            artifact.setScope(dependency.getScope());
                            artifact.setOptional(dependency.isOptional());
                            artifacts.add(artifact);
                            Maven30ServerEmbedderImpl.this.resolveAsModule(artifact);
                        }
                        project.setArtifacts(artifacts);
                        executionResults.add(new MavenExecutionResult(project, dependencyResolutionResult, exceptions));
                    }
                }
                catch (Exception e) {
                    executionResults.add(Maven30ServerEmbedderImpl.handleException(e));
                }
            }
        });
        ArrayList arrayList = executionResults;
        if (arrayList == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private boolean resolveAsModule(org.apache.maven.artifact.Artifact a) {
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = map.findFileAndOriginalId(MavenModelConverter.createMavenId((org.apache.maven.artifact.Artifact)a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }

    private DependencyResolutionResult resolveDependencies(MavenProject project, RepositorySystemSession session) {
        DependencyResolutionResult resolutionResult;
        try {
            ProjectDependenciesResolver dependencyResolver = this.getComponent(ProjectDependenciesResolver.class);
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, session);
            resolutionResult = dependencyResolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            resolutionResult = e.getResult();
        }
        LinkedHashSet artifacts = new LinkedHashSet();
        if (resolutionResult.getDependencyGraph() != null) {
            RepositoryUtils.toArtifacts(artifacts, (Collection)resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), null);
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            for (org.apache.maven.artifact.Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
        }
        project.setResolvedArtifacts(artifacts);
        project.setArtifacts(artifacts);
        return resolutionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions(MavenProject project, List<Exception> exceptions) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Collection<AbstractMavenLifecycleParticipant> lifecycleParticipants = this.getLifecycleParticipants(Arrays.asList(project));
        if (!lifecycleParticipants.isEmpty()) {
            LegacySupport legacySupport = this.getComponent(LegacySupport.class);
            MavenSession session = legacySupport.getSession();
            session.setCurrentProject(project);
            session.setProjects(Arrays.asList(project));
            for (AbstractMavenLifecycleParticipant listener : lifecycleParticipants) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                try {
                    listener.afterProjectsRead(session);
                }
                catch (MavenExecutionException e) {
                    exceptions.add((Exception)((Object)e));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.myContainer.lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                Maven30ServerEmbedderImpl.warn("Failed to lookup lifecycle participants", e);
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                try {
                    lifecycleListeners.addAll(this.myContainer.lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    Maven30ServerEmbedderImpl.warn("Failed to lookup lifecycle participants", e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    public MavenExecutionRequest createRequest(@Nullable File file, @Nullable List<String> activeProfiles, @Nullable List<String> inactiveProfiles, @Nullable List<String> goals) throws RemoteException {
        DefaultMavenExecutionRequest result = new DefaultMavenExecutionRequest();
        try {
            this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)result, this.myMavenSettings);
            result.setGoals(goals == null ? Collections.emptyList() : goals);
            result.setPom(file);
            this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)result);
            result.setSystemProperties(this.mySystemProperties);
            Properties userProperties = new Properties();
            if (this.myUserProperties != null) {
                userProperties.putAll((Map<?, ?>)this.myUserProperties);
            }
            if (file != null) {
                userProperties.putAll((Map<?, ?>)Maven30ServerEmbedderImpl.getMavenAndJvmConfigProperties((File)file.getParentFile()));
            }
            result.setUserProperties(userProperties);
            if (activeProfiles != null) {
                result.setActiveProfiles(activeProfiles);
            }
            if (inactiveProfiles != null) {
                result.setInactiveProfiles(inactiveProfiles);
            }
            result.setCacheNotFound(true);
            result.setCacheTransferError(true);
            result.setStartTime(this.myBuildStartTime);
            return result;
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public File getLocalRepositoryFile() {
        File file = new File(this.myLocalRepository.getBasedir());
        if (file == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(14);
        }
        return file;
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@Nullable File file, MavenExecutionResult result, DependencyNode rootNode) throws RemoteException {
        Collection problems = MavenProjectProblem.createProblemsList();
        THashSet unresolvedArtifacts = new THashSet();
        this.validate(file, result.getExceptions(), problems, (Collection<MavenId>)unresolvedArtifacts);
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            MavenServerExecutionResult mavenServerExecutionResult = new MavenServerExecutionResult(null, problems, (Set)unresolvedArtifacts);
            if (mavenServerExecutionResult == null) {
                Maven30ServerEmbedderImpl.$$$reportNull$$$0(15);
            }
            return mavenServerExecutionResult;
        }
        MavenModel model = new MavenModel();
        try {
            if (USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING) {
                List dependencyNodes = rootNode == null ? Collections.emptyList() : rootNode.getChildren();
                model = MavenModelConverter.convertModel((Model)mavenProject.getModel(), (List)mavenProject.getCompileSourceRoots(), (List)mavenProject.getTestCompileSourceRoots(), (Collection)mavenProject.getArtifacts(), (Collection)dependencyNodes, (Collection)mavenProject.getExtensionArtifacts(), (File)this.getLocalRepositoryFile());
            } else {
                DependencyResolutionResult dependencyResolutionResult = result.getDependencyResolutionResult();
                org.sonatype.aether.graph.DependencyNode dependencyGraph = dependencyResolutionResult != null ? dependencyResolutionResult.getDependencyGraph() : null;
                List dependencyNodes = dependencyGraph != null ? dependencyGraph.getChildren() : Collections.emptyList();
                model = Maven30AetherModelConverter.convertModelWithAetherDependencyTree(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), dependencyNodes, mavenProject.getExtensionArtifacts(), this.getLocalRepositoryFile());
            }
        }
        catch (Exception e) {
            this.validate(mavenProject.getFile(), Collections.singleton(e), problems, null);
        }
        RemoteNativeMavenProjectHolder holder = new RemoteNativeMavenProjectHolder(mavenProject);
        try {
            UnicastRemoteObject.exportObject((Remote)holder, 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Collection<String> activatedProfiles = Maven30ServerEmbedderImpl.collectActivatedProfiles(mavenProject);
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, MavenModelConverter.convertToMap((Object)mavenProject.getModel()), (NativeMavenProjectHolder)holder, activatedProfiles);
        MavenServerExecutionResult mavenServerExecutionResult = new MavenServerExecutionResult(data, problems, (Set)unresolvedArtifacts);
        if (mavenServerExecutionResult == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(16);
        }
        return mavenServerExecutionResult;
    }

    /*
     * WARNING - void declaration
     */
    private void validate(@Nullable File file, @NotNull Collection<Exception> exceptions, @NotNull Collection<MavenProjectProblem> problems, @Nullable Collection<MavenId> unresolvedArtifacts) throws RemoteException {
        if (exceptions == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(17);
        }
        if (problems == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(18);
        }
        for (Throwable throwable : exceptions) {
            void var6_6;
            String path;
            if (throwable == null) continue;
            Maven3ServerGlobals.getLogger().info(throwable);
            if (throwable instanceof IllegalStateException && throwable.getCause() != null) {
                Throwable throwable2 = throwable.getCause();
            }
            String string = path = file == null ? "" : file.getPath();
            if (path.isEmpty() && var6_6 instanceof ProjectBuildingException) {
                File pomFile = ((ProjectBuildingException)var6_6).getPomFile();
                String string2 = path = pomFile == null ? "" : pomFile.getPath();
            }
            if (var6_6 instanceof InvalidProjectModelException) {
                ModelValidationResult modelValidationResult = ((InvalidProjectModelException)var6_6).getValidationResult();
                if (modelValidationResult != null) {
                    for (Object eachValidationProblem : modelValidationResult.getMessages()) {
                        problems.add(MavenProjectProblem.createStructureProblem((String)path, (String)((String)eachValidationProblem)));
                    }
                    continue;
                }
                problems.add(MavenProjectProblem.createStructureProblem((String)path, (String)var6_6.getCause().getMessage()));
                continue;
            }
            if (var6_6 instanceof ProjectBuildingException) {
                String causeMessage = var6_6.getCause() != null ? var6_6.getCause().getMessage() : var6_6.getMessage();
                problems.add(MavenProjectProblem.createStructureProblem((String)path, (String)causeMessage));
                continue;
            }
            problems.add(MavenProjectProblem.createStructureProblem((String)path, (String)var6_6.getMessage()));
        }
        if (unresolvedArtifacts != null) {
            unresolvedArtifacts.addAll(this.retrieveUnresolvedArtifactIds());
        }
    }

    private Set<MavenId> retrieveUnresolvedArtifactIds() {
        THashSet result = new THashSet();
        return result;
    }

    @NotNull
    public MavenArtifact resolve(@NotNull MavenArtifactInfo info, @NotNull List<MavenRemoteRepository> remoteRepositories) throws RemoteException, MavenServerProcessCanceledException {
        if (info == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(19);
        }
        if (remoteRepositories == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(20);
        }
        MavenArtifact mavenArtifact = this.doResolve(info, remoteRepositories);
        if (mavenArtifact == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(21);
        }
        return mavenArtifact;
    }

    @NotNull
    public List<MavenArtifact> resolveTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) throws RemoteException, MavenServerProcessCanceledException {
        List list;
        if (artifacts == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(22);
        }
        if (remoteRepositories == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(23);
        }
        try {
            LinkedHashSet<org.apache.maven.artifact.Artifact> toResolve = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
            for (MavenArtifactInfo each : artifacts) {
                toResolve.add(this.createArtifact(each));
            }
            org.apache.maven.artifact.Artifact project = this.getComponent(ArtifactFactory.class).createBuildArtifact("temp", "temp", "666", "pom");
            Set res = this.getComponent(ArtifactResolver.class).resolveTransitively(toResolve, project, Collections.EMPTY_MAP, this.myLocalRepository, this.convertRepositories(remoteRepositories), this.getComponent(ArtifactMetadataSource.class)).getArtifacts();
            list = MavenModelConverter.convertArtifacts((Collection)res, (Map)new THashMap(), (File)this.getLocalRepositoryFile());
        }
        catch (ArtifactResolutionException e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
        if (list == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(24);
        }
        return list;
        List<MavenArtifact> list2 = Collections.emptyList();
        if (list2 == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(25);
        }
        return list2;
    }

    public Collection<MavenArtifact> resolvePlugin(@NotNull MavenPlugin plugin, @NotNull List<MavenRemoteRepository> repositories, int nativeMavenProjectId, boolean transitive) throws RemoteException, MavenServerProcessCanceledException {
        if (plugin == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(26);
        }
        if (repositories == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(27);
        }
        try {
            Plugin mavenPlugin = new Plugin();
            mavenPlugin.setGroupId(plugin.getGroupId());
            mavenPlugin.setArtifactId(plugin.getArtifactId());
            mavenPlugin.setVersion(plugin.getVersion());
            MavenProject project = RemoteNativeMavenProjectHolder.findProjectById((int)nativeMavenProjectId);
            Plugin pluginFromProject = (Plugin)project.getBuild().getPluginsAsMap().get(plugin.getGroupId() + ':' + plugin.getArtifactId());
            if (pluginFromProject != null) {
                mavenPlugin.setDependencies(pluginFromProject.getDependencies());
            }
            MavenExecutionRequest request = this.createRequest(null, null, null, null);
            DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
            RepositorySystemSession repositorySystemSession = maven.newRepositorySession(request);
            PluginDependenciesResolver pluginDependenciesResolver = this.getComponent(PluginDependenciesResolver.class);
            Artifact pluginArtifact = pluginDependenciesResolver.resolve(mavenPlugin, project.getRemotePluginRepositories(), repositorySystemSession);
            org.sonatype.aether.graph.DependencyNode node = pluginDependenciesResolver.resolve(mavenPlugin, pluginArtifact, null, project.getRemotePluginRepositories(), repositorySystemSession);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            ArrayList<MavenArtifact> res = new ArrayList<MavenArtifact>();
            for (Artifact artifact : nlg.getArtifacts(true)) {
                if (Comparing.equal((String)artifact.getArtifactId(), (String)plugin.getArtifactId()) && Comparing.equal((String)artifact.getGroupId(), (String)plugin.getGroupId())) continue;
                res.add(MavenModelConverter.convertArtifact((org.apache.maven.artifact.Artifact)RepositoryUtils.toArtifact((Artifact)artifact), (File)this.getLocalRepositoryFile()));
            }
            return res;
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
            return Collections.emptyList();
        }
    }

    private MavenArtifact doResolve(MavenArtifactInfo info, List<MavenRemoteRepository> remoteRepositories) throws RemoteException {
        org.apache.maven.artifact.Artifact resolved = this.doResolve(this.createArtifact(info), this.convertRepositories(remoteRepositories));
        return MavenModelConverter.convertArtifact((org.apache.maven.artifact.Artifact)resolved, (File)this.getLocalRepositoryFile());
    }

    private org.apache.maven.artifact.Artifact doResolve(org.apache.maven.artifact.Artifact artifact, List<ArtifactRepository> remoteRepositories) throws RemoteException {
        try {
            return this.resolve(artifact, remoteRepositories);
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
            return artifact;
        }
    }

    private org.apache.maven.artifact.Artifact resolve(@NotNull org.apache.maven.artifact.Artifact artifact, @NotNull List<ArtifactRepository> repos) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifact == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(28);
        }
        if (repos == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(29);
        }
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setRemoteRepositories(repos);
        try {
            this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)request, this.myMavenSettings);
            this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)request);
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new RuntimeException(e);
        }
        this.getComponent(ArtifactResolver.class).resolve(artifact, request.getRemoteRepositories(), this.myLocalRepository);
        return artifact;
    }

    @NotNull
    protected List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> repositories) throws RemoteException {
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        for (MavenRemoteRepository each : repositories) {
            try {
                ArtifactRepositoryFactory factory = this.getComponent(ArtifactRepositoryFactory.class);
                result.add(ProjectUtils.buildArtifactRepository((Repository)MavenModelConverter.toNativeRepository((MavenRemoteRepository)each), (ArtifactRepositoryFactory)factory, (PlexusContainer)this.myContainer));
            }
            catch (InvalidRepositoryException e) {
                Maven3ServerGlobals.getLogger().warn((Throwable)e);
            }
        }
        if (this.getComponent(LegacySupport.class).getRepositorySession() == null) {
            this.myRepositorySystem.injectMirror(result, this.myMavenSettings.getMirrors());
            this.myRepositorySystem.injectProxy(result, this.myMavenSettings.getProxies());
            this.myRepositorySystem.injectAuthentication(result, this.myMavenSettings.getServers());
        }
        ArrayList<ArtifactRepository> arrayList = result;
        if (arrayList == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    private org.apache.maven.artifact.Artifact createArtifact(MavenArtifactInfo info) {
        return this.getComponent(ArtifactFactory.class).createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getPackaging(), info.getClassifier());
    }

    @NotNull
    public MavenServerExecutionResult execute(@NotNull File file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles, @NotNull List<String> goals, @NotNull List<String> selectedProjects, boolean alsoMake, boolean alsoMakeDependents) throws RemoteException, MavenServerProcessCanceledException {
        if (file == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(31);
        }
        if (activeProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(32);
        }
        if (inactiveProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(33);
        }
        if (goals == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(34);
        }
        if (selectedProjects == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(35);
        }
        MavenExecutionResult result = this.doExecute(file, new ArrayList<String>(activeProfiles), new ArrayList<String>(inactiveProfiles), goals, selectedProjects, alsoMake, alsoMakeDependents);
        MavenServerExecutionResult mavenServerExecutionResult = this.createExecutionResult(file, result, null);
        if (mavenServerExecutionResult == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(36);
        }
        return mavenServerExecutionResult;
    }

    private MavenExecutionResult doExecute(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, @NotNull List<String> goals, @NotNull List<String> selectedProjects, boolean alsoMake, boolean alsoMakeDependents) throws RemoteException {
        if (file == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(37);
        }
        if (activeProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(38);
        }
        if (inactiveProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(39);
        }
        if (goals == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(40);
        }
        if (selectedProjects == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(41);
        }
        MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles, goals);
        if (!selectedProjects.isEmpty()) {
            request.setRecursive(true);
            request.setSelectedProjects(selectedProjects);
            if (alsoMake && alsoMakeDependents) {
                request.setMakeBehavior("make-both");
            } else if (alsoMake) {
                request.setMakeBehavior("make");
            } else if (alsoMakeDependents) {
                request.setMakeBehavior("make-dependents");
            }
        }
        org.apache.maven.execution.MavenExecutionResult executionResult = this.safeExecute(request, this.getComponent(Maven.class));
        return new MavenExecutionResult(executionResult.getProject(), Maven30ServerEmbedderImpl.filterExceptions(executionResult.getExceptions()));
    }

    private org.apache.maven.execution.MavenExecutionResult safeExecute(MavenExecutionRequest request, Maven maven) throws RemoteException {
        MavenLeakDetector detector = new MavenLeakDetector().mark();
        org.apache.maven.execution.MavenExecutionResult result = maven.execute(request);
        detector.check();
        return result;
    }

    public void reset() throws RemoteException {
        try {
            RepositoryMetadataManager repositoryMetadataManager;
            ArtifactResolver artifactResolver;
            this.setConsoleAndIndicator(null, null);
            ArtifactFactory artifactFactory = this.getComponent(ArtifactFactory.class);
            if (artifactFactory instanceof CustomMaven3ArtifactFactory) {
                ((CustomMaven3ArtifactFactory)artifactFactory).reset();
            }
            if ((artifactResolver = this.getComponent(ArtifactResolver.class)) instanceof CustomMaven30ArtifactResolver) {
                ((CustomMaven30ArtifactResolver)artifactResolver).reset();
            }
            if ((repositoryMetadataManager = this.getComponent(RepositoryMetadataManager.class)) instanceof CustomMaven3RepositoryMetadataManager) {
                ((CustomMaven3RepositoryMetadataManager)repositoryMetadataManager).reset();
            }
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public void release() throws RemoteException {
        this.myContainer.dispose();
    }

    public void clearCaches() throws RemoteException {
    }

    public void clearCachesFor(MavenId projectId) throws RemoteException {
    }

    protected ArtifactRepository getLocalRepository() {
        return this.myLocalRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/Maven30ServerEmbedderImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 7: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goals";
                break;
            }
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/Maven30ServerEmbedderImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProject";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepositoryFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutionResult";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTransitively";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRepositories";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveProject";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProject";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 19: 
            case 20: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveTransitively";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugin";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyLogger
    implements org.sonatype.aether.spi.log.Logger {
        private MyLogger() {
        }

        public boolean isDebugEnabled() {
            return Maven30ServerEmbedderImpl.this.myConsoleWrapper.isDebugEnabled();
        }

        public void debug(String s) {
            Maven30ServerEmbedderImpl.this.myConsoleWrapper.debug(s);
        }

        public void debug(String s, Throwable throwable) {
            Maven30ServerEmbedderImpl.this.myConsoleWrapper.debug(s, throwable);
        }

        public boolean isWarnEnabled() {
            return Maven30ServerEmbedderImpl.this.myConsoleWrapper.isWarnEnabled();
        }

        public void warn(String s) {
            Maven30ServerEmbedderImpl.this.myConsoleWrapper.warn(s);
        }

        public void warn(String s, Throwable throwable) {
            Maven30ServerEmbedderImpl.this.myConsoleWrapper.debug(s, throwable);
        }
    }

    public static interface Computable<T> {
        public T compute();
    }
}

