/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.IdeaClassFinder;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.ClassUtil;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageData;
import jetbrains.coverage.report.ReportBuilderFactory;
import jetbrains.coverage.report.SourceCodeProvider;
import jetbrains.coverage.report.html.HTMLReportBuilder;
import jetbrains.coverage.report.idea.IDEACoverageData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCoverageRunner
extends CoverageRunner {
    private static final String JAVA_COVERAGE_AGENT_AGENT_PATH = "java.test.agent.lib.path";

    public boolean isJdk7Compatible() {
        return true;
    }

    @Override
    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            JavaCoverageRunner.$$$reportNull$$$0(0);
        }
        return engine instanceof JavaCoverageEngine;
    }

    public abstract void appendCoverageArgument(String var1, @Nullable String[] var2, SimpleJavaParameters var3, boolean var4, boolean var5);

    public void appendCoverageArgument(String sessionDataFilePath, @Nullable String[] patterns, String[] excludePatterns, SimpleJavaParameters parameters, boolean collectLineInfo, boolean isSampling, String sourceMapPath) {
        this.appendCoverageArgument(sessionDataFilePath, patterns, parameters, collectLineInfo, isSampling);
    }

    public boolean isBranchInfoAvailable(boolean sampling) {
        return !sampling;
    }

    public void generateReport(final CoverageSuitesBundle suite, final Project project) throws IOException {
        ProjectData projectData = suite.getCoverageData();
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        File tempFile = FileUtil.createTempFile((String)"temp", (String)"");
        tempFile.deleteOnExit();
        new SaveHook(tempFile, true, (ClassFinder)new IdeaClassFinder(project, suite)).save(projectData);
        HTMLReportBuilder builder = ReportBuilderFactory.createHTMLReportBuilder();
        builder.setReportDir(new File(settings.OUTPUT_DIRECTORY));
        SourceCodeProvider sourceCodeProvider = classname -> (String)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            if (project.isDisposed()) {
                return "";
            }
            PsiClass psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)project), (String)classname);
            return psiClass != null ? psiClass.getNavigationElement().getContainingFile().getText() : "";
        });
        builder.generateReport((CoverageData)new IDEACoverageData(projectData, sourceCodeProvider){

            @NotNull
            public Collection<ClassInfo> getClasses() {
                Collection classes = super.getClasses();
                JavaCoverageSuite javaCoverageSuite = (JavaCoverageSuite)suite.getSuites()[0];
                if (!suite.isTrackTestFolders() || javaCoverageSuite.getExcludedClassNames().length > 0 || javaCoverageSuite.getExcludedPackageNames().length > 0) {
                    JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                    GlobalSearchScope productionScope = !suite.isTrackTestFolders() ? GlobalSearchScopesCore.projectProductionScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
                    Iterator iterator = classes.iterator();
                    while (iterator.hasNext()) {
                        ClassInfo aClass = (ClassInfo)iterator.next();
                        PsiClass psiClass = (PsiClass)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                            if (project.isDisposed()) {
                                return null;
                            }
                            return psiFacade.findClass(aClass.getFQName(), productionScope);
                        });
                        if (psiClass != null && suite.getCoverageEngine().acceptedByFilters(psiClass.getContainingFile(), suite)) continue;
                        iterator.remove();
                    }
                }
                Collection collection = classes;
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageRunner$1", "getClasses"));
            }
        });
    }

    @Nullable
    public static String handleSpacesInAgentPath(@NotNull String agentPath) {
        if (agentPath == null) {
            JavaCoverageRunner.$$$reportNull$$$0(1);
        }
        return JavaExecutionUtil.handleSpacesInAgentPath((String)agentPath, (String)"testAgent", (String)JAVA_COVERAGE_AGENT_AGENT_PATH);
    }

    protected static void write2file(File tempFile, String arg) throws IOException {
        FileUtil.writeToFile((File)tempFile, (byte[])(arg + "\n").getBytes(CharsetToolkit.UTF8_CHARSET), (boolean)true);
    }

    protected static File createTempFile() throws IOException {
        String userDefined;
        File tempFile = FileUtil.createTempFile((String)"coverage", (String)"args");
        if (!SystemInfo.isWindows && tempFile.getAbsolutePath().contains(" ") && (tempFile = FileUtil.createTempFile((File)new File(PathManager.getSystemPath(), "coverage"), (String)"coverage", (String)"args", (boolean)true)).getAbsolutePath().contains(" ") && (userDefined = System.getProperty(JAVA_COVERAGE_AGENT_AGENT_PATH)) != null && new File(userDefined).isDirectory()) {
            tempFile = FileUtil.createTempFile((File)new File(userDefined), (String)"coverage", (String)"args", (boolean)true);
        }
        return tempFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/JavaCoverageRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsCoverageEngine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleSpacesInAgentPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

