/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.CucumberOptions;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.formatter.PluginFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RuntimeOptionsFactory {
    private final Class clazz;
    private boolean featuresSpecified = false;
    private boolean glueSpecified = false;
    private boolean pluginSpecified = false;

    public RuntimeOptionsFactory(Class clazz) {
        this.clazz = clazz;
    }

    public RuntimeOptions create() {
        List<String> args = this.buildArgsFromOptions();
        return new RuntimeOptions(args);
    }

    private List<String> buildArgsFromOptions() {
        ArrayList<String> args = new ArrayList<String>();
        Class classWithOptions = this.clazz;
        while (this.hasSuperClass(classWithOptions)) {
            CucumberOptions options = this.getOptions(classWithOptions);
            if (options != null) {
                this.addDryRun(options, args);
                this.addMonochrome(options, args);
                this.addTags(options, args);
                this.addPlugins(options, args);
                this.addStrict(options, args);
                this.addName(options, args);
                this.addSnippets(options, args);
                this.addGlue(options, args);
                this.addFeatures(options, args);
            }
            classWithOptions = classWithOptions.getSuperclass();
        }
        this.addDefaultFeaturePathIfNoFeaturePathIsSpecified(args, this.clazz);
        this.addDefaultGlueIfNoGlueIsSpecified(args, this.clazz);
        this.addNullFormatIfNoPluginIsSpecified(args);
        return args;
    }

    private void addName(CucumberOptions options, List<String> args) {
        for (String name : options.name()) {
            args.add("--name");
            args.add(name);
        }
    }

    private void addSnippets(CucumberOptions options, List<String> args) {
        args.add("--snippets");
        args.add(options.snippets().toString());
    }

    private void addDryRun(CucumberOptions options, List<String> args) {
        if (options.dryRun()) {
            args.add("--dry-run");
        }
    }

    private void addMonochrome(CucumberOptions options, List<String> args) {
        if (options.monochrome() || this.runningInEnvironmentWithoutAnsiSupport()) {
            args.add("--monochrome");
        }
    }

    private void addTags(CucumberOptions options, List<String> args) {
        for (String tags : options.tags()) {
            args.add("--tags");
            args.add(tags);
        }
    }

    private void addPlugins(CucumberOptions options, List<String> args) {
        ArrayList<String> plugins = new ArrayList<String>();
        plugins.addAll(Arrays.asList(options.plugin()));
        plugins.addAll(Arrays.asList(options.format()));
        for (String plugin : plugins) {
            args.add("--plugin");
            args.add(plugin);
            if (!PluginFactory.isFormatterName(plugin)) continue;
            this.pluginSpecified = true;
        }
    }

    private void addNullFormatIfNoPluginIsSpecified(List<String> args) {
        if (!this.pluginSpecified) {
            args.add("--plugin");
            args.add("null");
        }
    }

    private void addFeatures(CucumberOptions options, List<String> args) {
        if (options != null && options.features().length != 0) {
            Collections.addAll(args, options.features());
            this.featuresSpecified = true;
        }
    }

    private void addDefaultFeaturePathIfNoFeaturePathIsSpecified(List<String> args, Class clazz) {
        if (!this.featuresSpecified) {
            args.add("classpath:" + RuntimeOptionsFactory.packagePath(clazz));
        }
    }

    private void addGlue(CucumberOptions options, List<String> args) {
        for (String glue : options.glue()) {
            args.add("--glue");
            args.add(glue);
            this.glueSpecified = true;
        }
    }

    private void addDefaultGlueIfNoGlueIsSpecified(List<String> args, Class clazz) {
        if (!this.glueSpecified) {
            args.add("--glue");
            args.add("classpath:" + RuntimeOptionsFactory.packagePath(clazz));
        }
    }

    private void addStrict(CucumberOptions options, List<String> args) {
        if (options.strict()) {
            args.add("--strict");
        }
    }

    static String packagePath(Class clazz) {
        return RuntimeOptionsFactory.packagePath(RuntimeOptionsFactory.packageName(clazz.getName()));
    }

    static String packagePath(String packageName) {
        return packageName.replace('.', '/');
    }

    static String packageName(String className) {
        return className.substring(0, Math.max(0, className.lastIndexOf(".")));
    }

    private boolean runningInEnvironmentWithoutAnsiSupport() {
        boolean intelliJidea = System.getProperty("idea.launcher.bin.path") != null;
        return intelliJidea;
    }

    private boolean hasSuperClass(Class classWithOptions) {
        return classWithOptions != Object.class;
    }

    private CucumberOptions getOptions(Class<?> clazz) {
        return clazz.getAnnotation(CucumberOptions.class);
    }
}

