/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;

public class OneToManyPathsMapping
extends AbstractStateStorage<String, Collection<String>> {
    public OneToManyPathsMapping(File storePath) throws IOException {
        super(storePath, PathStringDescriptor.INSTANCE, new PathCollectionExternalizer());
    }

    @Override
    public void update(@NotNull String keyPath, @NotNull Collection<String> boundPaths) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(0);
        }
        if (boundPaths == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(1);
        }
        super.update(FileUtil.toSystemIndependentName((String)keyPath), OneToManyPathsMapping.normalizePaths(boundPaths));
    }

    @Override
    public final void update(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(2);
        }
        if (boundPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(3);
        }
        super.update(FileUtil.toSystemIndependentName((String)keyPath), Collections.singleton(FileUtil.toSystemIndependentName((String)boundPath)));
    }

    @Override
    public final void appendData(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(4);
        }
        if (boundPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(5);
        }
        super.appendData(FileUtil.toSystemIndependentName((String)keyPath), Collections.singleton(FileUtil.toSystemIndependentName((String)boundPath)));
    }

    @Override
    public void appendData(@NotNull String keyPath, @NotNull Collection<String> boundPaths) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(6);
        }
        if (boundPaths == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(7);
        }
        super.appendData(FileUtil.toSystemIndependentName((String)keyPath), OneToManyPathsMapping.normalizePaths(boundPaths));
    }

    @Override
    @Nullable
    public Collection<String> getState(@NotNull String keyPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(8);
        }
        return (Collection)super.getState(FileUtil.toSystemIndependentName((String)keyPath));
    }

    @Override
    public void remove(@NotNull String keyPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(9);
        }
        super.remove(FileUtil.toSystemIndependentName((String)keyPath));
    }

    public final void removeData(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        Collection<String> outputPaths;
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(10);
        }
        if (boundPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(11);
        }
        if ((outputPaths = this.getState(FileUtil.toSystemIndependentName((String)keyPath))) != null) {
            boolean removed = outputPaths.remove(FileUtil.toSystemIndependentName((String)boundPath));
            if (outputPaths.isEmpty()) {
                this.remove(keyPath);
            } else if (removed) {
                this.update(keyPath, outputPaths);
            }
        }
    }

    private static Collection<String> normalizePaths(Collection<String> outputs) {
        ArrayList<String> normalized = new ArrayList<String>(outputs.size());
        for (String out : outputs) {
            normalized.add(FileUtil.toSystemIndependentName((String)out));
        }
        return normalized;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPath";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundPaths";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundPath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/storage/OneToManyPathsMapping";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "appendData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "removeData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PathCollectionExternalizer
    implements DataExternalizer<Collection<String>> {
        private PathCollectionExternalizer() {
        }

        public void save(@NotNull DataOutput out, Collection<String> value) throws IOException {
            if (out == null) {
                PathCollectionExternalizer.$$$reportNull$$$0(0);
            }
            for (String str : value) {
                IOUtil.writeUTF((DataOutput)out, (String)str);
            }
        }

        public Collection<String> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                PathCollectionExternalizer.$$$reportNull$$$0(1);
            }
            THashSet result = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                String str = IOUtil.readUTF((DataInput)stream);
                result.add(str);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/OneToManyPathsMapping$PathCollectionExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

