/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.control.ScrollBar;
import javafx.util.Duration;

public class HierarchyAnimationScheduler {
    private Timeline timeline;
    private final double rate = 4.0;

    public void playDecrementAnimation(ScrollBar scrollBar) {
        assert (scrollBar != null);
        double minValue = scrollBar.getMin();
        assert (!this.isTimelineRunning());
        if (scrollBar.getValue() > minValue) {
            double scrollBarHeight = scrollBar.getHeight();
            double scrollBarVisibleAmount = scrollBar.getVisibleAmount();
            double scrollBarValue = scrollBar.getValue();
            double height = scrollBarHeight * scrollBarValue;
            double duration = height * 4.0 / scrollBarVisibleAmount;
            this.getTimeline().getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(duration), new KeyValue[]{new KeyValue((WritableValue)scrollBar.valueProperty(), (Object)minValue)})});
            this.getTimeline().play();
        }
    }

    public void playIncrementAnimation(ScrollBar scrollBar) {
        assert (scrollBar != null);
        double maxValue = scrollBar.getMax();
        assert (!this.isTimelineRunning());
        if (scrollBar.getValue() < maxValue) {
            double scrollBarHeight = scrollBar.getHeight();
            double scrollBarVisibleAmount = scrollBar.getVisibleAmount();
            double scrollBarValue = scrollBar.getValue();
            double height = scrollBarHeight * (scrollBar.getMax() - scrollBarValue);
            double duration = height * 4.0 / scrollBarVisibleAmount;
            this.getTimeline().getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(duration), new KeyValue[]{new KeyValue((WritableValue)scrollBar.valueProperty(), (Object)maxValue)})});
            this.getTimeline().play();
        }
    }

    public boolean isTimelineRunning() {
        return this.timeline == null ? false : this.timeline.getStatus() == Animation.Status.RUNNING;
    }

    public void stopTimeline() {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline = null;
        }
    }

    private Timeline getTimeline() {
        if (this.timeline == null) {
            this.timeline = new Timeline();
        }
        return this.timeline;
    }
}

