/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.shape;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.shape.Ellipse;

public class EllipseResizer
extends AbstractResizer<Ellipse> {
    private final double originalRadiusX;
    private final double originalRadiusY;
    private final PropertyName radiusXName = new PropertyName("radiusX");
    private final PropertyName radiusYName = new PropertyName("radiusY");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public EllipseResizer(Ellipse sceneGraphObject) {
        super(sceneGraphObject);
        this.originalRadiusX = sceneGraphObject.getRadiusX();
        this.originalRadiusY = sceneGraphObject.getRadiusY();
        this.propertyNames.add(this.radiusXName);
        this.propertyNames.add(this.radiusYName);
    }

    @Override
    public final Bounds computeBounds(double width, double height) {
        double radiusX = Math.round(width / 2.0);
        double radiusY = Math.round(height / 2.0);
        double minX = ((Ellipse)this.sceneGraphObject).getCenterX() - radiusX;
        double minY = ((Ellipse)this.sceneGraphObject).getCenterY() - radiusY;
        return new BoundingBox(minX, minY, 2.0 * radiusX, 2.0 * radiusY);
    }

    @Override
    public AbstractResizer.Feature getFeature() {
        return AbstractResizer.Feature.FREE;
    }

    @Override
    public void changeWidth(double width) {
        ((Ellipse)this.sceneGraphObject).setRadiusX((double)Math.round(width / 2.0));
    }

    @Override
    public void changeHeight(double height) {
        ((Ellipse)this.sceneGraphObject).setRadiusY((double)Math.round(height / 2.0));
    }

    @Override
    public void revertToOriginalSize() {
        ((Ellipse)this.sceneGraphObject).setRadiusX(this.originalRadiusX);
        ((Ellipse)this.sceneGraphObject).setRadiusY(this.originalRadiusY);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.radiusXName) ? Double.valueOf(((Ellipse)this.sceneGraphObject).getRadiusX()) : (propertyName.equals(this.radiusYName) ? Double.valueOf(((Ellipse)this.sceneGraphObject).getRadiusY()) : null);
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((Ellipse)this.sceneGraphObject).getRadiusX(), this.originalRadiusX)) {
            result.put(this.radiusXName, ((Ellipse)this.sceneGraphObject).getRadiusX());
        }
        if (!MathUtils.equals(((Ellipse)this.sceneGraphObject).getRadiusY(), this.originalRadiusY)) {
            result.put(this.radiusYName, ((Ellipse)this.sceneGraphObject).getRadiusY());
        }
        return result;
    }
}

