/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.lexer;

import java.io.IOException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.GeneratedLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\"\u001a\u00020#J\n\u0010$\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020#H\u0002J\"\u0010(\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\t\"\u0004\b\u0019\u0010\u000bR$\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\t\"\u0004\b\u001c\u0010\u000bR(\u0010\u001d\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006*"}, d2={"Lorg/intellij/markdown/lexer/MarkdownLexer;", "", "baseLexer", "Lorg/intellij/markdown/lexer/GeneratedLexer;", "(Lorg/intellij/markdown/lexer/GeneratedLexer;)V", "<set-?>", "", "bufferEnd", "getBufferEnd", "()I", "setBufferEnd", "(I)V", "bufferStart", "getBufferStart", "setBufferStart", "nextType", "Lorg/intellij/markdown/IElementType;", "", "originalText", "getOriginalText", "()Ljava/lang/CharSequence;", "setOriginalText", "(Ljava/lang/CharSequence;)V", "tokenEnd", "getTokenEnd", "setTokenEnd", "tokenStart", "getTokenStart", "setTokenStart", "type", "getType", "()Lorg/intellij/markdown/IElementType;", "setType", "(Lorg/intellij/markdown/IElementType;)V", "advance", "", "advanceBase", "calcNextType", "", "locateToken", "start", "Companion", "52a7eb3df0584991-compileKotlin"})
public class MarkdownLexer {
    @Nullable
    private IElementType type;
    private IElementType nextType;
    @NotNull
    private CharSequence originalText;
    private int bufferStart;
    private int bufferEnd;
    private int tokenStart;
    private int tokenEnd;
    private final GeneratedLexer baseLexer;
    private static final Set<IElementType> TOKENS_TO_MERGE;
    public static final Companion Companion;

    @Nullable
    public final IElementType getType() {
        return this.type;
    }

    private final void setType(IElementType iElementType) {
        this.type = iElementType;
    }

    @NotNull
    public final CharSequence getOriginalText() {
        return this.originalText;
    }

    private final void setOriginalText(CharSequence charSequence) {
        this.originalText = charSequence;
    }

    public final int getBufferStart() {
        return this.bufferStart;
    }

    private final void setBufferStart(int n) {
        this.bufferStart = n;
    }

    public final int getBufferEnd() {
        return this.bufferEnd;
    }

    private final void setBufferEnd(int n) {
        this.bufferEnd = n;
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    private final void setTokenStart(int n) {
        this.tokenStart = n;
    }

    public final int getTokenEnd() {
        return this.tokenEnd;
    }

    private final void setTokenEnd(int n) {
        this.tokenEnd = n;
    }

    public final void start(@NotNull CharSequence originalText, int bufferStart, int bufferEnd) {
        Intrinsics.checkParameterIsNotNull((Object)originalText, (String)"originalText");
        this.originalText = originalText;
        this.bufferStart = bufferStart;
        this.bufferEnd = bufferEnd;
        this.baseLexer.reset(originalText, bufferStart, bufferEnd, 0);
        this.type = this.advanceBase();
        this.tokenStart = this.baseLexer.getTokenStart();
        this.calcNextType();
    }

    public static /* bridge */ /* synthetic */ void start$default(MarkdownLexer markdownLexer, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        markdownLexer.start(charSequence, n, n2);
    }

    public final boolean advance() {
        return this.locateToken();
    }

    private final boolean locateToken() {
        this.type = this.nextType;
        this.tokenStart = this.tokenEnd;
        if (this.type == null) {
            return false;
        }
        this.calcNextType();
        return true;
    }

    private final void calcNextType() {
        IElementType iElementType;
        IElementType it;
        do {
            this.tokenEnd = this.baseLexer.getTokenEnd();
            this.nextType = this.advanceBase();
            iElementType = this.type;
        } while (Intrinsics.areEqual((Object)this.nextType, (Object)(it = iElementType)) && it != null && MarkdownLexer.Companion.getTOKENS_TO_MERGE().contains(it));
    }

    private final IElementType advanceBase() {
        try {
            return this.baseLexer.advance();
        }
        catch (IOException e) {
            Throwable throwable = e;
            Throwable throwable2 = throwable;
            if (throwable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
            }
            throwable2.printStackTrace();
            throw (Throwable)((Object)new AssertionError((Object)"This could not be!"));
        }
    }

    public MarkdownLexer(@NotNull GeneratedLexer baseLexer) {
        Intrinsics.checkParameterIsNotNull((Object)baseLexer, (String)"baseLexer");
        this.baseLexer = baseLexer;
        this.originalText = "";
    }

    static {
        Companion = new Companion(null);
        TOKENS_TO_MERGE = SetsKt.setOf((Object[])new IElementType[]{MarkdownTokenTypes.TEXT, MarkdownTokenTypes.WHITE_SPACE, MarkdownTokenTypes.CODE_LINE, MarkdownTokenTypes.LINK_ID, MarkdownTokenTypes.LINK_TITLE, MarkdownTokenTypes.URL, MarkdownTokenTypes.AUTOLINK, MarkdownTokenTypes.EMAIL_AUTOLINK, MarkdownTokenTypes.BAD_CHARACTER});
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/markdown/lexer/MarkdownLexer$Companion;", "", "()V", "TOKENS_TO_MERGE", "", "Lorg/intellij/markdown/IElementType;", "getTOKENS_TO_MERGE", "()Ljava/util/Set;", "52a7eb3df0584991-compileKotlin"})
    public static final class Companion {
        private final Set<IElementType> getTOKENS_TO_MERGE() {
            return TOKENS_TO_MERGE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

