/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.intellij.plugins.intelliLang.util.ContextComputationProcessor;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtilEx {
    private static final PsiConstantEvaluationHelperImpl CONSTANT_EVALUATION_HELPER = new PsiConstantEvaluationHelperImpl();

    private AnnotationUtilEx() {
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatedElementFor(@Nullable PsiElement element, LookupType type) {
        while (element != null) {
            PsiElement e;
            if ((type == LookupType.PREFER_DECLARATION || type == LookupType.DECLARATION_ONLY) && element instanceof PsiReferenceExpression) {
                PsiElement e2 = ((PsiReferenceExpression)element).resolve();
                if (e2 instanceof PsiModifierListOwner) {
                    return (PsiModifierListOwner)e2;
                }
                if (type == LookupType.DECLARATION_ONLY) {
                    return null;
                }
            }
            element = ContextComputationProcessor.getTopLevelInjectionTarget(element);
            PsiElement parent = element.getParent();
            if (element instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)element).getOperationTokenType() == JavaTokenType.PLUSEQ) {
                element = ((PsiAssignmentExpression)element).getLExpression();
                continue;
            }
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression p = (PsiAssignmentExpression)parent;
                if (p.getRExpression() == element) {
                    element = p.getLExpression();
                    continue;
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiMethod m = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class);
                if (m != null) {
                    return m;
                }
            } else {
                if (parent instanceof PsiModifierListOwner) {
                    return (PsiModifierListOwner)parent;
                }
                if (parent instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue value = (PsiArrayInitializerMemberValue)parent;
                    PsiElement pair = value.getParent();
                    if (pair instanceof PsiNameValuePair) {
                        return AnnotationUtil.getAnnotationMethod((PsiNameValuePair)((PsiNameValuePair)pair));
                    }
                } else {
                    if (parent instanceof PsiNameValuePair) {
                        return AnnotationUtil.getAnnotationMethod((PsiNameValuePair)((PsiNameValuePair)parent));
                    }
                    return PsiUtilEx.getParameterForArgument(element);
                }
            }
            if (type != LookupType.DECLARATION_ONLY && element instanceof PsiReferenceExpression && (e = ((PsiReferenceExpression)element).resolve()) instanceof PsiModifierListOwner) {
                return (PsiModifierListOwner)e;
            }
            return null;
        }
        return null;
    }

    public static void visitAnnotatedElements(@Nullable PsiElement element, AnnotatedElementVisitor visitor) {
        if (element == null) {
            return;
        }
        for (PsiElement cur = ContextComputationProcessor.getTopLevelInjectionTarget(element); cur != null; cur = cur.getParent()) {
            if (AnnotationUtilEx.visitAnnotatedElementInner(cur, visitor)) continue;
            return;
        }
    }

    private static boolean visitAnnotatedElementInner(PsiElement element, AnnotatedElementVisitor visitor) {
        PsiElement parent = element.getParent();
        if (element instanceof PsiReferenceExpression) {
            if (parent instanceof PsiReferenceExpression) {
                return false;
            }
            if (!visitor.visitReference((PsiReferenceExpression)element)) {
                return false;
            }
        } else if (element instanceof PsiNameValuePair && parent != null && parent.getParent() instanceof PsiAnnotation) {
            return visitor.visitAnnotationParameter((PsiNameValuePair)element, (PsiAnnotation)parent.getParent());
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiExpression left;
            PsiAssignmentExpression p = (PsiAssignmentExpression)parent;
            if ((p.getRExpression() == element || p.getOperationTokenType() == JavaTokenType.PLUSEQ) && (left = p.getLExpression()) instanceof PsiReferenceExpression && !visitor.visitReference((PsiReferenceExpression)left)) {
                return false;
            }
        } else {
            if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() == element) {
                return false;
            }
            if (parent instanceof PsiFunctionalExpression) {
                PsiMethod m = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)parent);
                if (m != null && !visitor.visitMethodReturnStatement(element, m)) {
                    return false;
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiMethod m;
                PsiElement e = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, PsiFunctionalExpression.class});
                PsiMethod psiMethod = e == null ? null : (m = e instanceof PsiMethod ? (PsiMethod)e : LambdaUtil.getFunctionalInterfaceMethod((PsiElement)e));
                if (m != null && !visitor.visitMethodReturnStatement(parent, m)) {
                    return false;
                }
            } else {
                if (parent instanceof PsiVariable) {
                    return visitor.visitVariable((PsiVariable)parent);
                }
                if (parent instanceof PsiModifierListOwner) {
                    return false;
                }
                if (parent instanceof PsiArrayInitializerMemberValue || parent instanceof PsiNameValuePair) {
                    return true;
                }
                if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCall) {
                    return visitor.visitMethodParameter((PsiExpression)element, (PsiCall)parent.getParent());
                }
            }
        }
        return true;
    }

    @NotNull
    public static PsiAnnotation[] getAnnotationFrom(PsiModifierListOwner owner, Pair<String, ? extends Set<String>> annotationName, boolean allowIndirect, boolean inHierarchy) {
        if (!PsiUtilEx.isLanguageAnnotationTarget(owner)) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                AnnotationUtilEx.$$$reportNull$$$0(0);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = AnnotationUtilEx.getAnnotationsFromImpl(owner, annotationName, allowIndirect, inHierarchy);
        if (psiAnnotationArray == null) {
            AnnotationUtilEx.$$$reportNull$$$0(1);
        }
        return psiAnnotationArray;
    }

    public static PsiAnnotation[] getAnnotationsFromImpl(PsiModifierListOwner owner, Pair<String, ? extends Set<String>> annotationName, boolean allowIndirect, boolean inHierarchy) {
        PsiAnnotation directAnnotation;
        PsiAnnotation psiAnnotation = directAnnotation = inHierarchy ? AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)owner, (Set)((Set)annotationName.second)) : AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (Set)((Set)annotationName.second));
        if (directAnnotation != null) {
            return new PsiAnnotation[]{directAnnotation};
        }
        if (allowIndirect) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = AnnotationUtilEx.getAnnotations(owner, inHierarchy)) {
                PsiAnnotation psiAnnotation2;
                PsiElement resolved;
                PsiJavaCodeReferenceElement nameReference = annotation.getNameReferenceElement();
                if (nameReference == null || !((resolved = nameReference.resolve()) instanceof PsiClass) || (psiAnnotation2 = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)resolved), (Set)((Set)annotationName.second))) == null) continue;
                return new PsiAnnotation[]{psiAnnotation2, annotation};
            }
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    public static PsiAnnotation[] getAnnotationFrom(@NotNull PsiModifierListOwner owner, @NotNull Pair<String, ? extends Set<String>> annotationName, boolean allowIndirect) {
        if (owner == null) {
            AnnotationUtilEx.$$$reportNull$$$0(2);
        }
        if (annotationName == null) {
            AnnotationUtilEx.$$$reportNull$$$0(3);
        }
        return AnnotationUtilEx.getAnnotationFrom(owner, annotationName, allowIndirect, true);
    }

    @Nullable
    public static String calcAnnotationValue(PsiAnnotation[] annotation, @NonNls String attr) {
        for (PsiAnnotation psiAnnotation : annotation) {
            String value = AnnotationUtilEx.calcAnnotationValue(psiAnnotation, attr);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public static String calcAnnotationValue(@NotNull PsiAnnotation annotation, @NonNls String attr) {
        PsiAnnotationMemberValue value;
        Object o;
        if (annotation == null) {
            AnnotationUtilEx.$$$reportNull$$$0(4);
        }
        if ((o = CONSTANT_EVALUATION_HELPER.computeConstantExpression((PsiElement)(value = annotation.findAttributeValue(attr)))) instanceof String) {
            return (String)o;
        }
        return null;
    }

    private static PsiAnnotation[] getAnnotations(@NotNull PsiModifierListOwner listOwner, boolean inHierarchy) {
        if (listOwner == null) {
            AnnotationUtilEx.$$$reportNull$$$0(5);
        }
        PsiModifierList modifierList = listOwner.getModifierList();
        if (!inHierarchy) {
            return modifierList == null ? PsiAnnotation.EMPTY_ARRAY : modifierList.getAnnotations();
        }
        return (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)listOwner, () -> {
            if (listOwner == null) {
                AnnotationUtilEx.$$$reportNull$$$0(6);
            }
            return CachedValueProvider.Result.create((Object)AnnotationUtilEx.getHierarchyAnnotations(listOwner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static PsiAnnotation[] getHierarchyAnnotations(PsiModifierListOwner listOwner) {
        HashSet<PsiAnnotation> all = new HashSet<PsiAnnotation>(){

            @Override
            public boolean add(PsiAnnotation o) {
                return !this.contains(o) && super.add(o);
            }
        };
        PsiModifierList modifierList = listOwner.getModifierList();
        if (modifierList != null) {
            ContainerUtil.addAll((Collection)all, (Object[])modifierList.getAnnotations());
        }
        for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners((PsiModifierListOwner)listOwner)) {
            modifierList = superOwner.getModifierList();
            if (modifierList == null) continue;
            ContainerUtil.addAll((Collection)all, (Object[])modifierList.getAnnotations());
        }
        return all.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : all.toArray(PsiAnnotation.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/util/AnnotationUtilEx";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationFrom";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/util/AnnotationUtilEx";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcAnnotationValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAnnotations$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AnnotatedElementVisitor {
        public boolean visitMethodParameter(PsiExpression var1, PsiCall var2);

        public boolean visitMethodReturnStatement(PsiElement var1, PsiMethod var2);

        public boolean visitVariable(PsiVariable var1);

        public boolean visitAnnotationParameter(PsiNameValuePair var1, PsiAnnotation var2);

        public boolean visitReference(PsiReferenceExpression var1);
    }

    public static enum LookupType {
        PREFER_CONTEXT,
        PREFER_DECLARATION,
        CONTEXT_ONLY,
        DECLARATION_ONLY;

    }
}

