/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestInClassConfigurationProducer;
import com.intellij.execution.junit.TestUniqueId;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class UniqueIdConfigurationProducer
extends JUnitConfigurationProducer {
    protected UniqueIdConfigurationProducer() {
        super(JUnitConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        String[] nodeIds = UniqueIdConfigurationProducer.getNodeIds(context);
        if (nodeIds == null || nodeIds.length == 0) {
            return false;
        }
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.setUniqueIds(nodeIds);
        data.TEST_OBJECT = "uniqueId";
        AbstractTestProxy selectedProxy = (AbstractTestProxy)context.getDataContext().getData(AbstractTestProxy.DATA_KEY);
        if (selectedProxy != null) {
            configuration.setName(selectedProxy.getName());
        } else {
            configuration.setGeneratedName();
        }
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        return true;
    }

    public static String[] getNodeIds(ConfigurationContext context) {
        DataContext dataContext = context.getDataContext();
        AbstractTestProxy[] testProxies = (AbstractTestProxy[])dataContext.getData(AbstractTestProxy.DATA_KEYS);
        if (testProxies == null) {
            return null;
        }
        RunConfiguration runConfiguration = (RunConfiguration)dataContext.getData(RunConfiguration.DATA_KEY);
        if (!(runConfiguration instanceof JUnitConfiguration)) {
            return null;
        }
        Module module = ((JavaRunConfigurationModule)((JUnitConfiguration)runConfiguration).getConfigurationModule()).getModule();
        GlobalSearchScope searchScope = module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.projectScope((Project)context.getProject());
        return (String[])Arrays.stream(testProxies).map(testProxy -> TestUniqueId.getEffectiveNodeId(testProxy, context.getProject(), searchScope)).filter(Objects::nonNull).toArray(String[]::new);
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return "uniqueId".equals(type);
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (other == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(1);
        }
        return self.isProducedBy(UniqueIdConfigurationProducer.class) && (other.isProducedBy(TestInClassConfigurationProducer.class) || other.isProducedBy(PatternConfigurationProducer.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "self";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "other";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/junit/UniqueIdConfigurationProducer";
        objectArray[2] = "shouldReplace";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

