/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.TestClassCollector;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.ClassUtil;
import com.intellij.rt.execution.junit.JUnitStarter;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TestDirectory
extends TestPackage {
    TestDirectory(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    @Nullable
    public SourceScope getSourceScope() {
        String dirName = this.getConfiguration().getPersistentData().getDirName();
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)dirName));
        final Project project = this.getConfiguration().getProject();
        final GlobalSearchScope globalSearchScope = file == null ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)file, (boolean)true);
        return new SourceScope(){

            public GlobalSearchScope getGlobalSearchScope() {
                return globalSearchScope;
            }

            public Project getProject() {
                return project;
            }

            public GlobalSearchScope getLibrariesScope() {
                Module module = ((JavaRunConfigurationModule)TestDirectory.this.getConfiguration().getConfigurationModule()).getModule();
                return module != null ? GlobalSearchScope.moduleWithLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)project);
            }

            public Module[] getModulesToCompile() {
                Collection<Module> validModules = TestDirectory.this.getConfiguration().getValidModules();
                return validModules.toArray(Module.EMPTY_ARRAY);
            }
        };
    }

    @Override
    @Nullable
    protected VirtualFile[] getRootPaths() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.getConfiguration().getPersistentData().getDirName()));
        if (file == null) {
            return null;
        }
        Module dirModule = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.getConfiguration().getProject());
        if (dirModule == null) {
            return null;
        }
        return TestClassCollector.getRootPath((Module)dirModule, (boolean)true);
    }

    @Override
    protected boolean configureByModule(Module module) {
        return module != null;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.getConfiguration());
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)this.getConfiguration().getProject(), (Module)((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule());
        String dirName = this.getConfiguration().getPersistentData().getDirName();
        if (dirName == null || dirName.isEmpty()) {
            throw new RuntimeConfigurationError("Directory is not specified");
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)dirName));
        if (file == null) {
            throw new RuntimeConfigurationError("Directory '" + dirName + "' is not found");
        }
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        if (module == null) {
            throw new RuntimeConfigurationError("Module to choose classpath from is not specified");
        }
    }

    @Override
    protected GlobalSearchScope filterScope(JUnitConfiguration.Data data) throws CantRunException {
        return GlobalSearchScope.allScope((Project)this.getConfiguration().getProject());
    }

    @Override
    public SearchForTestsTask createSearchingForTestsTask() {
        if ("-junit5".equals(this.getRunner())) {
            return new SearchForTestsTask(this.getConfiguration().getProject(), this.myServerSocket){
                private final THashSet<PsiClass> classes;
                {
                    this.classes = new THashSet();
                }

                protected void search() throws ExecutionException {
                    Module module;
                    PsiDirectory directory = TestDirectory.this.getDirectory(TestDirectory.this.getConfiguration().getPersistentData());
                    PsiPackage aPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)directory);
                    if (aPackage != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)this.getProject())) != null) {
                        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
                        PsiDirectory[] directories = aPackage.getDirectories(module.getModuleScope(true));
                        boolean foundTestSources = false;
                        for (PsiDirectory dir : directories) {
                            if (!fileIndex.isInTestSourceContent(dir.getVirtualFile())) continue;
                            if (foundTestSources) {
                                TestDirectory.collectClassesRecursively(directory, (Condition<? super PsiClass>)Condition.TRUE, this.classes);
                                break;
                            }
                            foundTestSources = true;
                        }
                    }
                }

                protected void onFound() throws ExecutionException {
                    String packageName = TestDirectory.super.getPackageName(TestDirectory.this.getConfiguration().getPersistentData());
                    try {
                        VirtualFile[] rootPaths = TestDirectory.this.getRootPaths();
                        TestObject.LOG.assertTrue(rootPaths != null);
                        JUnitStarter.printClassesList(Arrays.stream(rootPaths).map(root -> "+" + root.getPath()).collect(Collectors.toList()), (String)packageName, (String)"", (String)(this.classes.isEmpty() ? (packageName.isEmpty() ? ".*" : packageName + "\\..*") : StringUtil.join(this.classes, aClass -> ClassUtil.getJVMClassName((PsiClass)aClass), (String)"||")), (File)TestDirectory.this.myTempFile);
                    }
                    catch (IOException e) {
                        TestObject.LOG.error((Throwable)e);
                    }
                }
            };
        }
        return super.createSearchingForTestsTask();
    }

    @Override
    @NotNull
    protected String getPackageName(JUnitConfiguration.Data data) throws CantRunException {
        if ("" == null) {
            TestDirectory.$$$reportNull$$$0(0);
        }
        return "";
    }

    @Override
    protected void collectClassesRecursively(TestClassFilter classFilter, Condition<? super PsiClass> acceptClassCondition, Set<? super PsiClass> classes) throws CantRunException {
        TestDirectory.collectClassesRecursively(this.getDirectory(this.getConfiguration().getPersistentData()), acceptClassCondition, classes);
    }

    private static void collectClassesRecursively(PsiDirectory directory, Condition<? super PsiClass> acceptAsTest, Set<? super PsiClass> classes) {
        PsiFile[] files;
        PsiDirectory[] subDirectories;
        for (PsiDirectory subDirectory : subDirectories = (PsiDirectory[])ReadAction.compute(() -> directory.getSubdirectories())) {
            TestDirectory.collectClassesRecursively(subDirectory, acceptAsTest, classes);
        }
        for (PsiFile file : files = (PsiFile[])ReadAction.compute(() -> directory.getFiles())) {
            if (!(file instanceof PsiClassOwner)) continue;
            for (PsiClass aClass : (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)file).getClasses())) {
                TestDirectory.collectInnerClasses(aClass, acceptAsTest, classes);
            }
        }
    }

    @Override
    protected PsiPackage getPackage(JUnitConfiguration.Data data) throws CantRunException {
        PsiDirectory directory = this.getDirectory(data);
        return (PsiPackage)ReadAction.compute(() -> JavaDirectoryService.getInstance().getPackageInSources(directory));
    }

    private PsiDirectory getDirectory(JUnitConfiguration.Data data) throws CantRunException {
        String dirName = data.getDirName();
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)dirName));
        if (file == null) {
            throw new CantRunException("Directory '" + dirName + "' is not found");
        }
        PsiDirectory directory = (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getConfiguration().getProject()).findDirectory(file));
        if (directory == null) {
            throw new CantRunException("Directory '" + dirName + "' is not found");
        }
        return directory;
    }

    @Override
    public String suggestActionName() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        String dirName = data.getDirName();
        return dirName.isEmpty() ? ExecutionBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]) : ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{StringUtil.getShortName((String)FileUtil.toSystemIndependentName((String)dirName), (char)'/')});
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return "directory".equals(configuration.getPersistentData().TEST_OBJECT) && testDir != null && Comparing.strEqual((String)FileUtil.toSystemIndependentName((String)configuration.getPersistentData().getDirName()), (String)testDir.getVirtualFile().getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestDirectory", "getPackageName"));
    }
}

