/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.AbstractAllInDirectoryConfigurationProducer;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;

public abstract class AbstractAllInPackageConfigurationProducer
extends JUnitConfigurationProducer {
    protected AbstractAllInPackageConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return "package".equals(type);
    }

    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiPackage psiPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)context.getPsiLocation());
        if (psiPackage == null) {
            return false;
        }
        sourceElement.set((Object)psiPackage);
        if (!LocationUtil.isJarAttached((Location)context.getLocation(), (PsiPackage)psiPackage, (String[])new String[]{"junit.framework.TestCase", "org.junit.jupiter.api.Test", "org.junit.platform.engine.TestEngine"})) {
            return false;
        }
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.PACKAGE_NAME = psiPackage.getQualifiedName();
        data.TEST_OBJECT = "package";
        data.setScope(this.setupPackageConfiguration(context, (ModuleBasedConfiguration)configuration, data.getScope()));
        configuration.setGeneratedName();
        return true;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return !other.isProducedBy(AbstractAllInDirectoryConfigurationProducer.class) && !other.isProducedBy(PatternConfigurationProducer.class);
    }
}

