/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.process.internal.health.memory.AvailableMemory;

public class MeminfoAvailableMemory
implements AvailableMemory {
    private static final Pattern MEMINFO_LINE_PATTERN = Pattern.compile("^\\D+(\\d+) kB$");
    private static final String MEMINFO_FILE_PATH = "/proc/meminfo";
    private final Matcher meminfoMatcher = MEMINFO_LINE_PATTERN.matcher("");

    @Override
    public long get() throws UnsupportedOperationException {
        List meminfoOutputLines;
        try {
            meminfoOutputLines = Files.readLines((File)new File(MEMINFO_FILE_PATH), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Unable to read free memory from /proc/meminfo", e);
        }
        long freeMemoryFromProcMeminfo = this.parseFreeMemoryFromMeminfo(meminfoOutputLines);
        if (freeMemoryFromProcMeminfo == -1L) {
            throw new UnsupportedOperationException("Unable to get free memory from /proc/meminfo");
        }
        return freeMemoryFromProcMeminfo;
    }

    @VisibleForTesting
    long parseFreeMemoryFromMeminfo(List<String> meminfoLines) {
        Meminfo meminfo = new Meminfo();
        for (String line : meminfoLines) {
            if (line.startsWith("MemAvailable")) {
                return this.parseMeminfoBytes(line);
            }
            if (line.startsWith("MemFree")) {
                meminfo.setMemFree(this.parseMeminfoBytes(line));
                continue;
            }
            if (line.startsWith("Buffers")) {
                meminfo.setBuffers(this.parseMeminfoBytes(line));
                continue;
            }
            if (line.startsWith("Cached")) {
                meminfo.setCached(this.parseMeminfoBytes(line));
                continue;
            }
            if (line.startsWith("SReclaimable")) {
                meminfo.setReclaimable(this.parseMeminfoBytes(line));
                continue;
            }
            if (!line.startsWith("Mapped")) continue;
            meminfo.setMapped(this.parseMeminfoBytes(line));
        }
        return meminfo.getAvailableBytes();
    }

    private long parseMeminfoBytes(String line) {
        Matcher matcher = this.meminfoMatcher.reset(line);
        if (matcher.matches()) {
            return Long.parseLong(matcher.group(1)) * 1024L;
        }
        throw new UnsupportedOperationException("Unable to parse /proc/meminfo output to get available memory");
    }

    private class Meminfo {
        private long memFree = -1L;
        private long buffers = -1L;
        private long cached = -1L;
        private long reclaimable = -1L;
        private long mapped = -1L;

        private Meminfo() {
        }

        void setMemFree(long memFree) {
            this.memFree = memFree;
        }

        long getAvailableBytes() {
            if (this.memFree != -1L && this.buffers != -1L && this.cached != -1L && this.reclaimable != -1L && this.mapped != -1L) {
                return this.memFree + this.buffers + this.cached + this.reclaimable - this.mapped;
            }
            return -1L;
        }

        public void setBuffers(long buffers) {
            this.buffers = buffers;
        }

        public void setCached(long cached) {
            this.cached = cached;
        }

        void setReclaimable(long reclaimable) {
            this.reclaimable = reclaimable;
        }

        public void setMapped(long mapped) {
            this.mapped = mapped;
        }
    }
}

