/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.Link;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.internal.SourceFoldersCreator;

public class LinkedResourcesCreator {
    public Set<Link> links(final Project project) {
        SourceSetContainer sourceSets = project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets();
        EclipseClasspath classpath = project.getExtensions().getByType(EclipseModel.class).getClasspath();
        File defaultOutputDir = classpath == null ? project.file("bin/default") : classpath.getDefaultOutputDir();
        List<SourceFolder> sourceFolders = new SourceFoldersCreator().getBasicExternalSourceFolders(sourceSets, new Function<File, String>(){

            public String apply(File dir) {
                return project.relativePath(dir);
            }
        }, defaultOutputDir);
        LinkedHashSet links = Sets.newLinkedHashSetWithExpectedSize((int)sourceFolders.size());
        for (SourceFolder sourceFolder : sourceFolders) {
            links.add(new Link(sourceFolder.getName(), "2", sourceFolder.getAbsolutePath(), null));
        }
        return links;
    }
}

