/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.gc;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.launcher.daemon.server.health.gc.DefaultSlidingWindow;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionCheck;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionEvent;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;
import org.gradle.launcher.daemon.server.health.gc.SlidingWindow;
import org.gradle.util.CollectionUtils;

public class GarbageCollectionMonitor {
    public static final int POLL_INTERVAL_SECONDS = 1;
    private static final int POLL_DELAY_SECONDS = 1;
    private static final int EVENT_WINDOW = 20;
    private static final Logger LOGGER = Logging.getLogger(GarbageCollectionMonitor.class);
    private final Map<String, SlidingWindow<GarbageCollectionEvent>> events;
    private final GarbageCollectorMonitoringStrategy gcStrategy;
    private final ScheduledExecutorService pollingExecutor;

    public GarbageCollectionMonitor(ScheduledExecutorService pollingExecutor) {
        this(GarbageCollectionMonitor.determineGcStrategy(), pollingExecutor);
    }

    public GarbageCollectionMonitor(GarbageCollectorMonitoringStrategy gcStrategy, ScheduledExecutorService pollingExecutor) {
        this.pollingExecutor = pollingExecutor;
        this.gcStrategy = gcStrategy;
        if (gcStrategy != GarbageCollectorMonitoringStrategy.UNKNOWN) {
            this.events = ImmutableMap.of((Object)gcStrategy.getTenuredPoolName(), new DefaultSlidingWindow(20), (Object)gcStrategy.getPermGenPoolName(), new DefaultSlidingWindow(20));
            this.pollForValues(gcStrategy.getGarbageCollectorName(), (List<String>)ImmutableList.copyOf(this.events.keySet()));
        } else {
            this.events = ImmutableMap.builder().build();
        }
    }

    private static GarbageCollectorMonitoringStrategy determineGcStrategy() {
        JVMStrategy jvmStrategy = JVMStrategy.current();
        final List<String> garbageCollectors = CollectionUtils.collect(ManagementFactory.getGarbageCollectorMXBeans(), new Transformer<String, GarbageCollectorMXBean>(){

            @Override
            public String transform(GarbageCollectorMXBean garbageCollectorMXBean) {
                return garbageCollectorMXBean.getName();
            }
        });
        GarbageCollectorMonitoringStrategy gcStrategy = CollectionUtils.findFirst(jvmStrategy.getGcStrategies(), new Spec<GarbageCollectorMonitoringStrategy>(){

            @Override
            public boolean isSatisfiedBy(GarbageCollectorMonitoringStrategy strategy) {
                return garbageCollectors.contains(strategy.getGarbageCollectorName());
            }
        });
        if (gcStrategy == null) {
            LOGGER.info("Unable to determine a garbage collection monitoring strategy for " + jvmStrategy.toString());
            return GarbageCollectorMonitoringStrategy.UNKNOWN;
        }
        return gcStrategy;
    }

    private void pollForValues(String garbageCollectorName, List<String> memoryPoolNames) {
        this.pollingExecutor.scheduleAtFixedRate(new GarbageCollectionCheck(this.events, memoryPoolNames, garbageCollectorName), 1L, 1L, TimeUnit.SECONDS);
    }

    public GarbageCollectionStats getTenuredStats() {
        return this.getGarbageCollectionStatsWithEmptyDefault(this.gcStrategy.getTenuredPoolName());
    }

    public GarbageCollectionStats getPermGenStats() {
        return this.getGarbageCollectionStatsWithEmptyDefault(this.gcStrategy.getPermGenPoolName());
    }

    private GarbageCollectionStats getGarbageCollectionStatsWithEmptyDefault(String memoryPoolName) {
        SlidingWindow<Object> slidingWindow = memoryPoolName == null || this.events.get(memoryPoolName) == null ? new DefaultSlidingWindow(20) : this.events.get(memoryPoolName);
        return new GarbageCollectionStats(slidingWindow.snapshot());
    }

    public GarbageCollectorMonitoringStrategy getGcStrategy() {
        return this.gcStrategy;
    }

    public static enum JVMStrategy {
        IBM(GarbageCollectorMonitoringStrategy.IBM_ALL),
        ORACLE_HOTSPOT(GarbageCollectorMonitoringStrategy.ORACLE_PARALLEL_CMS, GarbageCollectorMonitoringStrategy.ORACLE_SERIAL, GarbageCollectorMonitoringStrategy.ORACLE_6_CMS, GarbageCollectorMonitoringStrategy.ORACLE_G1),
        UNSUPPORTED(new GarbageCollectorMonitoringStrategy[0]);

        final GarbageCollectorMonitoringStrategy[] gcStrategies;

        private JVMStrategy(GarbageCollectorMonitoringStrategy ... gcStrategies) {
            this.gcStrategies = gcStrategies;
        }

        static JVMStrategy current() {
            String vmname = System.getProperty("java.vm.name");
            if (vmname.equals("IBM J9 VM")) {
                return IBM;
            }
            if (vmname.startsWith("Java HotSpot(TM)")) {
                return ORACLE_HOTSPOT;
            }
            return UNSUPPORTED;
        }

        public GarbageCollectorMonitoringStrategy[] getGcStrategies() {
            return this.gcStrategies;
        }

        public String toString() {
            return "JVMStrategy{" + System.getProperty("java.vendor") + " version " + System.getProperty("java.version") + "}";
        }
    }
}

