/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import org.gradle.internal.remote.internal.MessageIOException;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.launcher.daemon.protocol.OutputMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedDispatchConnection<T>
implements RemoteConnection<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedDispatchConnection.class);
    private final Object lock = new Object();
    private final RemoteConnection<T> delegate;
    private boolean dispatching;

    public SynchronizedDispatchConnection(RemoteConnection<T> delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(T message) {
        if (!(message instanceof OutputMessage)) {
            LOGGER.debug("thread {}: dispatching {}", (Object)Thread.currentThread().getId(), message.getClass());
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dispatching) {
                throw new IllegalStateException("This thread is already dispatching a message.");
            }
            this.dispatching = true;
            try {
                this.delegate.dispatch(message);
            }
            finally {
                this.dispatching = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws MessageIOException {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.flush();
        }
    }

    @Override
    public T receive() {
        T result = this.delegate.receive();
        LOGGER.debug("thread {}: received {}", (Object)Thread.currentThread().getId(), result == null ? "null" : result.getClass());
        return result;
    }

    @Override
    public void stop() {
        LOGGER.debug("thread {}: stopping connection", (Object)Thread.currentThread().getId());
        this.delegate.stop();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

