/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.cache.PersistentStateCache;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.IncludeFileEdge;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.SourceFileState;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

@NonNullApi
public class IncrementalNativeCompiler<T extends NativeCompileSpec>
implements Compiler<T> {
    private final Logger logger = Logging.getLogger(IncrementalNativeCompiler.class);
    private final Compiler<T> delegateCompiler;
    private final TaskOutputsInternal outputs;
    private final PersistentStateCache<CompilationState> compileStateCache;
    private final IncrementalCompilation incrementalCompilation;

    public IncrementalNativeCompiler(TaskOutputsInternal outputs, Compiler<T> delegateCompiler, PersistentStateCache<CompilationState> compileStateCache, IncrementalCompilation incrementalCompilation) {
        this.outputs = outputs;
        this.delegateCompiler = delegateCompiler;
        this.compileStateCache = compileStateCache;
        this.incrementalCompilation = incrementalCompilation;
    }

    @Override
    public WorkResult execute(T spec) {
        WorkResult workResult = spec.isIncrementalCompile() ? this.doIncrementalCompile(this.incrementalCompilation, spec) : this.doCleanIncrementalCompile(spec);
        this.compileStateCache.set(this.incrementalCompilation.getFinalState());
        return workResult;
    }

    private List<File> getSourceFilesForPch(T spec) {
        if (spec.getPreCompiledHeader() != null) {
            ImmutableList.Builder sourceFiles = ImmutableList.builder();
            for (File sourceFile : spec.getSourceFiles()) {
                boolean usePCH;
                SourceFileState state = this.incrementalCompilation.getFinalState().getState(sourceFile);
                HashCode hash = state.getHash();
                ArrayList headers = Lists.newArrayList();
                for (IncludeFileEdge edge : state.getEdges()) {
                    if (!hash.equals(edge.getIncludedBy())) continue;
                    headers.add(edge.getIncludePath());
                }
                String header = spec.getPreCompiledHeader();
                boolean bl = usePCH = !headers.isEmpty() && header.equals(headers.get(0));
                if (usePCH) {
                    sourceFiles.add((Object)sourceFile);
                    continue;
                }
                boolean containsHeader = headers.contains(header);
                if (!containsHeader) continue;
                this.logger.log(LogLevel.WARN, IncrementalNativeCompiler.getCantUsePCHMessage(spec.getPreCompiledHeader(), sourceFile));
            }
            return sourceFiles.build();
        }
        return Collections.emptyList();
    }

    private static String getCantUsePCHMessage(String pchHeader, File sourceFile) {
        return "The source file ".concat(sourceFile.getName()).concat(" includes the header ").concat(pchHeader).concat(" but it is not the first declared header, so the pre-compiled header will not be used.");
    }

    protected WorkResult doIncrementalCompile(IncrementalCompilation compilation, T spec) {
        spec.setSourceFiles(compilation.getRecompile());
        spec.setRemovedSourceFiles(compilation.getRemoved());
        spec.setSourceFilesForPch(this.getSourceFilesForPch(spec));
        return this.delegateCompiler.execute(spec);
    }

    protected WorkResult doCleanIncrementalCompile(T spec) {
        boolean deleted = this.cleanPreviousOutputs((NativeCompileSpec)spec);
        spec.setSourceFilesForPch(this.getSourceFilesForPch(spec));
        WorkResult compileResult = this.delegateCompiler.execute(spec);
        if (deleted && !compileResult.getDidWork()) {
            return WorkResults.didWork(true);
        }
        return compileResult;
    }

    private boolean cleanPreviousOutputs(NativeCompileSpec spec) {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.outputs);
        cleaner.addDirToClean(spec.getObjectFileDir());
        cleaner.execute();
        return cleaner.getDidWork();
    }
}

