/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.DisplayName;

public abstract class DefaultNativeComponent {
    private final ConfigurableFileCollection source;
    private final FileOperations fileOperations;

    public DefaultNativeComponent(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
        this.source = fileOperations.configurableFiles();
    }

    public abstract DisplayName getDisplayName();

    public String toString() {
        return this.getDisplayName().getDisplayName();
    }

    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void source(Action<? super ConfigurableFileCollection> action) {
        action.execute(this.source);
    }

    protected FileCollection createSourceView(final String defaultLocation, List<String> sourceExtensions) {
        final PatternSet patternSet = new PatternSet();
        for (String sourceExtension : sourceExtensions) {
            patternSet.include("**/*." + sourceExtension);
        }
        return this.fileOperations.immutableFiles(new Callable<Object>(){

            @Override
            public Object call() {
                FileTree tree = DefaultNativeComponent.this.source.getFrom().isEmpty() ? DefaultNativeComponent.this.fileOperations.fileTree(defaultLocation) : DefaultNativeComponent.this.source.getAsFileTree();
                return tree.matching(patternSet);
            }
        });
    }
}

