/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.logging;

import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.logging.events.CategorisedOutputEvent;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.sink.OutputEventListenerManager;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;

public class LoggingBuildOperationProgressBroadcaster
implements Stoppable,
OutputEventListener {
    private final OutputEventListenerManager outputEventListenerManager;
    private final BuildOperationListener buildOperationListener;

    public LoggingBuildOperationProgressBroadcaster(OutputEventListenerManager outputEventListenerManager, BuildOperationListener buildOperationListener) {
        this.outputEventListenerManager = outputEventListenerManager;
        this.buildOperationListener = buildOperationListener;
        outputEventListenerManager.setListener(this);
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof RenderableOutputEvent) {
            RenderableOutputEvent renderableOutputEvent = (RenderableOutputEvent)event;
            if (renderableOutputEvent.getBuildOperationId() == null) {
                return;
            }
            if (renderableOutputEvent instanceof StyledTextOutputEvent || renderableOutputEvent instanceof LogEvent) {
                this.emit(renderableOutputEvent, renderableOutputEvent.getBuildOperationId());
            }
        } else if (event instanceof ProgressStartEvent) {
            ProgressStartEvent progressStartEvent = (ProgressStartEvent)event;
            if (progressStartEvent.getBuildOperationId() == null) {
                return;
            }
            if (progressStartEvent.getLoggingHeader() == null) {
                return;
            }
            this.emit(progressStartEvent, progressStartEvent.getBuildOperationId());
        }
    }

    private void emit(CategorisedOutputEvent event, OperationIdentifier buildOperationId) {
        this.buildOperationListener.progress(buildOperationId, new OperationProgressEvent(event.getTimestamp(), event));
    }

    @Override
    public void stop() {
        this.outputEventListenerManager.removeListener(this);
    }
}

