/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.hash.HashCode;

public class IgnoredPathFingerprint
implements NormalizedFileSnapshot {
    public static final IgnoredPathFingerprint DIRECTORY = new IgnoredPathFingerprint(FileType.Directory, DIR_SIGNATURE);
    private static final IgnoredPathFingerprint MISSING_FILE = new IgnoredPathFingerprint(FileType.Missing, MISSING_FILE_SIGNATURE);
    private final FileType type;
    private final HashCode normalizedContentHash;

    public static IgnoredPathFingerprint create(FileType type, HashCode contentHash) {
        switch (type) {
            case Directory: {
                return DIRECTORY;
            }
            case Missing: {
                return MISSING_FILE;
            }
            case RegularFile: {
                return new IgnoredPathFingerprint(FileType.RegularFile, contentHash);
            }
        }
        throw new IllegalStateException();
    }

    private IgnoredPathFingerprint(FileType type, HashCode normalizedContentHash) {
        this.type = type;
        this.normalizedContentHash = normalizedContentHash;
    }

    @Override
    public String getNormalizedPath() {
        return "";
    }

    @Override
    public HashCode getNormalizedContentHash() {
        return this.normalizedContentHash;
    }

    @Override
    public FileType getType() {
        return this.type;
    }

    @Override
    public int compareTo(NormalizedFileSnapshot o) {
        if (!(o instanceof IgnoredPathFingerprint)) {
            return -1;
        }
        return this.normalizedContentHash.compareTo(o.getNormalizedContentHash());
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putHash(this.normalizedContentHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgnoredPathFingerprint that = (IgnoredPathFingerprint)o;
        return this.normalizedContentHash.equals(that.normalizedContentHash);
    }

    public int hashCode() {
        return this.normalizedContentHash.hashCode();
    }

    public String toString() {
        return String.format("IGNORED / %s", this.getType() == FileType.Directory ? "DIR" : (this.getType() == FileType.Missing ? "MISSING" : this.normalizedContentHash));
    }
}

