/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.external.javadoc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.external.javadoc.JavadocMemberLevel;
import org.gradle.external.javadoc.JavadocOptionFileOption;
import org.gradle.external.javadoc.JavadocOutputLevel;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.OptionLessJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.JavadocOptionFile;
import org.gradle.external.javadoc.internal.JavadocOptionFileOptionInternal;
import org.gradle.external.javadoc.internal.JavadocOptionFileOptionInternalAdapter;
import org.gradle.internal.Cast;
import org.gradle.process.ExecSpec;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;

public abstract class CoreJavadocOptions
implements MinimalJavadocOptions {
    protected final JavadocOptionFile optionFile;
    private final JavadocOptionFileOption<String> overview;
    private final JavadocOptionFileOption<JavadocMemberLevel> memberLevel;
    private final JavadocOptionFileOption<String> doclet;
    private final JavadocOptionFileOption<List<File>> docletpath;
    private final JavadocOptionFileOption<String> source;
    private final JavadocOptionFileOption<List<File>> classpath;
    private final JavadocOptionFileOption<List<File>> bootClasspath;
    private final JavadocOptionFileOption<List<File>> extDirs;
    private final JavadocOptionFileOption<JavadocOutputLevel> outputLevel;
    private final JavadocOptionFileOption<Boolean> breakIterator;
    private final JavadocOptionFileOption<String> locale;
    private final JavadocOptionFileOption<String> encoding;
    private final OptionLessJavadocOptionFileOption<List<String>> sourceNames;
    private List<String> jFlags = new ArrayList<String>();
    private List<File> optionFiles = new ArrayList<File>();

    public CoreJavadocOptions() {
        this(new JavadocOptionFile());
    }

    protected CoreJavadocOptions(JavadocOptionFile optionFile) {
        this.optionFile = optionFile;
        this.overview = this.addStringOption("overview");
        this.memberLevel = this.addEnumOption("memberLevel");
        this.doclet = this.addStringOption("doclet");
        this.docletpath = this.addPathOption("docletpath");
        this.source = this.addStringOption("source");
        this.classpath = this.addPathOption("classpath");
        this.bootClasspath = this.addPathOption("bootclasspath");
        this.extDirs = this.addPathOption("extdirs");
        this.outputLevel = this.addEnumOption("outputLevel", JavadocOutputLevel.QUIET);
        this.breakIterator = this.addBooleanOption("breakiterator");
        this.locale = this.addStringOption("locale");
        this.encoding = this.addStringOption("encoding");
        this.sourceNames = optionFile.getSourceNames();
    }

    protected CoreJavadocOptions(CoreJavadocOptions original, JavadocOptionFile optionFile) {
        this.optionFile = optionFile;
        this.overview = optionFile.getOption("overview");
        this.memberLevel = optionFile.getOption("memberLevel");
        this.doclet = optionFile.getOption("doclet");
        this.docletpath = optionFile.getOption("docletpath");
        this.source = optionFile.getOption("source");
        this.classpath = optionFile.getOption("classpath");
        this.bootClasspath = optionFile.getOption("bootclasspath");
        this.extDirs = optionFile.getOption("extdirs");
        this.outputLevel = optionFile.getOption("outputLevel");
        this.breakIterator = optionFile.getOption("breakiterator");
        this.locale = optionFile.getOption("locale");
        this.encoding = optionFile.getOption("encoding");
        this.sourceNames = optionFile.getSourceNames();
        this.jFlags = original.jFlags;
        this.optionFiles = original.optionFiles;
    }

    @Override
    public String getOverview() {
        return (String)this.overview.getValue();
    }

    @Override
    public void setOverview(String overview) {
        this.overview.setValue(overview);
    }

    @Override
    public MinimalJavadocOptions overview(String overview) {
        this.setOverview(overview);
        return this;
    }

    @Override
    public JavadocMemberLevel getMemberLevel() {
        return (JavadocMemberLevel)((Object)this.memberLevel.getValue());
    }

    @Override
    public void setMemberLevel(JavadocMemberLevel memberLevel) {
        this.memberLevel.setValue(memberLevel);
    }

    @Override
    public MinimalJavadocOptions showFromPublic() {
        this.setMemberLevel(JavadocMemberLevel.PUBLIC);
        return this;
    }

    @Override
    public MinimalJavadocOptions showFromProtected() {
        this.setMemberLevel(JavadocMemberLevel.PROTECTED);
        return this;
    }

    @Override
    public MinimalJavadocOptions showFromPackage() {
        this.setMemberLevel(JavadocMemberLevel.PACKAGE);
        return this;
    }

    @Override
    public MinimalJavadocOptions showFromPrivate() {
        this.setMemberLevel(JavadocMemberLevel.PRIVATE);
        return this;
    }

    @Override
    public MinimalJavadocOptions showAll() {
        return this.showFromPrivate();
    }

    @Override
    public String getDoclet() {
        return (String)this.doclet.getValue();
    }

    @Override
    public void setDoclet(String doclet) {
        this.doclet.setValue(doclet);
    }

    @Override
    public MinimalJavadocOptions doclet(String doclet) {
        this.setDoclet(doclet);
        return this;
    }

    @Override
    public List<File> getDocletpath() {
        return (List)this.docletpath.getValue();
    }

    @Override
    public void setDocletpath(List<File> docletpath) {
        this.docletpath.setValue(docletpath);
    }

    @Override
    public MinimalJavadocOptions docletpath(File ... docletpath) {
        ((List)this.docletpath.getValue()).addAll(Arrays.asList(docletpath));
        return this;
    }

    @Override
    public String getSource() {
        return (String)this.source.getValue();
    }

    @Override
    public void setSource(String source) {
        this.source.setValue(source);
    }

    @Override
    public MinimalJavadocOptions source(String source) {
        this.setSource(source);
        return this;
    }

    @Override
    public List<File> getClasspath() {
        return (List)this.classpath.getValue();
    }

    @Override
    public void setClasspath(List<File> classpath) {
        this.classpath.setValue(classpath);
    }

    @Override
    public MinimalJavadocOptions classpath(List<File> classpath) {
        ((List)this.classpath.getValue()).addAll(classpath);
        return this;
    }

    @Override
    public MinimalJavadocOptions classpath(File ... classpath) {
        ((List)this.classpath.getValue()).addAll(Arrays.asList(classpath));
        return this;
    }

    @Override
    public List<File> getBootClasspath() {
        return (List)this.bootClasspath.getValue();
    }

    @Override
    public void setBootClasspath(List<File> bootClasspath) {
        this.bootClasspath.setValue(bootClasspath);
    }

    @Override
    public MinimalJavadocOptions bootClasspath(File ... bootClasspath) {
        ((List)this.bootClasspath.getValue()).addAll(Arrays.asList(bootClasspath));
        return this;
    }

    @Override
    public List<File> getExtDirs() {
        return (List)this.extDirs.getValue();
    }

    @Override
    public void setExtDirs(List<File> extDirs) {
        this.extDirs.setValue(extDirs);
    }

    @Override
    public MinimalJavadocOptions extDirs(File ... extDirs) {
        ((List)this.extDirs.getValue()).addAll(Arrays.asList(extDirs));
        return this;
    }

    @Override
    public JavadocOutputLevel getOutputLevel() {
        return (JavadocOutputLevel)((Object)this.outputLevel.getValue());
    }

    @Override
    public void setOutputLevel(JavadocOutputLevel outputLevel) {
        this.outputLevel.setValue(outputLevel);
    }

    @Override
    public MinimalJavadocOptions verbose() {
        this.setOutputLevel(JavadocOutputLevel.VERBOSE);
        return this;
    }

    @Override
    public boolean isVerbose() {
        return this.outputLevel.getValue() == JavadocOutputLevel.VERBOSE;
    }

    @Override
    public MinimalJavadocOptions quiet() {
        this.setOutputLevel(JavadocOutputLevel.QUIET);
        return this;
    }

    @Override
    public boolean isBreakIterator() {
        return (Boolean)this.breakIterator.getValue();
    }

    @Override
    public void setBreakIterator(boolean breakIterator) {
        this.breakIterator.setValue(breakIterator);
    }

    @Override
    public MinimalJavadocOptions breakIterator(boolean breakIterator) {
        this.setBreakIterator(breakIterator);
        return this;
    }

    @Override
    public MinimalJavadocOptions breakIterator() {
        this.setBreakIterator(true);
        return this;
    }

    @Override
    public String getLocale() {
        return (String)this.locale.getValue();
    }

    @Override
    public void setLocale(String locale) {
        this.locale.setValue(locale);
    }

    @Override
    public MinimalJavadocOptions locale(String locale) {
        this.setLocale(locale);
        return this;
    }

    @Override
    public String getEncoding() {
        return (String)this.encoding.getValue();
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding.setValue(encoding);
    }

    @Override
    public MinimalJavadocOptions encoding(String encoding) {
        this.setEncoding(encoding);
        return this;
    }

    @Override
    public List<String> getSourceNames() {
        return this.sourceNames.getValue();
    }

    @Override
    public void setSourceNames(List<String> sourceNames) {
        this.sourceNames.setValue(sourceNames);
    }

    @Override
    public MinimalJavadocOptions sourceNames(String ... sourceNames) {
        this.sourceNames.getValue().addAll(Arrays.asList(sourceNames));
        return this;
    }

    @Override
    public List<String> getJFlags() {
        return this.jFlags;
    }

    @Override
    public void setJFlags(List<String> jFlags) {
        this.jFlags = jFlags;
    }

    @Override
    public MinimalJavadocOptions jFlags(String ... jFlags) {
        this.jFlags.addAll(Arrays.asList(jFlags));
        return this;
    }

    @Override
    public void contributeCommandLineOptions(ExecSpec execHandleBuilder) {
        execHandleBuilder.args(GUtil.prefix("-J", this.jFlags)).args(GUtil.prefix("@", GFileUtils.toPaths(this.optionFiles)));
    }

    @Override
    public List<File> getOptionFiles() {
        return this.optionFiles;
    }

    @Override
    public void setOptionFiles(List<File> optionFiles) {
        this.optionFiles = optionFiles;
    }

    @Override
    public MinimalJavadocOptions optionFiles(File ... argumentFiles) {
        this.optionFiles.addAll(Arrays.asList(argumentFiles));
        return this;
    }

    @Override
    public final void write(File outputFile) throws IOException {
        this.optionFile.write(outputFile);
    }

    public <T> JavadocOptionFileOption<T> addOption(JavadocOptionFileOption<T> option) {
        if (option instanceof JavadocOptionFileOptionInternal) {
            return this.optionFile.addOption((JavadocOptionFileOptionInternal)Cast.uncheckedCast(option));
        }
        return this.optionFile.addOption(new JavadocOptionFileOptionInternalAdapter<T>(option));
    }

    public JavadocOptionFileOption<String> addStringOption(String option) {
        return this.optionFile.addStringOption(option);
    }

    public JavadocOptionFileOption<String> addStringOption(String option, String value) {
        return this.optionFile.addStringOption(option, value);
    }

    public <T extends Enum<T>> JavadocOptionFileOption<T> addEnumOption(String option) {
        return this.optionFile.addEnumOption(option);
    }

    public <T extends Enum<T>> JavadocOptionFileOption<T> addEnumOption(String option, T value) {
        return this.optionFile.addEnumOption(option, value);
    }

    public JavadocOptionFileOption<List<File>> addPathOption(String option) {
        return this.optionFile.addPathOption(option);
    }

    public JavadocOptionFileOption<List<File>> addPathOption(String option, String joinBy) {
        return this.optionFile.addPathOption(option, joinBy);
    }

    public JavadocOptionFileOption<List<String>> addStringsOption(String option) {
        return this.optionFile.addStringsOption(option);
    }

    public JavadocOptionFileOption<List<String>> addStringsOption(String option, String joinBy) {
        return this.optionFile.addStringsOption(option, joinBy);
    }

    public JavadocOptionFileOption<List<String>> addMultilineStringsOption(String option) {
        return this.optionFile.addMultilineStringsOption(option);
    }

    public JavadocOptionFileOption<List<List<String>>> addMultilineMultiValueOption(String option) {
        return this.optionFile.addMultilineMultiValueOption(option);
    }

    public JavadocOptionFileOption<Boolean> addBooleanOption(String option) {
        return this.optionFile.addBooleanOption(option);
    }

    public JavadocOptionFileOption<Boolean> addBooleanOption(String option, boolean value) {
        return this.optionFile.addBooleanOption(option, value);
    }

    public JavadocOptionFileOption<File> addFileOption(String option) {
        return this.optionFile.addFileOption(option);
    }

    public JavadocOptionFileOption<File> addFileOption(String option, File value) {
        return this.optionFile.addFileOption(option, value);
    }
}

