/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.caching.internal.tasks.BuildCacheKeyInputs;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.Path;

@NonNullApi
public class DefaultTaskOutputCachingBuildCacheKeyBuilder
implements TaskOutputCachingBuildCacheKeyBuilder {
    private final BuildCacheHasher hasher = new DefaultBuildCacheHasher();
    private final Path taskPath;
    private String taskClass;
    private HashCode classLoaderHash;
    private List<HashCode> actionClassLoaderHashes;
    private ImmutableList<String> actionTypes;
    private boolean valid = true;
    private final ImmutableSortedMap.Builder<String, HashCode> inputValueHashes = ImmutableSortedMap.naturalOrder();
    private final ImmutableSortedMap.Builder<String, CurrentFileCollectionFingerprint> inputFiles = ImmutableSortedMap.naturalOrder();
    private final ImmutableSortedSet.Builder<String> inputPropertiesLoadedByUnknownClassLoader = ImmutableSortedSet.naturalOrder();
    private final ImmutableSortedSet.Builder<String> outputPropertyNames = ImmutableSortedSet.naturalOrder();

    public DefaultTaskOutputCachingBuildCacheKeyBuilder(Path taskPath) {
        this.taskPath = taskPath;
    }

    @Override
    public void appendTaskImplementation(ImplementationSnapshot taskImplementation) {
        this.taskClass = taskImplementation.getTypeName();
        this.hasher.putString(this.taskClass);
        if (taskImplementation.hasUnknownClassLoader()) {
            this.valid = false;
        } else {
            HashCode hashCode;
            this.classLoaderHash = hashCode = taskImplementation.getClassLoaderHash();
            this.hasher.putHash(hashCode);
        }
    }

    @Override
    public void appendTaskActionImplementations(Collection<ImplementationSnapshot> taskActionImplementations) {
        ImmutableList.Builder actionTypes = ImmutableList.builder();
        ArrayList actionClassLoaderHashes = Lists.newArrayListWithCapacity((int)taskActionImplementations.size());
        for (ImplementationSnapshot actionImpl : taskActionImplementations) {
            HashCode hashCode;
            String actionType = actionImpl.getTypeName();
            actionTypes.add((Object)actionType);
            this.hasher.putString(actionType);
            if (actionImpl.hasUnknownClassLoader()) {
                hashCode = null;
                this.valid = false;
            } else {
                hashCode = actionImpl.getClassLoaderHash();
                this.hasher.putHash(hashCode);
            }
            actionClassLoaderHashes.add(hashCode);
        }
        this.actionTypes = actionTypes.build();
        this.actionClassLoaderHashes = Collections.unmodifiableList(actionClassLoaderHashes);
    }

    @Override
    public void appendInputValuePropertyHash(String propertyName, HashCode hashCode) {
        this.hasher.putString(propertyName);
        this.hasher.putHash(hashCode);
        this.inputValueHashes.put((Object)propertyName, (Object)hashCode);
    }

    @Override
    public void appendInputFilesProperty(String propertyName, CurrentFileCollectionFingerprint fileCollectionFingerprint) {
        this.hasher.putString(propertyName);
        this.hasher.putHash(fileCollectionFingerprint.getHash());
        this.inputFiles.put((Object)propertyName, (Object)fileCollectionFingerprint);
    }

    @Override
    public void inputPropertyLoadedByUnknownClassLoader(String propertyName) {
        this.valid = false;
        this.inputPropertiesLoadedByUnknownClassLoader.add((Object)propertyName);
    }

    @Override
    public void appendOutputPropertyName(String propertyName) {
        this.outputPropertyNames.add((Object)propertyName);
        this.hasher.putString(propertyName);
    }

    @Override
    public TaskOutputCachingBuildCacheKey build() {
        BuildCacheKeyInputs inputs = new BuildCacheKeyInputs(this.taskClass, this.classLoaderHash, this.actionClassLoaderHashes, this.actionTypes, (ImmutableSortedMap<String, HashCode>)this.inputValueHashes.build(), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)this.inputFiles.build(), (ImmutableSortedSet<String>)this.inputPropertiesLoadedByUnknownClassLoader.build(), (ImmutableSortedSet<String>)this.outputPropertyNames.build());
        HashCode hash = !this.valid ? null : this.hasher.hash();
        return new DefaultTaskOutputCachingBuildCacheKey(this.taskPath, hash, inputs);
    }

    private static class DefaultTaskOutputCachingBuildCacheKey
    implements TaskOutputCachingBuildCacheKey {
        private final Path taskPath;
        private final HashCode hashCode;
        private final BuildCacheKeyInputs inputs;

        private DefaultTaskOutputCachingBuildCacheKey(Path taskPath, @Nullable HashCode hashCode, BuildCacheKeyInputs inputs) {
            this.taskPath = taskPath;
            this.hashCode = hashCode;
            this.inputs = inputs;
        }

        @Override
        public Path getTaskPath() {
            return this.taskPath;
        }

        @Override
        public String getHashCode() {
            return ((HashCode)Preconditions.checkNotNull((Object)this.hashCode, (Object)"Cannot determine hash code for invalid build cache key")).toString();
        }

        @Override
        public BuildCacheKeyInputs getInputs() {
            return this.inputs;
        }

        @Override
        public boolean isValid() {
            return this.hashCode != null;
        }

        @Override
        public String getDisplayName() {
            if (this.hashCode == null) {
                return "INVALID cache key for task '" + this.taskPath + "'";
            }
            return this.hashCode + " for task '" + this.taskPath + "'";
        }

        public String toString() {
            return String.valueOf(this.hashCode);
        }
    }
}

