/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.util.CollectionUtils;

public class ProjectLayoutSetupRegistry {
    private static final Logger LOGGER = Logging.getLogger(ProjectLayoutSetupRegistry.class);
    private final Map<String, ProjectInitDescriptor> registeredProjectDescriptors = new HashMap<String, ProjectInitDescriptor>();

    public void add(String descriptorID, ProjectInitDescriptor descriptor) {
        if (this.registeredProjectDescriptors.containsKey(descriptorID)) {
            throw new GradleException(String.format("ProjectDescriptor with ID '%s' already registered.", descriptorID));
        }
        this.registeredProjectDescriptors.put(descriptorID, descriptor);
        LOGGER.debug("registered setupDescriptor {}", descriptorID);
    }

    public ProjectInitDescriptor get(String type) {
        return this.registeredProjectDescriptors.get(type);
    }

    public List<ProjectInitDescriptor> getAll() {
        return CollectionUtils.toList(this.registeredProjectDescriptors.values());
    }

    public List<String> getSupportedTypes() {
        return CollectionUtils.sort(this.registeredProjectDescriptors.keySet());
    }

    public boolean supports(String type) {
        return this.get(type) != null;
    }
}

