/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.publish.PublicationArtifact;
import org.gradle.api.publish.internal.PublicationArtifactSet;

public class DefaultPublicationArtifactSet<T extends PublicationArtifact>
extends DefaultDomainObjectSet<T>
implements PublicationArtifactSet<T> {
    private final String name;
    private final FileCollection files;

    public DefaultPublicationArtifactSet(Class<T> type, String name, FileCollectionFactory fileCollectionFactory) {
        super(type);
        this.name = name;
        this.files = fileCollectionFactory.create(new AbstractTaskDependency(){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                for (PublicationArtifact artifact : DefaultPublicationArtifactSet.this) {
                    context.add(artifact.getBuildDependencies());
                }
            }
        }, new MinimalFileSet(){

            @Override
            public String getDisplayName() {
                return DefaultPublicationArtifactSet.this.name;
            }

            @Override
            public Set<File> getFiles() {
                LinkedHashSet<File> result = new LinkedHashSet<File>();
                for (PublicationArtifact artifact : DefaultPublicationArtifactSet.this) {
                    result.add(artifact.getFile());
                }
                return result;
            }
        });
    }

    @Override
    public FileCollection getFiles() {
        return this.files;
    }
}

