/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.dispatch.DispatchException;

public class MaxNParallelTestClassProcessor
implements TestClassProcessor {
    private final int maxProcessors;
    private final Factory<TestClassProcessor> factory;
    private final ActorFactory actorFactory;
    private TestResultProcessor resultProcessor;
    private int pos;
    private List<TestClassProcessor> processors = new ArrayList<TestClassProcessor>();
    private List<TestClassProcessor> rawProcessors = new ArrayList<TestClassProcessor>();
    private List<Actor> actors = new ArrayList<Actor>();
    private Actor resultProcessorActor;
    private volatile boolean stoppedNow;

    public MaxNParallelTestClassProcessor(int maxProcessors, Factory<TestClassProcessor> factory, ActorFactory actorFactory) {
        this.maxProcessors = maxProcessors;
        this.factory = factory;
        this.actorFactory = actorFactory;
    }

    @Override
    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessorActor = this.actorFactory.createActor(resultProcessor);
        this.resultProcessor = this.resultProcessorActor.getProxy(TestResultProcessor.class);
    }

    @Override
    public void processTestClass(TestClassRunInfo testClass) {
        TestClassProcessor processor;
        if (this.stoppedNow) {
            return;
        }
        if (this.processors.size() < this.maxProcessors) {
            processor = this.factory.create();
            this.rawProcessors.add(processor);
            Actor actor = this.actorFactory.createActor(processor);
            processor = actor.getProxy(TestClassProcessor.class);
            this.actors.add(actor);
            this.processors.add(processor);
            processor.startProcessing(this.resultProcessor);
        } else {
            processor = this.processors.get(this.pos);
            this.pos = (this.pos + 1) % this.processors.size();
        }
        processor.processTestClass(testClass);
    }

    @Override
    public void stop() {
        try {
            CompositeStoppable.stoppable(this.processors).add(this.actors).add((Object)this.resultProcessorActor).stop();
        }
        catch (DispatchException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
    }

    @Override
    public void stopNow() {
        this.stoppedNow = true;
        for (TestClassProcessor processor : this.rawProcessors) {
            processor.stopNow();
        }
    }
}

