/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.util.List;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.EnumFromCharSequenceNotationParser;
import org.gradle.internal.typeconversion.NotationConverterToNotationParserAdapter;
import org.gradle.internal.typeconversion.NotationParser;

public class OptionValueNotationParserFactory {
    public <T> NotationParser<CharSequence, T> toComposite(Class<T> targetType) throws OptionValidationException {
        assert (targetType != null) : "resultingType cannot be null";
        if (targetType == Void.TYPE) {
            return new UnsupportedNotationParser();
        }
        if (targetType.isAssignableFrom(String.class) || targetType == List.class) {
            return (NotationParser)Cast.uncheckedCast(new NoDescriptionValuesJustReturningParser());
        }
        if (targetType.isEnum()) {
            EnumFromCharSequenceNotationParser<Enum> converter = new EnumFromCharSequenceNotationParser<Enum>(targetType.asSubclass(Enum.class));
            return new NotationConverterToNotationParserAdapter(converter);
        }
        throw new OptionValidationException(String.format("Don't know how to convert strings to type '%s'.", targetType.getName()));
    }

    private static class NoDescriptionValuesJustReturningParser
    implements NotationParser<CharSequence, String> {
        private NoDescriptionValuesJustReturningParser() {
        }

        @Override
        public String parseNotation(CharSequence notation) {
            return notation.toString();
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of String or CharSequence.");
        }
    }

    private static class UnsupportedNotationParser<T>
    implements NotationParser<CharSequence, T> {
        private UnsupportedNotationParser() {
        }

        @Override
        public T parseNotation(CharSequence notation) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
        }
    }
}

