/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.tasks.TaskValidationException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.DeprecationLogger;

public interface TaskValidationContext {
    public static final String DEPRECATION_SUMMARY = "Registering invalid inputs and outputs via TaskInputs and TaskOutputs methods";

    public FileResolver getResolver();

    public void recordValidationMessage(Severity var1, String var2);

    public Severity getHighestSeverity();

    public static enum Severity {
        WARNING{

            @Override
            public boolean report(Task task, List<String> messages, TaskStateInternal state) {
                StringBuilder contextualAdviceBuilder = new StringBuilder(Severity.getMainMessage(task, messages));
                for (String message : messages) {
                    contextualAdviceBuilder.append("\n - ");
                    contextualAdviceBuilder.append(message);
                }
                DeprecationLogger.nagUserWithDeprecatedIndirectUserCodeCause(TaskValidationContext.DEPRECATION_SUMMARY, null, contextualAdviceBuilder.toString());
                return true;
            }
        }
        ,
        ERROR{

            @Override
            public boolean report(Task task, List<String> messages, TaskStateInternal state) {
                ArrayList causes = Lists.newArrayListWithCapacity((int)messages.size());
                for (String message : messages) {
                    causes.add(new InvalidUserDataException(message));
                }
                String errorMessage = Severity.getMainMessage(task, messages);
                state.setOutcome(new TaskValidationException(errorMessage, causes));
                return false;
            }
        };


        private static String getMainMessage(Task task, List<String> messages) {
            if (messages.size() == 1) {
                return String.format("A problem was found with the configuration of %s.", task);
            }
            return String.format("Some problems were found with the configuration of %s.", task);
        }

        public abstract boolean report(Task var1, List<String> var2, TaskStateInternal var3);
    }
}

