/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.notations.ModuleNotationValidation;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

public class ModuleIdentifierNotationConverter
implements NotationConverter<String, ModuleIdentifier> {
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public ModuleIdentifierNotationConverter(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    @Override
    public void convert(String notation, NotationConvertResult<? super ModuleIdentifier> result) throws TypeConversionException {
        assert (notation != null);
        String[] split = notation.split(":");
        if (split.length != 2) {
            throw new UnsupportedNotationException((Object)notation);
        }
        String group = ModuleNotationValidation.validate(split[0].trim(), notation);
        String name = ModuleNotationValidation.validate(split[1].trim(), notation);
        result.converted(this.moduleIdentifierFactory.module(group, name));
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("String describing the module in 'group:name' format").example("'org.gradle:gradle-core'");
    }
}

