/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.provider.DefaultProviderFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GUtil;

public class DefaultSourceDirectorySet
extends CompositeFileTree
implements SourceDirectorySet {
    private final List<Object> source = new ArrayList<Object>();
    private final String name;
    private final String displayName;
    private final FileResolver fileResolver;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final PatternSet patterns;
    private final PatternSet filter;
    private final FileCollection dirs;
    private final Property<File> outputDir;

    public DefaultSourceDirectorySet(String name, String displayName, FileResolver fileResolver, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.name = name;
        this.displayName = displayName;
        this.fileResolver = fileResolver;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patterns = fileResolver.getPatternSetFactory().create();
        this.filter = fileResolver.getPatternSetFactory().create();
        this.dirs = new FileCollectionAdapter(new SourceDirectories());
        DefaultProviderFactory providerFactory = new DefaultProviderFactory();
        this.outputDir = providerFactory.propertyNoNag(File.class);
    }

    public DefaultSourceDirectorySet(String name, FileResolver fileResolver, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this(name, name, fileResolver, directoryFileTreeFactory);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FileCollection getSourceDirectories() {
        return this.dirs;
    }

    @Override
    public Set<File> getSrcDirs() {
        LinkedHashSet<File> dirs = new LinkedHashSet<File>();
        for (DirectoryTree tree : this.getSrcDirTrees()) {
            dirs.add(tree.getDir());
        }
        return dirs;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patterns.getIncludes();
    }

    @Override
    public Set<String> getExcludes() {
        return this.patterns.getExcludes();
    }

    @Override
    public PatternFilterable setIncludes(Iterable<String> includes) {
        this.patterns.setIncludes((Iterable)includes);
        return this;
    }

    @Override
    public PatternFilterable setExcludes(Iterable<String> excludes) {
        this.patterns.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public PatternFilterable include(String ... includes) {
        this.patterns.include(includes);
        return this;
    }

    @Override
    public PatternFilterable include(Iterable<String> includes) {
        this.patterns.include((Iterable)includes);
        return this;
    }

    @Override
    public PatternFilterable include(Spec<FileTreeElement> includeSpec) {
        this.patterns.include((Spec)includeSpec);
        return this;
    }

    @Override
    public PatternFilterable include(Closure includeSpec) {
        this.patterns.include(includeSpec);
        return this;
    }

    @Override
    public PatternFilterable exclude(Iterable<String> excludes) {
        this.patterns.exclude((Iterable)excludes);
        return this;
    }

    @Override
    public PatternFilterable exclude(String ... excludes) {
        this.patterns.exclude(excludes);
        return this;
    }

    @Override
    public PatternFilterable exclude(Spec<FileTreeElement> excludeSpec) {
        this.patterns.exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public PatternFilterable exclude(Closure excludeSpec) {
        this.patterns.exclude(excludeSpec);
        return this;
    }

    @Override
    public PatternFilterable getFilter() {
        return this.filter;
    }

    @Override
    public File getOutputDir() {
        return (File)this.outputDir.get();
    }

    @Override
    public void setOutputDir(Provider<File> provider) {
        this.outputDir.set(provider);
    }

    @Override
    public void setOutputDir(File outputDir) {
        this.outputDir.set(outputDir);
    }

    @Override
    public Set<DirectoryTree> getSrcDirTrees() {
        LinkedHashMap<File, DirectoryTree> trees = new LinkedHashMap<File, DirectoryTree>();
        for (DirectoryTree tree : this.doGetSrcDirTrees()) {
            if (trees.containsKey(tree.getDir())) continue;
            trees.put(tree.getDir(), tree);
        }
        return new LinkedHashSet<DirectoryTree>(trees.values());
    }

    private Set<DirectoryTree> doGetSrcDirTrees() {
        LinkedHashSet<DirectoryTree> result = new LinkedHashSet<DirectoryTree>();
        for (Object path : this.source) {
            if (path instanceof SourceDirectorySet) {
                SourceDirectorySet nested = (SourceDirectorySet)path;
                result.addAll(nested.getSrcDirTrees());
                continue;
            }
            for (File srcDir : this.fileResolver.resolveFiles(path)) {
                if (srcDir.exists() && !srcDir.isDirectory()) {
                    throw new InvalidUserDataException(String.format("Source directory '%s' is not a directory.", srcDir));
                }
                result.add(this.directoryFileTreeFactory.create(srcDir, this.patterns));
            }
        }
        return result;
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        for (Object path : this.source) {
            if (path instanceof SourceDirectorySet) {
                context.add(((SourceDirectorySet)path).getBuildDependencies());
                continue;
            }
            context.add(this.fileResolver.resolveFiles(path));
        }
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        for (DirectoryTree directoryTree : this.doGetSrcDirTrees()) {
            context.add(((DirectoryFileTree)directoryTree).filter(this.filter));
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public SourceDirectorySet srcDir(Object srcDir) {
        this.source.add(srcDir);
        return this;
    }

    @Override
    public SourceDirectorySet srcDirs(Object ... srcDirs) {
        for (Object srcDir : srcDirs) {
            this.source.add(srcDir);
        }
        return this;
    }

    @Override
    public SourceDirectorySet setSrcDirs(Iterable<?> srcPaths) {
        this.source.clear();
        GUtil.addToCollection(this.source, srcPaths);
        return this;
    }

    @Override
    public SourceDirectorySet source(SourceDirectorySet source) {
        this.source.add(source);
        return this;
    }

    private class SourceDirectories
    implements MinimalFileSet,
    Buildable {
        private SourceDirectories() {
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return DefaultSourceDirectorySet.this.getBuildDependencies();
        }

        @Override
        public Set<File> getFiles() {
            return DefaultSourceDirectorySet.this.getSrcDirs();
        }

        @Override
        public String getDisplayName() {
            return DefaultSourceDirectorySet.this.displayName;
        }
    }
}

