/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalFileSnapshot;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.HashingOutputStream;
import org.gradle.internal.impldep.com.google.common.io.ByteStreams;
import org.gradle.internal.io.NullOutputStream;

public class RuntimeClasspathResourceHasher
implements ResourceHasher {
    @Override
    @Nullable
    public HashCode hash(PhysicalFileSnapshot fileSnapshot) {
        return fileSnapshot.getHash();
    }

    @Override
    public HashCode hash(ZipEntry zipEntry, InputStream zipInput) throws IOException {
        HashingOutputStream hasher = new HashingOutputStream(Hashing.md5(), NullOutputStream.INSTANCE);
        ByteStreams.copy((InputStream)zipInput, (OutputStream)hasher);
        return hasher.hash();
    }

    @Override
    public void appendConfigurationToHasher(BuildCacheHasher hasher) {
        hasher.putString(this.getClass().getName());
    }
}

