/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Map;
import org.gradle.api.internal.changedetection.state.SnapshotSerializer;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

class InputPropertiesSerializer
implements Serializer<ImmutableMap<String, ValueSnapshot>> {
    private final Serializer<ValueSnapshot> snapshotSerializer = new SnapshotSerializer();

    InputPropertiesSerializer() {
    }

    @Override
    public ImmutableSortedMap<String, ValueSnapshot> read(Decoder decoder) throws Exception {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return ImmutableSortedMap.of();
        }
        if (size == 1) {
            return ImmutableSortedMap.of((Comparable)((Object)decoder.readString()), (Object)this.readSnapshot(decoder));
        }
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int i = 0; i < size; ++i) {
            builder.put((Object)decoder.readString(), (Object)this.readSnapshot(decoder));
        }
        return builder.build();
    }

    private ValueSnapshot readSnapshot(Decoder decoder) throws Exception {
        return this.snapshotSerializer.read(decoder);
    }

    @Override
    public void write(Encoder encoder, ImmutableMap<String, ValueSnapshot> properties) throws Exception {
        encoder.writeSmallInt(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            this.writeSnapshot(encoder, (ValueSnapshot)entry.getValue());
        }
    }

    private void writeSnapshot(Encoder encoder, ValueSnapshot snapshot) throws Exception {
        this.snapshotSerializer.write(encoder, snapshot);
    }
}

