/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.changedetection.rules.PropertyDiffListener;
import org.gradle.api.internal.changedetection.rules.SortedMapDiffUtil;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;

@NonNullApi
public abstract class AbstractNamedFileSnapshotTaskStateChanges
implements TaskStateChanges {
    protected final TaskExecution previous;
    protected final TaskExecution current;
    private final String title;

    protected AbstractNamedFileSnapshotTaskStateChanges(TaskExecution previous, TaskExecution current, String title) {
        this.previous = previous;
        this.current = current;
        this.title = title;
    }

    private ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getPrevious() {
        return this.getFingerprints(this.previous);
    }

    private ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getCurrent() {
        return this.getFingerprints(this.current);
    }

    protected abstract ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getFingerprints(TaskExecution var1);

    protected boolean accept(final TaskStateChangeVisitor visitor, final boolean includeAdded) {
        return SortedMapDiffUtil.diff(this.getPrevious(), this.getCurrent(), new PropertyDiffListener<String, FileCollectionFingerprint>(){

            @Override
            public boolean removed(String previousProperty) {
                return true;
            }

            @Override
            public boolean added(String currentProperty) {
                return true;
            }

            @Override
            public boolean updated(String property, FileCollectionFingerprint previousFingerprint, FileCollectionFingerprint currentFingerprint) {
                String propertyTitle = AbstractNamedFileSnapshotTaskStateChanges.this.title + " property '" + property + "'";
                return currentFingerprint.visitChangesSince(previousFingerprint, propertyTitle, includeAdded, visitor);
            }
        });
    }
}

