/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformer;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformFileOperation
implements RunnableBuildOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformFileOperation.class);
    private final File file;
    private final ArtifactTransformer transform;
    private Throwable failure;
    private List<File> result;

    TransformFileOperation(File file, ArtifactTransformer transform) {
        this.file = file;
        this.transform = transform;
    }

    @Override
    public void run(@Nullable BuildOperationContext context) {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Executing transform {} on file {}", (Object)this.transform.getDisplayName(), (Object)this.file);
            }
            this.result = this.transform.transform(this.file);
        }
        catch (Throwable t) {
            this.failure = t;
        }
    }

    @Override
    public BuildOperationDescriptor.Builder description() {
        String displayName = "Transform " + this.file.getName() + " with " + this.transform.getDisplayName();
        return BuildOperationDescriptor.displayName(displayName).progressDisplayName(displayName).operationType(BuildOperationCategory.UNCATEGORIZED);
    }

    @Nullable
    public Throwable getFailure() {
        return this.failure;
    }

    @Nullable
    public List<File> getResult() {
        return this.result;
    }
}

