/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.artifacts.transform.TransformedFileCache;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.changedetection.state.InMemoryCacheDecoratorFactory;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CompositeCleanupAction;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.resource.local.DefaultPathKeyFileStore;
import org.gradle.internal.resource.local.FileAccessTimeJournal;
import org.gradle.internal.resource.local.FileAccessTracker;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.FileStoreAddActionException;
import org.gradle.internal.resource.local.SingleDepthFileAccessTracker;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.util.BiFunction;

public class DefaultTransformedFileCache
implements TransformedFileCache,
Stoppable,
RootBuildLifecycleListener {
    private static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 2;
    private static final String CACHE_PREFIX = CacheLayout.TRANSFORMS_META_DATA.getKey() + "/";
    private final PersistentCache cache;
    private final PersistentIndexedCache<HashCode, List<File>> indexedCache;
    private final FileStore<String> fileStore;
    private final ProducerGuard<CacheKey> producing = ProducerGuard.adaptive();
    private final Map<CacheKey, List<File>> resultHashToResult = new ConcurrentHashMap<CacheKey, List<File>>();
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final FileAccessTracker fileAccessTracker;

    public DefaultTransformedFileCache(ArtifactCacheMetadata artifactCacheMetadata, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory cacheDecoratorFactory, FileSystemSnapshotter fileSystemSnapshotter, FileAccessTimeJournal fileAccessTimeJournal) {
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        File transformsStoreDirectory = artifactCacheMetadata.getTransformsStoreDirectory();
        File filesOutputDirectory = new File(transformsStoreDirectory, CacheLayout.TRANSFORMS_STORE.getKey());
        this.fileStore = new DefaultPathKeyFileStore(filesOutputDirectory);
        this.cache = cacheRepository.cache(transformsStoreDirectory).withCleanup(this.createCleanupAction(filesOutputDirectory, fileAccessTimeJournal)).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withDisplayName("Artifact transforms cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
        this.indexedCache = this.cache.createCache(PersistentIndexedCacheParameters.of(CACHE_PREFIX + "results", new HashCodeSerializer(), new ListSerializer<File>(BaseSerializerFactory.FILE_SERIALIZER)).cacheDecorator(cacheDecoratorFactory.decorator(1000, true)));
        this.fileAccessTracker = new SingleDepthFileAccessTracker(fileAccessTimeJournal, filesOutputDirectory, 2);
    }

    private CleanupAction createCleanupAction(File filesOutputDirectory, FileAccessTimeJournal fileAccessTimeJournal) {
        return CompositeCleanupAction.builder().add(filesOutputDirectory, new LeastRecentlyUsedCacheCleanup(new SingleDepthFilesFinder(2), fileAccessTimeJournal, 7L)).build();
    }

    @Override
    public void stop() {
        this.cache.close();
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeComplete() {
        this.resultHashToResult.clear();
    }

    @Override
    public boolean contains(File absoluteFile, HashCode inputsHash) {
        return this.resultHashToResult.containsKey(this.getCacheKey(absoluteFile, inputsHash));
    }

    @Override
    public List<File> getResult(File inputFile, HashCode inputsHash, BiFunction<List<File>, File, File> transformer) {
        CacheKey resultHash = this.getCacheKey(inputFile, inputsHash);
        List<File> files = this.resultHashToResult.get(resultHash);
        if (files != null) {
            return files;
        }
        return this.loadIntoCache(inputFile, resultHash, transformer);
    }

    private List<File> loadIntoCache(final File inputFile, final CacheKey cacheKey, final BiFunction<List<File>, File, File> transformer) {
        return this.producing.guardByKey(cacheKey, new Factory<List<File>>(){

            @Override
            public List<File> create() {
                List<File> files = (List<File>)DefaultTransformedFileCache.this.resultHashToResult.get(cacheKey);
                if (files != null) {
                    return files;
                }
                files = DefaultTransformedFileCache.this.cache.withFileLock(new Factory<List<File>>(){

                    @Override
                    public List<File> create() {
                        HashCode persistentCacheKey = cacheKey.getPersistentCacheKey();
                        List files = (List)DefaultTransformedFileCache.this.indexedCache.get(persistentCacheKey);
                        if (files != null) {
                            boolean allExist = true;
                            for (File file : files) {
                                if (file.exists()) continue;
                                allExist = false;
                                break;
                            }
                            if (allExist) {
                                return files;
                            }
                        }
                        String key = inputFile.getName() + "/" + persistentCacheKey;
                        TransformAction action = new TransformAction(transformer, inputFile);
                        try {
                            DefaultTransformedFileCache.this.fileStore.add(key, action);
                        }
                        catch (FileStoreAddActionException e) {
                            throw UncheckedException.throwAsUncheckedException(e.getCause());
                        }
                        DefaultTransformedFileCache.this.indexedCache.put(persistentCacheKey, action.result);
                        return action.result;
                    }
                });
                DefaultTransformedFileCache.this.fileAccessTracker.markAccessed(files);
                DefaultTransformedFileCache.this.resultHashToResult.put(cacheKey, files);
                return files;
            }
        });
    }

    private CacheKey getCacheKey(File inputFile, HashCode inputsHash) {
        PhysicalSnapshot snapshot = this.fileSystemSnapshotter.snapshot(inputFile);
        return new CacheKey(inputsHash, snapshot.getAbsolutePath(), snapshot.getHash());
    }

    private static class TransformAction
    implements Action<File> {
        private final BiFunction<List<File>, File, File> transformer;
        private final File inputFile;
        private ImmutableList<File> result;

        TransformAction(BiFunction<List<File>, File, File> transformer, File inputFile) {
            this.transformer = transformer;
            this.inputFile = inputFile;
        }

        @Override
        public void execute(File outputDir) {
            outputDir.mkdirs();
            this.result = ImmutableList.copyOf((Collection)this.transformer.apply(this.inputFile, outputDir));
        }
    }

    private static class CacheKey {
        private final String absolutePath;
        private final HashCode fileContentHash;
        private final HashCode inputHash;

        public CacheKey(HashCode inputHash, String absolutePath, HashCode fileContentHash) {
            this.absolutePath = absolutePath;
            this.fileContentHash = fileContentHash;
            this.inputHash = inputHash;
        }

        public HashCode getPersistentCacheKey() {
            DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
            hasher.putHash(this.inputHash);
            hasher.putString(this.absolutePath);
            hasher.putHash(this.fileContentHash);
            return hasher.hash();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.fileContentHash.equals(cacheKey.fileContentHash)) {
                return false;
            }
            if (!this.inputHash.equals(cacheKey.inputHash)) {
                return false;
            }
            return this.absolutePath.equals(cacheKey.absolutePath);
        }

        public int hashCode() {
            int result = this.fileContentHash.hashCode();
            result = 31 * result + this.absolutePath.hashCode();
            result = 31 * result + this.inputHash.hashCode();
            return result;
        }
    }
}

