/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.VersionConstraintInternal;
import org.gradle.api.internal.artifacts.dependencies.AbstractVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DefaultMutableVersionConstraint
extends AbstractVersionConstraint
implements VersionConstraintInternal {
    private String requiredVersion;
    private String preferredVersion;
    private String strictVersion;
    private String branch;
    private final List<String> rejectedVersions = Lists.newArrayListWithExpectedSize((int)1);

    public DefaultMutableVersionConstraint(VersionConstraint versionConstraint) {
        this(versionConstraint.getPreferredVersion(), versionConstraint.getRequiredVersion(), versionConstraint.getStrictVersion(), versionConstraint.getRejectedVersions());
    }

    public DefaultMutableVersionConstraint(String version) {
        this(version, version, null);
    }

    private DefaultMutableVersionConstraint(String preferredVersion, String requiredVersion, String strictVersion) {
        this(preferredVersion, requiredVersion, strictVersion, Collections.emptyList());
    }

    private DefaultMutableVersionConstraint(String preferredVersion, String requiredVersion, String strictVersion, List<String> rejects) {
        this.updateVersions(preferredVersion, requiredVersion, strictVersion);
        for (String reject : rejects) {
            this.rejectedVersions.add(Strings.nullToEmpty((String)reject));
        }
    }

    private void updateVersions(String preferredVersion, String requiredVersion, String strictVersion) {
        this.preferredVersion = Strings.nullToEmpty((String)preferredVersion);
        this.requiredVersion = Strings.nullToEmpty((String)requiredVersion);
        this.strictVersion = Strings.nullToEmpty((String)strictVersion);
        this.rejectedVersions.clear();
    }

    public static DefaultMutableVersionConstraint withVersion(String version) {
        return new DefaultMutableVersionConstraint(version);
    }

    public static DefaultMutableVersionConstraint withStrictVersion(String version) {
        return new DefaultMutableVersionConstraint(version, version, version);
    }

    @Override
    public ImmutableVersionConstraint asImmutable() {
        return new DefaultImmutableVersionConstraint(this.preferredVersion, this.requiredVersion, this.strictVersion, this.rejectedVersions, this.branch);
    }

    @Override
    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public String getRequiredVersion() {
        return this.requiredVersion;
    }

    @Override
    public String getPreferredVersion() {
        return this.preferredVersion;
    }

    @Override
    public void prefer(String version) {
        this.updateVersions(version, null, null);
    }

    @Override
    public String getStrictVersion() {
        return this.strictVersion;
    }

    @Override
    public void strictly(String version) {
        this.updateVersions(version, version, version);
    }

    @Override
    public void reject(String ... versions) {
        if (versions.length == 0) {
            throw new InvalidUserDataException("The 'reject' clause requires at least one rejected version");
        }
        Collections.addAll(this.rejectedVersions, versions);
    }

    @Override
    public void rejectAll() {
        this.updateVersions(null, null, null);
        this.rejectedVersions.add("+");
    }

    @Override
    public List<String> getRejectedVersions() {
        return this.rejectedVersions;
    }

    public String getVersion() {
        return this.requiredVersion.isEmpty() ? this.preferredVersion : this.requiredVersion;
    }
}

