/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi.impl;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.debugger.streams.psi.PsiElementTransformer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J$\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/debugger/streams/psi/impl/LambdaToAnonymousTransformer;", "Lcom/intellij/debugger/streams/psi/PsiElementTransformer$Base;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "getVisitor", "()Lcom/intellij/psi/PsiElementVisitor;", "getBodyText", "", "lambda", "Lcom/intellij/psi/PsiLambdaExpression;", "isConvertible", "", "lambdaExpression", "overrideOrImplement", "", "Lcom/intellij/codeInsight/generation/PsiGenerationInfo;", "Lcom/intellij/psi/PsiMethod;", "psiClass", "Lcom/intellij/psi/PsiAnonymousClass;", "baseMethod", "qualifyThisExpressions", "", "psiElementFactory", "Lcom/intellij/psi/PsiElementFactory;", "blockFromText", "Lcom/intellij/psi/PsiCodeBlock;", "intellij.java.debugger.streams"})
public final class LambdaToAnonymousTransformer
extends PsiElementTransformer.Base {
    private static final Logger LOG;
    public static final LambdaToAnonymousTransformer INSTANCE;

    @Override
    @NotNull
    protected PsiElementVisitor getVisitor() {
        return (PsiElementVisitor)new JavaRecursiveElementVisitor(){

            /*
             * WARNING - void declaration
             */
            public void visitLambdaExpression(@Nullable PsiLambdaExpression lambdaExpression) {
                List infos;
                if (lambdaExpression == null || !LambdaToAnonymousTransformer.access$isConvertible(LambdaToAnonymousTransformer.INSTANCE, lambdaExpression)) {
                    return;
                }
                PsiElement psiElement = lambdaExpression.getParameterList().copy();
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiParameterList");
                }
                PsiParameter[] psiParameterArray = ((PsiParameterList)psiElement).getParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"(lambdaExpression.parame\u2026ParameterList).parameters");
                PsiParameter[] paramListCopy = psiParameterArray;
                PsiType psiType = lambdaExpression.getFunctionalInterfaceType();
                if (psiType == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"lambdaExpression.functionalInterfaceType ?: return");
                PsiType functionalInterfaceType = psiType;
                PsiMethod psiMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                if (psiMethod == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"LambdaUtil.getFunctional\u2026lInterfaceType) ?: return");
                PsiMethod method = psiMethod;
                String string = LambdaToAnonymousTransformer.access$getBodyText(LambdaToAnonymousTransformer.INSTANCE, lambdaExpression);
                if (string == null) {
                    return;
                }
                String blockText = string;
                Project project = lambdaExpression.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"lambdaExpression.project");
                Project project2 = project;
                PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                PsiCodeBlock psiCodeBlock = psiElementFactory.createCodeBlockFromText(blockText, (PsiElement)lambdaExpression);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiCodeBlock, (String)"psiElementFactory.create\u2026ckText, lambdaExpression)");
                PsiCodeBlock blockFromText = psiCodeBlock;
                PsiElementFactory psiElementFactory2 = psiElementFactory;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElementFactory2, (String)"psiElementFactory");
                LambdaToAnonymousTransformer.access$qualifyThisExpressions(LambdaToAnonymousTransformer.INSTANCE, lambdaExpression, psiElementFactory2, blockFromText);
                PsiCodeBlock psiCodeBlock2 = psiElementFactory.createCodeBlockFromText(blockFromText.getText(), null);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiCodeBlock2, (String)"psiElementFactory.create\u2026blockFromText.text, null)");
                blockFromText = psiCodeBlock2;
                PsiExpression psiExpression = psiElementFactory.createExpressionFromText("new " + functionalInterfaceType.getCanonicalText() + "(){}", (PsiElement)lambdaExpression);
                if (psiExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiNewExpression");
                }
                PsiNewExpression newExpression = (PsiNewExpression)psiExpression;
                PsiElement psiElement2 = lambdaExpression.replace((PsiElement)newExpression);
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiNewExpression");
                }
                newExpression = (PsiNewExpression)psiElement2;
                PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
                LambdaToAnonymousTransformer.access$getLOG$p(LambdaToAnonymousTransformer.INSTANCE).assertTrue(anonymousClass != null);
                PsiAnonymousClass psiAnonymousClass = anonymousClass;
                if (psiAnonymousClass == null) {
                    Intrinsics.throwNpe();
                }
                if ((infos = LambdaToAnonymousTransformer.access$overrideOrImplement(LambdaToAnonymousTransformer.INSTANCE, psiAnonymousClass, method)).size() == 1) {
                    PsiMember psiMember = ((PsiGenerationInfo)infos.get(0)).getPsiMember();
                    if (psiMember == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMember, (String)"infos[0].psiMember!!");
                    PsiMethod member = (PsiMethod)psiMember;
                    PsiParameterList psiParameterList = member.getParameterList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"member.parameterList");
                    PsiParameter[] psiParameterArray2 = psiParameterList.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray2, (String)"member.parameterList.parameters");
                    PsiParameter[] parameters = psiParameterArray2;
                    if (parameters.length == paramListCopy.length) {
                        int n = 0;
                        int n2 = parameters.length;
                        while (n < n2) {
                            void i;
                            PsiParameter parameter = parameters[i];
                            PsiParameter psiParameter = paramListCopy[i];
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"paramListCopy[i]");
                            String lambdaParamName = psiParameter.getName();
                            if (lambdaParamName != null) {
                                parameter.setName(lambdaParamName);
                            }
                            ++i;
                        }
                    }
                    PsiCodeBlock codeBlock = member.getBody();
                    LambdaToAnonymousTransformer.access$getLOG$p(LambdaToAnonymousTransformer.INSTANCE).assertTrue(codeBlock != null);
                    PsiCodeBlock psiCodeBlock3 = codeBlock;
                    if (psiCodeBlock3 == null) {
                        Intrinsics.throwNpe();
                    }
                    psiCodeBlock3.replace((PsiElement)blockFromText);
                    PsiElement psiElement3 = anonymousClass.getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"anonymousClass.parent");
                    PsiElement parent = psiElement3.getParent();
                    if (parent instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)parent))) {
                        PsiExpression operand = ((PsiTypeCastExpression)parent).getOperand();
                        LambdaToAnonymousTransformer.access$getLOG$p(LambdaToAnonymousTransformer.INSTANCE).assertTrue(operand != null);
                        PsiExpression psiExpression2 = operand;
                        if (psiExpression2 == null) {
                            Intrinsics.throwNpe();
                        }
                        parent.replace((PsiElement)psiExpression2);
                    }
                    JavaCodeStyleManager.getInstance((Project)project2).qualifyClassReferences((PsiElement)anonymousClass);
                }
            }
        };
    }

    private final List<PsiGenerationInfo<PsiMethod>> overrideOrImplement(PsiAnonymousClass psiClass, PsiMethod baseMethod) {
        List list2 = OverrideImplementUtil.convert2GenerationInfos((Collection)OverrideImplementUtil.overrideOrImplementMethod((PsiClass)((PsiClass)psiClass), (PsiMethod)baseMethod, (boolean)false));
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"convert2GenerationInfos(\u2026lass, baseMethod, false))");
        List prototypes = list2;
        if (prototypes.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PsiClass psiClass2 = baseMethod.getContainingClass();
        if (psiClass2 == null) {
            Intrinsics.throwNpe();
        }
        PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)psiClass2, (PsiClass)((PsiClass)psiClass), (PsiSubstitutor)PsiSubstitutor.EMPTY);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"TypeConversionUtil.getSu\u2026ss, PsiSubstitutor.EMPTY)");
        PsiSubstitutor substitutor = psiSubstitutor;
        PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement((PsiClass)((PsiClass)psiClass), (PsiMethod)baseMethod, (PsiSubstitutor)substitutor);
        List list3 = GenerateMembersUtil.insertMembersBeforeAnchor((PsiClass)((PsiClass)psiClass), (PsiElement)anchor, (List)prototypes);
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"GenerateMembersUtil.inse\u2026lass, anchor, prototypes)");
        return list3;
    }

    private final String getBodyText(PsiLambdaExpression lambda2) {
        String blockText;
        PsiElement body = lambda2.getBody();
        if (body instanceof PsiExpression) {
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)lambda2));
            blockText = "{";
            blockText = blockText + (Intrinsics.areEqual((Object)PsiType.VOID, (Object)returnType) ? "" : "return ");
            blockText = blockText + ((PsiExpression)body).getText() + ";}";
        } else {
            blockText = body != null ? body.getText() : (String)null;
        }
        return blockText;
    }

    private final void qualifyThisExpressions(PsiLambdaExpression lambdaExpression, PsiElementFactory psiElementFactory, PsiCodeBlock blockFromText) {
        String thisClassName;
        ChangeContextUtil.encodeContextInfo((PsiElement)((PsiElement)blockFromText), (boolean)true);
        PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)((PsiElement)lambdaExpression));
        String string = thisClassName = thisClass != null && !(thisClass instanceof PsiSyntheticClass) ? thisClass.getName() : null;
        if (thisClassName != null) {
            PsiThisExpression thisAccessExpr = RefactoringChangeUtil.createThisExpression((PsiManager)lambdaExpression.getManager(), (PsiClass)thisClass);
            ChangeContextUtil.decodeContextInfo((PsiElement)((PsiElement)blockFromText), (PsiClass)thisClass, (PsiExpression)((PsiExpression)thisAccessExpr));
            HashSet replacements = new HashSet();
            blockFromText.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(replacements, thisAccessExpr){
                final /* synthetic */ HashSet $replacements;
                final /* synthetic */ PsiThisExpression $thisAccessExpr;

                public void visitClass(@NotNull PsiClass aClass) {
                    Intrinsics.checkParameterIsNotNull((Object)aClass, (String)"aClass");
                }

                public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    super.visitSuperExpression(expression);
                    if (expression.getQualifier() == null) {
                        this.$replacements.add(expression);
                    }
                }

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    super.visitMethodCallExpression(expression);
                    if (this.$thisAccessExpr != null) {
                        PsiMethod psiMethod = expression.resolveMethod();
                        PsiReferenceExpression psiReferenceExpression = expression.getMethodExpression();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression, (String)"expression.methodExpression");
                        PsiReferenceExpression methodExpression = psiReferenceExpression;
                        if (psiMethod != null && !psiMethod.hasModifierProperty("static") && methodExpression.getQualifierExpression() == null) {
                            this.$replacements.add(expression);
                        }
                    }
                }
                {
                    this.$replacements = $captured_local_variable$0;
                    this.$thisAccessExpr = $captured_local_variable$1;
                }
            });
            for (PsiExpression expression : replacements) {
                PsiExpression psiExpression = expression;
                if (psiExpression instanceof PsiSuperExpression) {
                    expression.replace((PsiElement)psiElementFactory.createExpressionFromText(thisClassName + "." + expression.getText(), (PsiElement)expression));
                    continue;
                }
                if (psiExpression instanceof PsiMethodCallExpression) {
                    PsiExpression psiExpression2 = expression;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiExpression2, (String)"expression");
                    PsiReferenceExpression psiReferenceExpression = ((PsiMethodCallExpression)psiExpression2).getMethodExpression();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression, (String)"expression.methodExpression");
                    psiReferenceExpression.setQualifierExpression((PsiExpression)thisAccessExpr);
                    continue;
                }
                LOG.error("Unexpected expression");
            }
        }
    }

    private final boolean isConvertible(PsiLambdaExpression lambdaExpression) {
        PsiMethod interfaceMethod;
        PsiType functionalInterfaceType;
        PsiClass thisClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)lambdaExpression), PsiClass.class, (boolean)true);
        if (thisClass == null || thisClass instanceof PsiAnonymousClass) {
            PsiElement psiElement = lambdaExpression.getBody();
            if (psiElement == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"lambdaExpression.body ?: return false");
            PsiElement body = psiElement;
            boolean[] disabled = new boolean[1];
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(disabled){
                final /* synthetic */ boolean[] $disabled;

                public void visitThisExpression(@NotNull PsiThisExpression expression) {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    this.$disabled[0] = true;
                }

                public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    this.$disabled[0] = true;
                }
                {
                    this.$disabled = $captured_local_variable$0;
                }
            });
            if (disabled[0]) {
                return false;
            }
        }
        if ((functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType()) != null && LambdaUtil.isFunctionalType((PsiType)functionalInterfaceType) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType)) != null) {
            boolean bl;
            block6: {
                PsiType[] $receiver$iv;
                PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType));
                MethodSignature methodSignature = interfaceMethod.getSignature(substitutor);
                Intrinsics.checkExpressionValueIsNotNull((Object)methodSignature, (String)"interfaceMethod.getSignature(substitutor)");
                PsiType[] psiTypeArray = methodSignature.getParameterTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"interfaceMethod.getSigna\u2026bstitutor).parameterTypes");
                for (PsiType element$iv : $receiver$iv = psiTypeArray) {
                    PsiType it = element$iv;
                    if (!(!PsiTypesUtil.isDenotableType((PsiType)it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
            return PsiTypesUtil.isDenotableType((PsiType)returnType);
        }
        return false;
    }

    private LambdaToAnonymousTransformer() {
    }

    static {
        LambdaToAnonymousTransformer lambdaToAnonymousTransformer;
        INSTANCE = lambdaToAnonymousTransformer = new LambdaToAnonymousTransformer();
        Logger logger = Logger.getInstance((String)("#" + LambdaToAnonymousTransformer.class.getName()));
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#\" +\u2026sformer::class.java.name)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$isConvertible(LambdaToAnonymousTransformer $this, @NotNull PsiLambdaExpression lambdaExpression) {
        return $this.isConvertible(lambdaExpression);
    }

    @Nullable
    public static final /* synthetic */ String access$getBodyText(LambdaToAnonymousTransformer $this, @NotNull PsiLambdaExpression lambda2) {
        return $this.getBodyText(lambda2);
    }

    public static final /* synthetic */ void access$qualifyThisExpressions(LambdaToAnonymousTransformer $this, @NotNull PsiLambdaExpression lambdaExpression, @NotNull PsiElementFactory psiElementFactory, @NotNull PsiCodeBlock blockFromText) {
        $this.qualifyThisExpressions(lambdaExpression, psiElementFactory, blockFromText);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p(LambdaToAnonymousTransformer $this) {
        LambdaToAnonymousTransformer lambdaToAnonymousTransformer = $this;
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ List access$overrideOrImplement(LambdaToAnonymousTransformer $this, @NotNull PsiAnonymousClass psiClass, @NotNull PsiMethod baseMethod) {
        return $this.overrideOrImplement(psiClass, baseMethod);
    }
}

