/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ModelFactory;

public class DefaultExternalSourceSet
implements ExternalSourceSet {
    private static final long serialVersionUID = 1L;
    private String myName;
    private Map<IExternalSystemSourceType, ExternalSourceDirectorySet> mySources = new HashMap<IExternalSystemSourceType, ExternalSourceDirectorySet>();
    private final Collection<ExternalDependency> myDependencies = new LinkedHashSet<ExternalDependency>();
    private Collection<File> myArtifacts = new ArrayList<File>();
    private String mySourceCompatibility;
    private String myTargetCompatibility;

    public DefaultExternalSourceSet() {
    }

    public DefaultExternalSourceSet(ExternalSourceSet sourceSet) {
        this();
        this.myName = sourceSet.getName();
        this.mySourceCompatibility = sourceSet.getSourceCompatibility();
        this.myTargetCompatibility = sourceSet.getTargetCompatibility();
        for (Map.Entry entry : sourceSet.getSources().entrySet()) {
            this.mySources.put((IExternalSystemSourceType)ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)entry.getKey())), new DefaultExternalSourceDirectorySet((ExternalSourceDirectorySet)entry.getValue()));
        }
        for (ExternalDependency dependency : sourceSet.getDependencies()) {
            this.myDependencies.add(ModelFactory.createCopy(dependency));
        }
        this.myArtifacts = sourceSet.getArtifacts() == null ? new ArrayList<File>() : new ArrayList(sourceSet.getArtifacts());
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DefaultExternalSourceSet.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Collection<File> getArtifacts() {
        return this.myArtifacts;
    }

    public void setArtifacts(Collection<File> artifacts) {
        this.myArtifacts = artifacts;
    }

    @Nullable
    public String getSourceCompatibility() {
        return this.mySourceCompatibility;
    }

    public void setSourceCompatibility(@Nullable String sourceCompatibility) {
        this.mySourceCompatibility = sourceCompatibility;
    }

    @Nullable
    public String getTargetCompatibility() {
        return this.myTargetCompatibility;
    }

    public void setTargetCompatibility(@Nullable String targetCompatibility) {
        this.myTargetCompatibility = targetCompatibility;
    }

    public Collection<ExternalDependency> getDependencies() {
        return this.myDependencies;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @NotNull
    public Map<IExternalSystemSourceType, ExternalSourceDirectorySet> getSources() {
        Map<IExternalSystemSourceType, ExternalSourceDirectorySet> map = this.mySources;
        if (map == null) {
            DefaultExternalSourceSet.$$$reportNull$$$0(1);
        }
        return map;
    }

    public void setSources(Map<IExternalSystemSourceType, ExternalSourceDirectorySet> sources) {
        this.mySources = sources;
    }

    public String toString() {
        return "sourceSet '" + this.myName + '\'';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/gradle/model/DefaultExternalSourceSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

