/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.maven;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class MavenRepositoriesHolder {
    private static final String UNINDEXED_MAVEN_REPOSITORIES_NOTIFICATION_GROUP = "Unindexed maven repositories gradle detection";
    private static final Key<String> NOTIFICATION_KEY = Key.create((String)"Unindexed maven repositories gradle detection");
    private final Project myProject;
    private volatile Set<MavenRemoteRepository> myRemoteRepositories;
    private volatile Set<String> myNotIndexedUrls;

    public MavenRepositoriesHolder(Project project) {
        this.myProject = project;
        this.myRemoteRepositories = Collections.emptySet();
        this.myNotIndexedUrls = Collections.emptySet();
    }

    public void updateNotIndexedUrls(List<String> repositories) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (repositories.isEmpty()) {
            this.myNotIndexedUrls = Collections.emptySet();
            ExternalSystemNotificationManager.getInstance((Project)this.myProject).clearNotifications(UNINDEXED_MAVEN_REPOSITORIES_NOTIFICATION_GROUP, NotificationSource.PROJECT_SYNC, GradleConstants.SYSTEM_ID);
        } else {
            this.myNotIndexedUrls = ContainerUtil.newHashSet(repositories);
        }
    }

    public void checkNotIndexedRepositories() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ExternalSystemNotificationManager notificationManager = ExternalSystemNotificationManager.getInstance((Project)this.myProject);
        if (ContainerUtil.isEmpty(this.myNotIndexedUrls)) {
            return;
        }
        if (notificationManager.isNotificationActive(NOTIFICATION_KEY)) {
            return;
        }
        final MavenIndicesManager indicesManager = MavenIndicesManager.getInstance();
        for (MavenIndex index : indicesManager.getIndices()) {
            if (indicesManager.getUpdatingState(index) == MavenIndicesManager.IndexUpdatingState.IDLE) continue;
            return;
        }
        NotificationData notificationData = new NotificationData(GradleBundle.message((String)"gradle.integrations.maven.notification.not_updated_repository.title", (Object[])new Object[0]), "\n<br>" + GradleBundle.message((String)"gradle.integrations.maven.notification.not_updated_repository.text", (Object[])new Object[0]), NotificationCategory.INFO, NotificationSource.PROJECT_SYNC);
        notificationData.setBalloonNotification(true);
        notificationData.setBalloonGroup(UNINDEXED_MAVEN_REPOSITORIES_NOTIFICATION_GROUP);
        notificationData.setListener("#update", (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                List notIndexed = indicesManager.getIndices().stream().filter(index -> MavenRepositoriesHolder.this.isNotIndexed(index.getRepositoryPathOrUrl())).collect(Collectors.toList());
                indicesManager.scheduleUpdate(MavenRepositoriesHolder.this.myProject, notIndexed).onSuccess(aVoid -> {
                    if (MavenRepositoriesHolder.this.myNotIndexedUrls.isEmpty()) {
                        return;
                    }
                    for (MavenIndex index : notIndexed) {
                        if (index.getUpdateTimestamp() == -1L && index.getFailureMessage() == null) continue;
                        MavenRepositoriesHolder.this.myNotIndexedUrls.remove(index.getRepositoryPathOrUrl());
                    }
                });
                notification.hideBalloon();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/gradle/integrations/maven/MavenRepositoriesHolder$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notificationData.setListener("#disable", (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                int result;
                if (notification == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((result = Messages.showYesNoDialog((Project)MavenRepositoriesHolder.this.myProject, (String)"Notification will be disabled for all projects.\n\nSettings | Appearance & Behavior | Notifications | Unindexed maven repositories gradle detection\ncan be used to configure the notification.", (String)"Unindexed Maven Repositories Gradle Detection", (String)"Disable Notification", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon())) == 0) {
                    NotificationsConfigurationImpl.getInstanceImpl().changeSettings(MavenRepositoriesHolder.UNINDEXED_MAVEN_REPOSITORIES_NOTIFICATION_GROUP, NotificationDisplayType.NONE, false, false);
                    notification.hideBalloon();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/gradle/integrations/maven/MavenRepositoriesHolder$2";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notificationManager.showNotification(GradleConstants.SYSTEM_ID, notificationData, NOTIFICATION_KEY);
    }

    public static MavenRepositoriesHolder getInstance(Project p) {
        return (MavenRepositoriesHolder)p.getComponent(MavenRepositoriesHolder.class);
    }

    public void update(Set<MavenRemoteRepository> remoteRepositories) {
        this.myRemoteRepositories = ContainerUtil.newHashSet(remoteRepositories);
    }

    public Set<MavenRemoteRepository> getRemoteRepositories() {
        return Collections.unmodifiableSet(this.myRemoteRepositories);
    }

    public boolean contains(String url) {
        String pathOrUrl = MavenIndex.normalizePathOrUrl((String)url);
        for (MavenRemoteRepository repository : this.myRemoteRepositories) {
            if (!MavenIndex.normalizePathOrUrl((String)repository.getUrl()).equals(pathOrUrl)) continue;
            return true;
        }
        return false;
    }

    public boolean isNotIndexed(String url) {
        String pathOrUrl = MavenIndex.normalizePathOrUrl((String)url);
        for (String repository : this.myNotIndexedUrls) {
            if (!MavenIndex.normalizePathOrUrl((String)repository).equals(pathOrUrl)) continue;
            return true;
        }
        return false;
    }
}

