/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.build.BuildViewManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.JpsProjectTaskRunner;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.build.GradleBuildTasksProvider;
import org.jetbrains.plugins.gradle.execution.build.GradleExecutionEnvironmentProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectTaskRunner
extends ProjectTaskRunner {
    @Language(value="Groovy")
    private static final String FORCE_COMPILE_TASKS_INIT_SCRIPT_TEMPLATE = "projectsEvaluated { \n  rootProject.findProject('%s')?.tasks?.withType(AbstractCompile) {  \n    outputs.upToDateWhen { false } \n  } \n}\n";

    public void run(final @NotNull Project project, @NotNull ProjectTaskContext context, final @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        if (project == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(2);
        }
        MultiMap buildTasksMap = MultiMap.createLinkedSet();
        MultiMap cleanTasksMap = MultiMap.createLinkedSet();
        MultiMap initScripts = MultiMap.createLinkedSet();
        Map taskMap = JpsProjectTaskRunner.groupBy(tasks);
        final List<Module> modules = GradleProjectTaskRunner.addModulesBuildTasks((Collection)taskMap.get(ModuleBuildTask.class), (MultiMap<String, String>)buildTasksMap, (MultiMap<String, String>)initScripts);
        final List<Module> modulesOfFiles = GradleProjectTaskRunner.addModulesBuildTasks((Collection)taskMap.get(ModuleFilesBuildTask.class), (MultiMap<String, String>)buildTasksMap, (MultiMap<String, String>)initScripts);
        GradleProjectTaskRunner.addArtifactsBuildTasks((Collection)taskMap.get(ProjectModelBuildTask.class), (MultiMap<String, String>)cleanTasksMap, (MultiMap<String, String>)buildTasksMap);
        final Set rootPaths = buildTasksMap.keySet();
        final AtomicInteger successCounter = new AtomicInteger();
        final AtomicInteger errorCounter = new AtomicInteger();
        TaskCallback taskCallback = callback == null ? null : new TaskCallback(){

            public void onSuccess() {
                this.handle(true);
            }

            public void onFailure() {
                this.handle(false);
            }

            private void handle(boolean success) {
                int errors;
                int successes = success ? successCounter.incrementAndGet() : successCounter.get();
                int n = errors = success ? errorCounter.get() : errorCounter.incrementAndGet();
                if (successes + errors == rootPaths.size()) {
                    List affectedModules;
                    HashSet affectedRoots;
                    if (!project.isDisposed() && !(affectedRoots = ContainerUtil.newHashSet((Object[])CompilerPathsEx.getOutputPaths((Module[])(affectedModules = ContainerUtil.concat((List)modules, (List)modulesOfFiles)).toArray(Module.EMPTY_ARRAY)))).isEmpty()) {
                        CompilerUtil.refreshOutputRoots((Collection)affectedRoots);
                    }
                    callback.finished(new ProjectTaskResult(false, errors, 0));
                }
            }
        };
        String compilerOptionsInitScript = "allprojects {\n  tasks.withType(JavaCompile) {\n    options.compilerArgs += [\"-Xlint:deprecation\"]\n  }}\n";
        String gradleVmOptions = GradleSettings.getInstance((Project)project).getGradleVmOptions();
        for (String rootProjectPath : rootPaths) {
            Collection buildTasks = buildTasksMap.get((Object)rootProjectPath);
            if (buildTasks.isEmpty()) continue;
            Collection cleanTasks = cleanTasksMap.get((Object)rootProjectPath);
            ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
            File projectFile = new File(rootProjectPath);
            String projectName = projectFile.isFile() ? projectFile.getParentFile().getName() : projectFile.getName();
            String executionName = "Build " + projectName;
            settings.setExecutionName(executionName);
            settings.setExternalProjectPath(rootProjectPath);
            settings.setTaskNames(ContainerUtil.collect(ContainerUtil.concat((Iterable[])new Iterable[]{cleanTasks, buildTasks}).iterator()));
            settings.setVmOptions(gradleVmOptions);
            settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
            UserDataHolderBase userData = new UserDataHolderBase();
            userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, BuildViewManager.class);
            Collection scripts = initScripts.getModifiable((Object)rootProjectPath);
            scripts.add(compilerOptionsInitScript);
            userData.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)StringUtil.join((Collection)scripts, (String)SystemProperties.getLineSeparator()));
            userData.putUserData(GradleTaskManager.INIT_SCRIPT_PREFIX_KEY, (Object)executionName);
            ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)DefaultRunExecutor.EXECUTOR_ID, (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)taskCallback, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)false, (UserDataHolderBase)userData);
        }
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        ProjectModelBuildTask buildTask;
        if (projectTask == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(3);
        }
        if (!GradleSystemRunningSettings.getInstance().isUseGradleAwareMake()) {
            return false;
        }
        if (projectTask instanceof ModuleBuildTask) {
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)((ModuleBuildTask)projectTask).getModule());
        }
        if (projectTask instanceof ProjectModelBuildTask && (buildTask = (ProjectModelBuildTask)projectTask).getBuildableElement() instanceof Artifact) {
            for (GradleBuildTasksProvider gradleBuildTasksProvider : (GradleBuildTasksProvider[])GradleBuildTasksProvider.EP_NAME.getExtensions()) {
                if (!gradleBuildTasksProvider.isApplicable(buildTask)) continue;
                return true;
            }
        }
        if (projectTask instanceof ExecuteRunConfigurationTask) {
            RunConfigurationModule module;
            RunProfile runProfile = ((ExecuteRunConfigurationTask)projectTask).getRunProfile();
            if (runProfile instanceof ModuleBasedConfiguration && !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)(module = ((ModuleBasedConfiguration)runProfile).getConfigurationModule()).getModule())) {
                return false;
            }
            for (GradleBuildTasksProvider gradleBuildTasksProvider : (GradleExecutionEnvironmentProvider[])GradleExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
                if (!gradleBuildTasksProvider.isApplicable((ExecuteRunConfigurationTask)projectTask)) continue;
                return true;
            }
        }
        return false;
    }

    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask task, @Nullable Executor executor) {
        if (project == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(4);
        }
        if (task == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(5);
        }
        for (GradleExecutionEnvironmentProvider environmentProvider : (GradleExecutionEnvironmentProvider[])GradleExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
            if (!environmentProvider.isApplicable(task)) continue;
            return environmentProvider.createExecutionEnvironment(project, task, executor);
        }
        return null;
    }

    private static List<Module> addModulesBuildTasks(@Nullable Collection<? extends ProjectTask> projectTasks, @NotNull MultiMap<String, String> buildTasksMap, @NotNull MultiMap<String, String> initScripts) {
        if (buildTasksMap == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(6);
        }
        if (initScripts == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(7);
        }
        if (ContainerUtil.isEmpty(projectTasks)) {
            return Collections.emptyList();
        }
        SmartList affectedModules = new SmartList();
        Map rootPathsMap = FactoryMap.create(module -> StringUtil.notNullize((String)GradleRunnerUtil.resolveProjectPath(module)));
        CachedModuleDataFinder moduleDataFinder = new CachedModuleDataFinder();
        for (ProjectTask projectTask : projectTasks) {
            String gradlePath;
            DataNode moduleDataNode;
            String externalProjectPath;
            String projectId;
            if (!(projectTask instanceof ModuleBuildTask)) continue;
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            Module module2 = moduleBuildTask.getModule();
            affectedModules.add(module2);
            String rootProjectPath = (String)rootPathsMap.get(module2);
            if (StringUtil.isEmpty((String)rootProjectPath) || (projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module2)) == null || (externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module2)) == null || StringUtil.endsWith((CharSequence)externalProjectPath, (CharSequence)"buildSrc") || (moduleDataNode = moduleDataFinder.findMainModuleData(module2)) == null || Boolean.parseBoolean(((ModuleData)moduleDataNode.getData()).getProperty("buildSrcModule")) || (gradlePath = GradleProjectResolverUtil.getGradlePath((Module)module2)) == null) continue;
            String taskPrefix = StringUtil.endsWithChar((CharSequence)gradlePath, (char)':') ? gradlePath : gradlePath + ':';
            List gradleTasks = ContainerUtil.mapNotNull((Collection)ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TASK), node -> ((TaskData)node.getData()).isInherited() ? null : StringUtil.trimStart((String)((TaskData)node.getData()).getName(), (String)taskPrefix));
            Collection projectInitScripts = initScripts.getModifiable((Object)rootProjectPath);
            Collection buildRootTasks = buildTasksMap.getModifiable((Object)rootProjectPath);
            String moduleType = ExternalSystemApiUtil.getExternalModuleType((Module)module2);
            if (!moduleBuildTask.isIncrementalBuild()) {
                projectInitScripts.add(String.format(FORCE_COMPILE_TASKS_INIT_SCRIPT_TEMPLATE, gradlePath));
            }
            String assembleTask = "assemble";
            if ("sourceSet".equals(moduleType)) {
                String gradleTask;
                String sourceSetName = GradleProjectResolverUtil.getSourceSetName((Module)module2);
                String string = gradleTask = StringUtil.isEmpty((String)sourceSetName) || "main".equals(sourceSetName) ? "classes" : sourceSetName + "Classes";
                if (gradleTasks.contains(gradleTask)) {
                    buildRootTasks.add(taskPrefix + gradleTask);
                    continue;
                }
                if (!"main".equals(sourceSetName) && !"test".equals(sourceSetName)) continue;
                buildRootTasks.add(taskPrefix + assembleTask);
                continue;
            }
            if (gradleTasks.contains("classes")) {
                buildRootTasks.add(taskPrefix + "classes");
                buildRootTasks.add(taskPrefix + "testClasses");
                continue;
            }
            if (!gradleTasks.contains(assembleTask)) continue;
            buildRootTasks.add(taskPrefix + assembleTask);
        }
        return affectedModules;
    }

    private static void addArtifactsBuildTasks(@Nullable Collection<? extends ProjectTask> tasks, @NotNull MultiMap<String, String> cleanTasksMap, @NotNull MultiMap<String, String> buildTasksMap) {
        if (cleanTasksMap == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(8);
        }
        if (buildTasksMap == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(9);
        }
        if (ContainerUtil.isEmpty(tasks)) {
            return;
        }
        for (ProjectTask projectTask : tasks) {
            if (!(projectTask instanceof ProjectModelBuildTask)) continue;
            ProjectModelBuildTask projectModelBuildTask = (ProjectModelBuildTask)projectTask;
            for (GradleBuildTasksProvider buildTasksProvider : (GradleBuildTasksProvider[])GradleBuildTasksProvider.EP_NAME.getExtensions()) {
                if (!buildTasksProvider.isApplicable(projectModelBuildTask)) continue;
                buildTasksProvider.addBuildTasks(projectModelBuildTask, (Consumer<ExternalTaskPojo>)((Consumer)task -> {
                    if (cleanTasksMap == null) {
                        GradleProjectTaskRunner.$$$reportNull$$$0(11);
                    }
                    cleanTasksMap.putValue((Object)task.getLinkedExternalProjectPath(), (Object)task.getName());
                }), (Consumer<ExternalTaskPojo>)((Consumer)task -> {
                    if (buildTasksMap == null) {
                        GradleProjectTaskRunner.$$$reportNull$$$0(10);
                    }
                    buildTasksMap.putValue((Object)task.getLinkedExternalProjectPath(), (Object)task.getName());
                }));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTasksMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScripts";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanTasksMap";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createExecutionEnvironment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addModulesBuildTasks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addArtifactsBuildTasks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addArtifactsBuildTasks$3";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addArtifactsBuildTasks$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

