/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.BaseLineInfo;
import com.jetbrains.sa.jdi.CompatibilityHelper;
import com.jetbrains.sa.jdi.ConcreteMethodImpl;
import com.jetbrains.sa.jdi.LineInfo;
import com.jetbrains.sa.jdi.LocalVariableImpl;
import com.jetbrains.sa.jdi.LocationImpl;
import com.jetbrains.sa.jdi.NonConcreteMethodImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.SDE;
import com.jetbrains.sa.jdi.StratumLineInfo;
import com.jetbrains.sa.jdi.TypeComponentImpl;
import com.sun.jdi.AbsentInformationException;
import java.util.List;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Symbol;

public abstract class MethodImpl
extends TypeComponentImpl {
    Method saMethod;

    public abstract int argSlotCount();

    abstract List<LocationImpl> allLineLocations(SDE.Stratum var1) throws AbsentInformationException;

    static MethodImpl createMethodImpl(ReferenceTypeImpl declaringType, Method saMethod) {
        if (saMethod.isNative() || saMethod.isAbstract()) {
            return new NonConcreteMethodImpl(declaringType, saMethod);
        }
        return new ConcreteMethodImpl(declaringType, saMethod);
    }

    MethodImpl(ReferenceTypeImpl declaringType, Method saMethod) {
        super(declaringType);
        this.saMethod = saMethod;
        this.signature = saMethod.getSignature().asString();
    }

    public Method ref() {
        return this.saMethod;
    }

    public long uniqueID() {
        return this.vm().getAddressValue(CompatibilityHelper.INSTANCE.getAddress(this.saMethod));
    }

    public String genericSignature() {
        Symbol genSig = this.saMethod.getGenericSignature();
        return genSig != null ? genSig.asString() : null;
    }

    public boolean isNative() {
        return this.saMethod.isNative();
    }

    public boolean isObsolete() {
        return this.saMethod.isObsolete();
    }

    public final List<LocationImpl> allLineLocations() throws AbsentInformationException {
        return this.allLineLocations(this.declaringType.stratum(null));
    }

    LineInfo codeIndexToLineInfo(SDE.Stratum stratum, long codeIndex) {
        if (stratum.isJava()) {
            return new BaseLineInfo(-1, this.declaringType);
        }
        return new StratumLineInfo(stratum.id(), -1, null, null);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodImpl) {
            MethodImpl other = (MethodImpl)obj;
            return this.declaringType().equals(other.declaringType()) && this.ref().equals((Object)other.ref()) && super.equals(obj);
        }
        return false;
    }

    int compareTo(MethodImpl method) {
        ReferenceTypeImpl declaringType = this.declaringType();
        int rc = declaringType.compareTo(method.declaringType());
        if (rc == 0) {
            rc = declaringType.indexOf(this) - declaringType.indexOf(method);
        }
        return rc;
    }

    public String toString() {
        return this.declaringType().name() + "." + this.name() + this.signature;
    }

    @Override
    public String name() {
        Symbol myName = this.saMethod.getName();
        return myName.asString();
    }

    @Override
    public int modifiers() {
        return this.saMethod.getAccessFlagsObj().getStandardFlags();
    }

    @Override
    public boolean isStatic() {
        return this.saMethod.isStatic();
    }

    @Override
    public int hashCode() {
        return this.saMethod.hashCode();
    }

    public abstract List<LocalVariableImpl> variables() throws AbsentInformationException;

    public abstract byte[] bytecodes();
}

