/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationFileCrcFactory {
    private final Project myProject;
    private final VirtualFile myFile;

    public ConfigurationFileCrcFactory(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ConfigurationFileCrcFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ConfigurationFileCrcFactory.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFile = file;
    }

    public long create() {
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (psiFile != null) {
            CRC32 crc32 = this.createCrcUsingLexer(psiFile);
            if (crc32 == null) {
                crc32 = this.createCrcUsingWordsScanner(psiFile);
            }
            if (crc32 == null) {
                crc32 = ConfigurationFileCrcFactory.createCrcUsingPsi(psiFile);
            }
            return crc32.getValue();
        }
        return this.myFile.getModificationStamp();
    }

    @Nullable
    private CRC32 createCrcUsingLexer(@NotNull PsiFile psiFile) {
        IElementType tokenType;
        TokenSet ignoredTokens;
        Lexer lexer;
        if (psiFile == null) {
            ConfigurationFileCrcFactory.$$$reportNull$$$0(2);
        }
        if (psiFile instanceof PsiFileBase) {
            ParserDefinition parserDefinition = ((PsiFileBase)psiFile).getParserDefinition();
            lexer = parserDefinition.createLexer(this.myProject);
            ignoredTokens = TokenSet.andSet((TokenSet)parserDefinition.getCommentTokens(), (TokenSet)parserDefinition.getWhitespaceTokens());
        } else {
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)psiFile.getFileType(), (Project)this.myProject, (VirtualFile)this.myFile);
            if (syntaxHighlighter == null) {
                return null;
            }
            lexer = syntaxHighlighter.getHighlightingLexer();
            ignoredTokens = TokenSet.WHITE_SPACE;
        }
        CRC32 crc32 = new CRC32();
        lexer.start((CharSequence)psiFile.getText());
        while ((tokenType = lexer.getTokenType()) != null) {
            String tokenText;
            if (!(ignoredTokens.contains(tokenType) || CacheUtil.isInComments((IElementType)tokenType) || CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)(tokenText = lexer.getTokenText())))) {
                int end = tokenText.length();
                for (int i = 0; i < end; ++i) {
                    crc32.update(tokenText.charAt(i));
                }
            }
            lexer.advance();
        }
        return crc32;
    }

    @Nullable
    private CRC32 createCrcUsingWordsScanner(@NotNull PsiFile psiFile) {
        WordsScanner wordsScanner;
        if (psiFile == null) {
            ConfigurationFileCrcFactory.$$$reportNull$$$0(3);
        }
        if ((wordsScanner = ConfigurationFileCrcFactory.getScanner(this.myFile)) == null) {
            return null;
        }
        CRC32 crc32 = new CRC32();
        wordsScanner.processWords((CharSequence)psiFile.getText(), occurrence -> {
            if (occurrence.getKind() != WordOccurrence.Kind.COMMENTS) {
                CharSequence currentWord = occurrence.getBaseText().subSequence(occurrence.getStart(), occurrence.getEnd());
                int end = currentWord.length();
                for (int i = 0; i < end; ++i) {
                    crc32.update(currentWord.charAt(i));
                }
            }
            return true;
        });
        return crc32;
    }

    @Nullable
    private static WordsScanner getScanner(VirtualFile file) {
        FileType fileType = file.getFileType();
        WordsScanner customWordsScanner = CacheBuilderRegistry.getInstance().getCacheBuilder(fileType);
        if (customWordsScanner != null) {
            return customWordsScanner;
        }
        if (fileType instanceof LanguageFileType) {
            Language lang = ((LanguageFileType)fileType).getLanguage();
            return LanguageFindUsages.getWordsScanner((Language)lang);
        }
        return null;
    }

    private static CRC32 createCrcUsingPsi(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ConfigurationFileCrcFactory.$$$reportNull$$$0(4);
        }
        final CRC32 crc32 = new CRC32();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (psiFile == null) {
                ConfigurationFileCrcFactory.$$$reportNull$$$0(5);
            }
            psiFile.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    String text;
                    if (element instanceof LeafElement && !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment) && !(text = element.getText()).trim().isEmpty()) {
                        int end = text.length();
                        for (int i = 0; i < end; ++i) {
                            crc32.update(text.charAt(i));
                        }
                    }
                    super.visitElement(element);
                }
            });
        });
        return crc32;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ConfigurationFileCrcFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCrcUsingLexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createCrcUsingWordsScanner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createCrcUsingPsi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createCrcUsingPsi$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

